/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The criteria to initiate the increase in rate of rollout for a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsJobRateIncreaseCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsJobRateIncreaseCriteria.Builder, AwsJobRateIncreaseCriteria> {
    private static final SdkField<Integer> NUMBER_OF_NOTIFIED_THINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfNotifiedThings").getter(getter(AwsJobRateIncreaseCriteria::numberOfNotifiedThings))
            .setter(setter(Builder::numberOfNotifiedThings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfNotifiedThings").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_SUCCEEDED_THINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfSucceededThings").getter(getter(AwsJobRateIncreaseCriteria::numberOfSucceededThings))
            .setter(setter(Builder::numberOfSucceededThings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfSucceededThings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NUMBER_OF_NOTIFIED_THINGS_FIELD, NUMBER_OF_SUCCEEDED_THINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer numberOfNotifiedThings;

    private final Integer numberOfSucceededThings;

    private AwsJobRateIncreaseCriteria(BuilderImpl builder) {
        this.numberOfNotifiedThings = builder.numberOfNotifiedThings;
        this.numberOfSucceededThings = builder.numberOfSucceededThings;
    }

    /**
     * <p>
     * When this number of things have been notified, it will initiate an increase in the rollout rate.
     * </p>
     * 
     * @return When this number of things have been notified, it will initiate an increase in the rollout rate.
     */
    public final Integer numberOfNotifiedThings() {
        return numberOfNotifiedThings;
    }

    /**
     * <p>
     * When this number of things have succeeded in their job execution, it will initiate an increase in the rollout
     * rate.
     * </p>
     * 
     * @return When this number of things have succeeded in their job execution, it will initiate an increase in the
     *         rollout rate.
     */
    public final Integer numberOfSucceededThings() {
        return numberOfSucceededThings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberOfNotifiedThings());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfSucceededThings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsJobRateIncreaseCriteria)) {
            return false;
        }
        AwsJobRateIncreaseCriteria other = (AwsJobRateIncreaseCriteria) obj;
        return Objects.equals(numberOfNotifiedThings(), other.numberOfNotifiedThings())
                && Objects.equals(numberOfSucceededThings(), other.numberOfSucceededThings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsJobRateIncreaseCriteria").add("NumberOfNotifiedThings", numberOfNotifiedThings())
                .add("NumberOfSucceededThings", numberOfSucceededThings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "numberOfNotifiedThings":
            return Optional.ofNullable(clazz.cast(numberOfNotifiedThings()));
        case "numberOfSucceededThings":
            return Optional.ofNullable(clazz.cast(numberOfSucceededThings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsJobRateIncreaseCriteria, T> g) {
        return obj -> g.apply((AwsJobRateIncreaseCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsJobRateIncreaseCriteria> {
        /**
         * <p>
         * When this number of things have been notified, it will initiate an increase in the rollout rate.
         * </p>
         * 
         * @param numberOfNotifiedThings
         *        When this number of things have been notified, it will initiate an increase in the rollout rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfNotifiedThings(Integer numberOfNotifiedThings);

        /**
         * <p>
         * When this number of things have succeeded in their job execution, it will initiate an increase in the rollout
         * rate.
         * </p>
         * 
         * @param numberOfSucceededThings
         *        When this number of things have succeeded in their job execution, it will initiate an increase in the
         *        rollout rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfSucceededThings(Integer numberOfSucceededThings);
    }

    static final class BuilderImpl implements Builder {
        private Integer numberOfNotifiedThings;

        private Integer numberOfSucceededThings;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsJobRateIncreaseCriteria model) {
            numberOfNotifiedThings(model.numberOfNotifiedThings);
            numberOfSucceededThings(model.numberOfSucceededThings);
        }

        public final Integer getNumberOfNotifiedThings() {
            return numberOfNotifiedThings;
        }

        @Override
        public final Builder numberOfNotifiedThings(Integer numberOfNotifiedThings) {
            this.numberOfNotifiedThings = numberOfNotifiedThings;
            return this;
        }

        public final void setNumberOfNotifiedThings(Integer numberOfNotifiedThings) {
            this.numberOfNotifiedThings = numberOfNotifiedThings;
        }

        public final Integer getNumberOfSucceededThings() {
            return numberOfSucceededThings;
        }

        @Override
        public final Builder numberOfSucceededThings(Integer numberOfSucceededThings) {
            this.numberOfSucceededThings = numberOfSucceededThings;
            return this;
        }

        public final void setNumberOfSucceededThings(Integer numberOfSucceededThings) {
            this.numberOfSucceededThings = numberOfSucceededThings;
        }

        @Override
        public AwsJobRateIncreaseCriteria build() {
            return new AwsJobRateIncreaseCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
