/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes which changes should be applied as part of a mitigation action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MitigationAction implements SdkPojo, Serializable,
        ToCopyableBuilder<MitigationAction.Builder, MitigationAction> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(MitigationAction::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(MitigationAction::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(MitigationAction::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<MitigationActionParams> ACTION_PARAMS_FIELD = SdkField
            .<MitigationActionParams> builder(MarshallingType.SDK_POJO).memberName("actionParams")
            .getter(getter(MitigationAction::actionParams)).setter(setter(Builder::actionParams))
            .constructor(MitigationActionParams::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionParams").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD,
            ROLE_ARN_FIELD, ACTION_PARAMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String id;

    private final String roleArn;

    private final MitigationActionParams actionParams;

    private MitigationAction(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.roleArn = builder.roleArn;
        this.actionParams = builder.actionParams;
    }

    /**
     * <p>
     * A user-friendly name for the mitigation action.
     * </p>
     * 
     * @return A user-friendly name for the mitigation action.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A unique identifier for the mitigation action.
     * </p>
     * 
     * @return A unique identifier for the mitigation action.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The IAM role ARN used to apply this mitigation action.
     * </p>
     * 
     * @return The IAM role ARN used to apply this mitigation action.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The set of parameters for this mitigation action. The parameters vary, depending on the kind of action you apply.
     * </p>
     * 
     * @return The set of parameters for this mitigation action. The parameters vary, depending on the kind of action
     *         you apply.
     */
    public final MitigationActionParams actionParams() {
        return actionParams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(actionParams());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MitigationAction)) {
            return false;
        }
        MitigationAction other = (MitigationAction) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(id(), other.id())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(actionParams(), other.actionParams());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MitigationAction").add("Name", name()).add("Id", id()).add("RoleArn", roleArn())
                .add("ActionParams", actionParams()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "actionParams":
            return Optional.ofNullable(clazz.cast(actionParams()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MitigationAction, T> g) {
        return obj -> g.apply((MitigationAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MitigationAction> {
        /**
         * <p>
         * A user-friendly name for the mitigation action.
         * </p>
         * 
         * @param name
         *        A user-friendly name for the mitigation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A unique identifier for the mitigation action.
         * </p>
         * 
         * @param id
         *        A unique identifier for the mitigation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The IAM role ARN used to apply this mitigation action.
         * </p>
         * 
         * @param roleArn
         *        The IAM role ARN used to apply this mitigation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The set of parameters for this mitigation action. The parameters vary, depending on the kind of action you
         * apply.
         * </p>
         * 
         * @param actionParams
         *        The set of parameters for this mitigation action. The parameters vary, depending on the kind of action
         *        you apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionParams(MitigationActionParams actionParams);

        /**
         * <p>
         * The set of parameters for this mitigation action. The parameters vary, depending on the kind of action you
         * apply.
         * </p>
         * This is a convenience that creates an instance of the {@link MitigationActionParams.Builder} avoiding the
         * need to create one manually via {@link MitigationActionParams#builder()}.
         *
         * When the {@link Consumer} completes, {@link MitigationActionParams.Builder#build()} is called immediately and
         * its result is passed to {@link #actionParams(MitigationActionParams)}.
         * 
         * @param actionParams
         *        a consumer that will call methods on {@link MitigationActionParams.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionParams(MitigationActionParams)
         */
        default Builder actionParams(Consumer<MitigationActionParams.Builder> actionParams) {
            return actionParams(MitigationActionParams.builder().applyMutation(actionParams).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String id;

        private String roleArn;

        private MitigationActionParams actionParams;

        private BuilderImpl() {
        }

        private BuilderImpl(MitigationAction model) {
            name(model.name);
            id(model.id);
            roleArn(model.roleArn);
            actionParams(model.actionParams);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final MitigationActionParams.Builder getActionParams() {
            return actionParams != null ? actionParams.toBuilder() : null;
        }

        @Override
        public final Builder actionParams(MitigationActionParams actionParams) {
            this.actionParams = actionParams;
            return this;
        }

        public final void setActionParams(MitigationActionParams.BuilderImpl actionParams) {
            this.actionParams = actionParams != null ? actionParams.build() : null;
        }

        @Override
        public MitigationAction build() {
            return new MitigationAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
