/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartOnDemandAuditTaskRequest extends IotRequest implements
        ToCopyableBuilder<StartOnDemandAuditTaskRequest.Builder, StartOnDemandAuditTaskRequest> {
    private static final SdkField<List<String>> TARGET_CHECK_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("targetCheckNames")
            .getter(getter(StartOnDemandAuditTaskRequest::targetCheckNames))
            .setter(setter(Builder::targetCheckNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetCheckNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_CHECK_NAMES_FIELD));

    private final List<String> targetCheckNames;

    private StartOnDemandAuditTaskRequest(BuilderImpl builder) {
        super(builder);
        this.targetCheckNames = builder.targetCheckNames;
    }

    /**
     * Returns true if the TargetCheckNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTargetCheckNames() {
        return targetCheckNames != null && !(targetCheckNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Which checks are performed during the audit. The checks you specify must be enabled for your account or an
     * exception occurs. Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including
     * those that are enabled or <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargetCheckNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Which checks are performed during the audit. The checks you specify must be enabled for your account or
     *         an exception occurs. Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks,
     *         including those that are enabled or <code>UpdateAccountAuditConfiguration</code> to select which checks
     *         are enabled.
     */
    public final List<String> targetCheckNames() {
        return targetCheckNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetCheckNames() ? targetCheckNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartOnDemandAuditTaskRequest)) {
            return false;
        }
        StartOnDemandAuditTaskRequest other = (StartOnDemandAuditTaskRequest) obj;
        return hasTargetCheckNames() == other.hasTargetCheckNames()
                && Objects.equals(targetCheckNames(), other.targetCheckNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartOnDemandAuditTaskRequest")
                .add("TargetCheckNames", hasTargetCheckNames() ? targetCheckNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetCheckNames":
            return Optional.ofNullable(clazz.cast(targetCheckNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartOnDemandAuditTaskRequest, T> g) {
        return obj -> g.apply((StartOnDemandAuditTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartOnDemandAuditTaskRequest> {
        /**
         * <p>
         * Which checks are performed during the audit. The checks you specify must be enabled for your account or an
         * exception occurs. Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including
         * those that are enabled or <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.
         * </p>
         * 
         * @param targetCheckNames
         *        Which checks are performed during the audit. The checks you specify must be enabled for your account
         *        or an exception occurs. Use <code>DescribeAccountAuditConfiguration</code> to see the list of all
         *        checks, including those that are enabled or <code>UpdateAccountAuditConfiguration</code> to select
         *        which checks are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCheckNames(Collection<String> targetCheckNames);

        /**
         * <p>
         * Which checks are performed during the audit. The checks you specify must be enabled for your account or an
         * exception occurs. Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including
         * those that are enabled or <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.
         * </p>
         * 
         * @param targetCheckNames
         *        Which checks are performed during the audit. The checks you specify must be enabled for your account
         *        or an exception occurs. Use <code>DescribeAccountAuditConfiguration</code> to see the list of all
         *        checks, including those that are enabled or <code>UpdateAccountAuditConfiguration</code> to select
         *        which checks are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCheckNames(String... targetCheckNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private List<String> targetCheckNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartOnDemandAuditTaskRequest model) {
            super(model);
            targetCheckNames(model.targetCheckNames);
        }

        public final Collection<String> getTargetCheckNames() {
            if (targetCheckNames instanceof SdkAutoConstructList) {
                return null;
            }
            return targetCheckNames;
        }

        @Override
        public final Builder targetCheckNames(Collection<String> targetCheckNames) {
            this.targetCheckNames = TargetAuditCheckNamesCopier.copy(targetCheckNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetCheckNames(String... targetCheckNames) {
            targetCheckNames(Arrays.asList(targetCheckNames));
            return this;
        }

        public final void setTargetCheckNames(Collection<String> targetCheckNames) {
            this.targetCheckNames = TargetAuditCheckNamesCopier.copy(targetCheckNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartOnDemandAuditTaskRequest build() {
            return new StartOnDemandAuditTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
