/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJobTemplatesResponse extends IotResponse implements
        ToCopyableBuilder<ListJobTemplatesResponse.Builder, ListJobTemplatesResponse> {
    private static final SdkField<List<JobTemplateSummary>> JOB_TEMPLATES_FIELD = SdkField
            .<List<JobTemplateSummary>> builder(MarshallingType.LIST)
            .memberName("jobTemplates")
            .getter(getter(ListJobTemplatesResponse::jobTemplates))
            .setter(setter(Builder::jobTemplates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTemplates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobTemplateSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobTemplateSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListJobTemplatesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_TEMPLATES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<JobTemplateSummary> jobTemplates;

    private final String nextToken;

    private ListJobTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.jobTemplates = builder.jobTemplates;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the JobTemplates property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasJobTemplates() {
        return jobTemplates != null && !(jobTemplates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects that contain information about the job templates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasJobTemplates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of objects that contain information about the job templates.
     */
    public final List<JobTemplateSummary> jobTemplates() {
        return jobTemplates;
    }

    /**
     * <p>
     * The token for the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token for the next set of results, or <b>null</b> if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasJobTemplates() ? jobTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobTemplatesResponse)) {
            return false;
        }
        ListJobTemplatesResponse other = (ListJobTemplatesResponse) obj;
        return hasJobTemplates() == other.hasJobTemplates() && Objects.equals(jobTemplates(), other.jobTemplates())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListJobTemplatesResponse").add("JobTemplates", hasJobTemplates() ? jobTemplates() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobTemplates":
            return Optional.ofNullable(clazz.cast(jobTemplates()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobTemplatesResponse, T> g) {
        return obj -> g.apply((ListJobTemplatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListJobTemplatesResponse> {
        /**
         * <p>
         * A list of objects that contain information about the job templates.
         * </p>
         * 
         * @param jobTemplates
         *        A list of objects that contain information about the job templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTemplates(Collection<JobTemplateSummary> jobTemplates);

        /**
         * <p>
         * A list of objects that contain information about the job templates.
         * </p>
         * 
         * @param jobTemplates
         *        A list of objects that contain information about the job templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTemplates(JobTemplateSummary... jobTemplates);

        /**
         * <p>
         * A list of objects that contain information about the job templates.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobTemplateSummary>.Builder} avoiding the
         * need to create one manually via {@link List<JobTemplateSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobTemplateSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #jobTemplates(List<JobTemplateSummary>)}.
         * 
         * @param jobTemplates
         *        a consumer that will call methods on {@link List<JobTemplateSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobTemplates(List<JobTemplateSummary>)
         */
        Builder jobTemplates(Consumer<JobTemplateSummary.Builder>... jobTemplates);

        /**
         * <p>
         * The token for the next set of results, or <b>null</b> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or <b>null</b> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<JobTemplateSummary> jobTemplates = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobTemplatesResponse model) {
            super(model);
            jobTemplates(model.jobTemplates);
            nextToken(model.nextToken);
        }

        public final List<JobTemplateSummary.Builder> getJobTemplates() {
            List<JobTemplateSummary.Builder> result = JobTemplateSummaryListCopier.copyToBuilder(this.jobTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder jobTemplates(Collection<JobTemplateSummary> jobTemplates) {
            this.jobTemplates = JobTemplateSummaryListCopier.copy(jobTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobTemplates(JobTemplateSummary... jobTemplates) {
            jobTemplates(Arrays.asList(jobTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobTemplates(Consumer<JobTemplateSummary.Builder>... jobTemplates) {
            jobTemplates(Stream.of(jobTemplates).map(c -> JobTemplateSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setJobTemplates(Collection<JobTemplateSummary.BuilderImpl> jobTemplates) {
            this.jobTemplates = JobTemplateSummaryListCopier.copyFromBuilder(jobTemplates);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListJobTemplatesResponse build() {
            return new ListJobTemplatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
