/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the signature for a file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeSigningSignature implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeSigningSignature.Builder, CodeSigningSignature> {
    private static final SdkField<SdkBytes> INLINE_DOCUMENT_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("inlineDocument").getter(getter(CodeSigningSignature::inlineDocument))
            .setter(setter(Builder::inlineDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineDocument").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INLINE_DOCUMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final SdkBytes inlineDocument;

    private CodeSigningSignature(BuilderImpl builder) {
        this.inlineDocument = builder.inlineDocument;
    }

    /**
     * <p>
     * A base64 encoded binary representation of the code signing signature.
     * </p>
     * 
     * @return A base64 encoded binary representation of the code signing signature.
     */
    public final SdkBytes inlineDocument() {
        return inlineDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inlineDocument());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeSigningSignature)) {
            return false;
        }
        CodeSigningSignature other = (CodeSigningSignature) obj;
        return Objects.equals(inlineDocument(), other.inlineDocument());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeSigningSignature").add("InlineDocument", inlineDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inlineDocument":
            return Optional.ofNullable(clazz.cast(inlineDocument()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeSigningSignature, T> g) {
        return obj -> g.apply((CodeSigningSignature) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeSigningSignature> {
        /**
         * <p>
         * A base64 encoded binary representation of the code signing signature.
         * </p>
         * 
         * @param inlineDocument
         *        A base64 encoded binary representation of the code signing signature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineDocument(SdkBytes inlineDocument);
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes inlineDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeSigningSignature model) {
            inlineDocument(model.inlineDocument);
        }

        public final ByteBuffer getInlineDocument() {
            return inlineDocument == null ? null : inlineDocument.asByteBuffer();
        }

        @Override
        public final Builder inlineDocument(SdkBytes inlineDocument) {
            this.inlineDocument = StandardMemberCopier.copy(inlineDocument);
            return this;
        }

        public final void setInlineDocument(ByteBuffer inlineDocument) {
            inlineDocument(inlineDocument == null ? null : SdkBytes.fromByteBuffer(inlineDocument));
        }

        @Override
        public CodeSigningSignature build() {
            return new CodeSigningSignature(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
