/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAuditFindingRequest extends IotRequest implements
        ToCopyableBuilder<DescribeAuditFindingRequest.Builder, DescribeAuditFindingRequest> {
    private static final SdkField<String> FINDING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("findingId").getter(getter(DescribeAuditFindingRequest::findingId)).setter(setter(Builder::findingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("findingId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_ID_FIELD));

    private final String findingId;

    private DescribeAuditFindingRequest(BuilderImpl builder) {
        super(builder);
        this.findingId = builder.findingId;
    }

    /**
     * <p>
     * A unique identifier for a single audit finding. You can use this identifier to apply mitigation actions to the
     * finding.
     * </p>
     * 
     * @return A unique identifier for a single audit finding. You can use this identifier to apply mitigation actions
     *         to the finding.
     */
    public final String findingId() {
        return findingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(findingId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAuditFindingRequest)) {
            return false;
        }
        DescribeAuditFindingRequest other = (DescribeAuditFindingRequest) obj;
        return Objects.equals(findingId(), other.findingId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAuditFindingRequest").add("FindingId", findingId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "findingId":
            return Optional.ofNullable(clazz.cast(findingId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAuditFindingRequest, T> g) {
        return obj -> g.apply((DescribeAuditFindingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAuditFindingRequest> {
        /**
         * <p>
         * A unique identifier for a single audit finding. You can use this identifier to apply mitigation actions to
         * the finding.
         * </p>
         * 
         * @param findingId
         *        A unique identifier for a single audit finding. You can use this identifier to apply mitigation
         *        actions to the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingId(String findingId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String findingId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAuditFindingRequest model) {
            super(model);
            findingId(model.findingId);
        }

        public final String getFindingId() {
            return findingId;
        }

        @Override
        public final Builder findingId(String findingId) {
            this.findingId = findingId;
            return this;
        }

        public final void setFindingId(String findingId) {
            this.findingId = findingId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAuditFindingRequest build() {
            return new DescribeAuditFindingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
