/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information about the job template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobTemplateSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<JobTemplateSummary.Builder, JobTemplateSummary> {
    private static final SdkField<String> JOB_TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobTemplateArn").getter(getter(JobTemplateSummary::jobTemplateArn))
            .setter(setter(Builder::jobTemplateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTemplateArn").build()).build();

    private static final SdkField<String> JOB_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobTemplateId").getter(getter(JobTemplateSummary::jobTemplateId)).setter(setter(Builder::jobTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTemplateId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(JobTemplateSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(JobTemplateSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_TEMPLATE_ARN_FIELD,
            JOB_TEMPLATE_ID_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobTemplateArn;

    private final String jobTemplateId;

    private final String description;

    private final Instant createdAt;

    private JobTemplateSummary(BuilderImpl builder) {
        this.jobTemplateArn = builder.jobTemplateArn;
        this.jobTemplateId = builder.jobTemplateId;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * The ARN of the job template.
     * </p>
     * 
     * @return The ARN of the job template.
     */
    public final String jobTemplateArn() {
        return jobTemplateArn;
    }

    /**
     * <p>
     * The unique identifier of the job template.
     * </p>
     * 
     * @return The unique identifier of the job template.
     */
    public final String jobTemplateId() {
        return jobTemplateId;
    }

    /**
     * <p>
     * A description of the job template.
     * </p>
     * 
     * @return A description of the job template.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The time, in seconds since the epoch, when the job template was created.
     * </p>
     * 
     * @return The time, in seconds since the epoch, when the job template was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobTemplateSummary)) {
            return false;
        }
        JobTemplateSummary other = (JobTemplateSummary) obj;
        return Objects.equals(jobTemplateArn(), other.jobTemplateArn()) && Objects.equals(jobTemplateId(), other.jobTemplateId())
                && Objects.equals(description(), other.description()) && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobTemplateSummary").add("JobTemplateArn", jobTemplateArn())
                .add("JobTemplateId", jobTemplateId()).add("Description", description()).add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobTemplateArn":
            return Optional.ofNullable(clazz.cast(jobTemplateArn()));
        case "jobTemplateId":
            return Optional.ofNullable(clazz.cast(jobTemplateId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobTemplateSummary, T> g) {
        return obj -> g.apply((JobTemplateSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobTemplateSummary> {
        /**
         * <p>
         * The ARN of the job template.
         * </p>
         * 
         * @param jobTemplateArn
         *        The ARN of the job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTemplateArn(String jobTemplateArn);

        /**
         * <p>
         * The unique identifier of the job template.
         * </p>
         * 
         * @param jobTemplateId
         *        The unique identifier of the job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTemplateId(String jobTemplateId);

        /**
         * <p>
         * A description of the job template.
         * </p>
         * 
         * @param description
         *        A description of the job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The time, in seconds since the epoch, when the job template was created.
         * </p>
         * 
         * @param createdAt
         *        The time, in seconds since the epoch, when the job template was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl implements Builder {
        private String jobTemplateArn;

        private String jobTemplateId;

        private String description;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(JobTemplateSummary model) {
            jobTemplateArn(model.jobTemplateArn);
            jobTemplateId(model.jobTemplateId);
            description(model.description);
            createdAt(model.createdAt);
        }

        public final String getJobTemplateArn() {
            return jobTemplateArn;
        }

        @Override
        public final Builder jobTemplateArn(String jobTemplateArn) {
            this.jobTemplateArn = jobTemplateArn;
            return this;
        }

        public final void setJobTemplateArn(String jobTemplateArn) {
            this.jobTemplateArn = jobTemplateArn;
        }

        public final String getJobTemplateId() {
            return jobTemplateId;
        }

        @Override
        public final Builder jobTemplateId(String jobTemplateId) {
            this.jobTemplateId = jobTemplateId;
            return this;
        }

        public final void setJobTemplateId(String jobTemplateId) {
            this.jobTemplateId = jobTemplateId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public JobTemplateSummary build() {
            return new JobTemplateSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
