/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJobExecutionsForThingRequest extends IotRequest implements
        ToCopyableBuilder<ListJobExecutionsForThingRequest.Builder, ListJobExecutionsForThingRequest> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(ListJobExecutionsForThingRequest::thingName))
            .setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("thingName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ListJobExecutionsForThingRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()).build();

    private static final SdkField<String> NAMESPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceId").getter(getter(ListJobExecutionsForThingRequest::namespaceId))
            .setter(setter(Builder::namespaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("namespaceId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListJobExecutionsForThingRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListJobExecutionsForThingRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(ListJobExecutionsForThingRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("jobId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD,
            STATUS_FIELD, NAMESPACE_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, JOB_ID_FIELD));

    private final String thingName;

    private final String status;

    private final String namespaceId;

    private final Integer maxResults;

    private final String nextToken;

    private final String jobId;

    private ListJobExecutionsForThingRequest(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.status = builder.status;
        this.namespaceId = builder.namespaceId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.jobId = builder.jobId;
    }

    /**
     * <p>
     * The thing name.
     * </p>
     * 
     * @return The thing name.
     */
    public final String thingName() {
        return thingName;
    }

    /**
     * <p>
     * An optional filter that lets you search for jobs that have the specified status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return An optional filter that lets you search for jobs that have the specified status.
     * @see JobExecutionStatus
     */
    public final JobExecutionStatus status() {
        return JobExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * An optional filter that lets you search for jobs that have the specified status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return An optional filter that lets you search for jobs that have the specified status.
     * @see JobExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The namespace used to indicate that a job is a customer-managed job.
     * </p>
     * <p>
     * When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics
     * that contain the value in the following format.
     * </p>
     * <p>
     * <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code>
     * </p>
     * <note>
     * <p>
     * The <code>namespaceId</code> feature is in public preview.
     * </p>
     * </note>
     * 
     * @return The namespace used to indicate that a job is a customer-managed job.</p>
     *         <p>
     *         When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to
     *         MQTT topics that contain the value in the following format.
     *         </p>
     *         <p>
     *         <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code>
     *         </p>
     *         <note>
     *         <p>
     *         The <code>namespaceId</code> feature is in public preview.
     *         </p>
     */
    public final String namespaceId() {
        return namespaceId;
    }

    /**
     * <p>
     * The maximum number of results to be returned per request.
     * </p>
     * 
     * @return The maximum number of results to be returned per request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to retrieve the next set of results.
     * </p>
     * 
     * @return The token to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The unique identifier you assigned to this job when it was created.
     * </p>
     * 
     * @return The unique identifier you assigned to this job when it was created.
     */
    public final String jobId() {
        return jobId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobExecutionsForThingRequest)) {
            return false;
        }
        ListJobExecutionsForThingRequest other = (ListJobExecutionsForThingRequest) obj;
        return Objects.equals(thingName(), other.thingName()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(namespaceId(), other.namespaceId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(jobId(), other.jobId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListJobExecutionsForThingRequest").add("ThingName", thingName()).add("Status", statusAsString())
                .add("NamespaceId", namespaceId()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("JobId", jobId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "namespaceId":
            return Optional.ofNullable(clazz.cast(namespaceId()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobExecutionsForThingRequest, T> g) {
        return obj -> g.apply((ListJobExecutionsForThingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListJobExecutionsForThingRequest> {
        /**
         * <p>
         * The thing name.
         * </p>
         * 
         * @param thingName
         *        The thing name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * An optional filter that lets you search for jobs that have the specified status.
         * </p>
         * 
         * @param status
         *        An optional filter that lets you search for jobs that have the specified status.
         * @see JobExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * An optional filter that lets you search for jobs that have the specified status.
         * </p>
         * 
         * @param status
         *        An optional filter that lets you search for jobs that have the specified status.
         * @see JobExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobExecutionStatus
         */
        Builder status(JobExecutionStatus status);

        /**
         * <p>
         * The namespace used to indicate that a job is a customer-managed job.
         * </p>
         * <p>
         * When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT
         * topics that contain the value in the following format.
         * </p>
         * <p>
         * <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code>
         * </p>
         * <note>
         * <p>
         * The <code>namespaceId</code> feature is in public preview.
         * </p>
         * </note>
         * 
         * @param namespaceId
         *        The namespace used to indicate that a job is a customer-managed job.</p>
         *        <p>
         *        When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to
         *        MQTT topics that contain the value in the following format.
         *        </p>
         *        <p>
         *        <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code>
         *        </p>
         *        <note>
         *        <p>
         *        The <code>namespaceId</code> feature is in public preview.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceId(String namespaceId);

        /**
         * <p>
         * The maximum number of results to be returned per request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be returned per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The unique identifier you assigned to this job when it was created.
         * </p>
         * 
         * @param jobId
         *        The unique identifier you assigned to this job when it was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String thingName;

        private String status;

        private String namespaceId;

        private Integer maxResults;

        private String nextToken;

        private String jobId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobExecutionsForThingRequest model) {
            super(model);
            thingName(model.thingName);
            status(model.status);
            namespaceId(model.namespaceId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            jobId(model.jobId);
        }

        public final String getThingName() {
            return thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        @Transient
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(JobExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getNamespaceId() {
            return namespaceId;
        }

        public final void setNamespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
        }

        @Override
        @Transient
        public final Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        @Transient
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListJobExecutionsForThingRequest build() {
            return new ListJobExecutionsForThingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
