/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The criteria that determines how many retries are allowed for each failure type for a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetryCriteria implements SdkPojo, Serializable, ToCopyableBuilder<RetryCriteria.Builder, RetryCriteria> {
    private static final SdkField<String> FAILURE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureType").getter(getter(RetryCriteria::failureTypeAsString)).setter(setter(Builder::failureType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureType").build()).build();

    private static final SdkField<Integer> NUMBER_OF_RETRIES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfRetries").getter(getter(RetryCriteria::numberOfRetries))
            .setter(setter(Builder::numberOfRetries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRetries").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_TYPE_FIELD,
            NUMBER_OF_RETRIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String failureType;

    private final Integer numberOfRetries;

    private RetryCriteria(BuilderImpl builder) {
        this.failureType = builder.failureType;
        this.numberOfRetries = builder.numberOfRetries;
    }

    /**
     * <p>
     * The type of job execution failures that can initiate a job retry.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureType} will
     * return {@link RetryableFailureType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureTypeAsString}.
     * </p>
     * 
     * @return The type of job execution failures that can initiate a job retry.
     * @see RetryableFailureType
     */
    public final RetryableFailureType failureType() {
        return RetryableFailureType.fromValue(failureType);
    }

    /**
     * <p>
     * The type of job execution failures that can initiate a job retry.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureType} will
     * return {@link RetryableFailureType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureTypeAsString}.
     * </p>
     * 
     * @return The type of job execution failures that can initiate a job retry.
     * @see RetryableFailureType
     */
    public final String failureTypeAsString() {
        return failureType;
    }

    /**
     * <p>
     * The number of retries allowed for a failure type for the job.
     * </p>
     * 
     * @return The number of retries allowed for a failure type for the job.
     */
    public final Integer numberOfRetries() {
        return numberOfRetries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failureTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfRetries());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryCriteria)) {
            return false;
        }
        RetryCriteria other = (RetryCriteria) obj;
        return Objects.equals(failureTypeAsString(), other.failureTypeAsString())
                && Objects.equals(numberOfRetries(), other.numberOfRetries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetryCriteria").add("FailureType", failureTypeAsString())
                .add("NumberOfRetries", numberOfRetries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "failureType":
            return Optional.ofNullable(clazz.cast(failureTypeAsString()));
        case "numberOfRetries":
            return Optional.ofNullable(clazz.cast(numberOfRetries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetryCriteria, T> g) {
        return obj -> g.apply((RetryCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetryCriteria> {
        /**
         * <p>
         * The type of job execution failures that can initiate a job retry.
         * </p>
         * 
         * @param failureType
         *        The type of job execution failures that can initiate a job retry.
         * @see RetryableFailureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetryableFailureType
         */
        Builder failureType(String failureType);

        /**
         * <p>
         * The type of job execution failures that can initiate a job retry.
         * </p>
         * 
         * @param failureType
         *        The type of job execution failures that can initiate a job retry.
         * @see RetryableFailureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetryableFailureType
         */
        Builder failureType(RetryableFailureType failureType);

        /**
         * <p>
         * The number of retries allowed for a failure type for the job.
         * </p>
         * 
         * @param numberOfRetries
         *        The number of retries allowed for a failure type for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfRetries(Integer numberOfRetries);
    }

    static final class BuilderImpl implements Builder {
        private String failureType;

        private Integer numberOfRetries;

        private BuilderImpl() {
        }

        private BuilderImpl(RetryCriteria model) {
            failureType(model.failureType);
            numberOfRetries(model.numberOfRetries);
        }

        public final String getFailureType() {
            return failureType;
        }

        public final void setFailureType(String failureType) {
            this.failureType = failureType;
        }

        @Override
        @Transient
        public final Builder failureType(String failureType) {
            this.failureType = failureType;
            return this;
        }

        @Override
        @Transient
        public final Builder failureType(RetryableFailureType failureType) {
            this.failureType(failureType == null ? null : failureType.toString());
            return this;
        }

        public final Integer getNumberOfRetries() {
            return numberOfRetries;
        }

        public final void setNumberOfRetries(Integer numberOfRetries) {
            this.numberOfRetries = numberOfRetries;
        }

        @Override
        @Transient
        public final Builder numberOfRetries(Integer numberOfRetries) {
            this.numberOfRetries = numberOfRetries;
            return this;
        }

        @Override
        public RetryCriteria build() {
            return new RetryCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
