/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used in MitigationActionParams, this information identifies the target findings to which the mitigation actions are
 * applied. Only one entry appears.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuditMitigationActionsTaskTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<AuditMitigationActionsTaskTarget.Builder, AuditMitigationActionsTaskTarget> {
    private static final SdkField<String> AUDIT_TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("auditTaskId").getter(getter(AuditMitigationActionsTaskTarget::auditTaskId))
            .setter(setter(Builder::auditTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditTaskId").build()).build();

    private static final SdkField<List<String>> FINDING_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("findingIds")
            .getter(getter(AuditMitigationActionsTaskTarget::findingIds))
            .setter(setter(Builder::findingIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, List<String>>> AUDIT_CHECK_TO_REASON_CODE_FILTER_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("auditCheckToReasonCodeFilter")
            .getter(getter(AuditMitigationActionsTaskTarget::auditCheckToReasonCodeFilter))
            .setter(setter(Builder::auditCheckToReasonCodeFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditCheckToReasonCodeFilter")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIT_TASK_ID_FIELD,
            FINDING_IDS_FIELD, AUDIT_CHECK_TO_REASON_CODE_FILTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String auditTaskId;

    private final List<String> findingIds;

    private final Map<String, List<String>> auditCheckToReasonCodeFilter;

    private AuditMitigationActionsTaskTarget(BuilderImpl builder) {
        this.auditTaskId = builder.auditTaskId;
        this.findingIds = builder.findingIds;
        this.auditCheckToReasonCodeFilter = builder.auditCheckToReasonCodeFilter;
    }

    /**
     * <p>
     * If the task will apply a mitigation action to findings from a specific audit, this value uniquely identifies the
     * audit.
     * </p>
     * 
     * @return If the task will apply a mitigation action to findings from a specific audit, this value uniquely
     *         identifies the audit.
     */
    public final String auditTaskId() {
        return auditTaskId;
    }

    /**
     * Returns true if the FindingIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFindingIds() {
        return findingIds != null && !(findingIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the task will apply a mitigation action to one or more listed findings, this value uniquely identifies those
     * findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFindingIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return If the task will apply a mitigation action to one or more listed findings, this value uniquely identifies
     *         those findings.
     */
    public final List<String> findingIds() {
        return findingIds;
    }

    /**
     * Returns true if the AuditCheckToReasonCodeFilter property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasAuditCheckToReasonCodeFilter() {
        return auditCheckToReasonCodeFilter != null && !(auditCheckToReasonCodeFilter instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies a filter in the form of an audit check and set of reason codes that identify the findings from the
     * audit to which the audit mitigation actions task apply.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAuditCheckToReasonCodeFilter()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies a filter in the form of an audit check and set of reason codes that identify the findings from
     *         the audit to which the audit mitigation actions task apply.
     */
    public final Map<String, List<String>> auditCheckToReasonCodeFilter() {
        return auditCheckToReasonCodeFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(auditTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingIds() ? findingIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAuditCheckToReasonCodeFilter() ? auditCheckToReasonCodeFilter() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditMitigationActionsTaskTarget)) {
            return false;
        }
        AuditMitigationActionsTaskTarget other = (AuditMitigationActionsTaskTarget) obj;
        return Objects.equals(auditTaskId(), other.auditTaskId()) && hasFindingIds() == other.hasFindingIds()
                && Objects.equals(findingIds(), other.findingIds())
                && hasAuditCheckToReasonCodeFilter() == other.hasAuditCheckToReasonCodeFilter()
                && Objects.equals(auditCheckToReasonCodeFilter(), other.auditCheckToReasonCodeFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuditMitigationActionsTaskTarget").add("AuditTaskId", auditTaskId())
                .add("FindingIds", hasFindingIds() ? findingIds() : null)
                .add("AuditCheckToReasonCodeFilter", hasAuditCheckToReasonCodeFilter() ? auditCheckToReasonCodeFilter() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "auditTaskId":
            return Optional.ofNullable(clazz.cast(auditTaskId()));
        case "findingIds":
            return Optional.ofNullable(clazz.cast(findingIds()));
        case "auditCheckToReasonCodeFilter":
            return Optional.ofNullable(clazz.cast(auditCheckToReasonCodeFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuditMitigationActionsTaskTarget, T> g) {
        return obj -> g.apply((AuditMitigationActionsTaskTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuditMitigationActionsTaskTarget> {
        /**
         * <p>
         * If the task will apply a mitigation action to findings from a specific audit, this value uniquely identifies
         * the audit.
         * </p>
         * 
         * @param auditTaskId
         *        If the task will apply a mitigation action to findings from a specific audit, this value uniquely
         *        identifies the audit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditTaskId(String auditTaskId);

        /**
         * <p>
         * If the task will apply a mitigation action to one or more listed findings, this value uniquely identifies
         * those findings.
         * </p>
         * 
         * @param findingIds
         *        If the task will apply a mitigation action to one or more listed findings, this value uniquely
         *        identifies those findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingIds(Collection<String> findingIds);

        /**
         * <p>
         * If the task will apply a mitigation action to one or more listed findings, this value uniquely identifies
         * those findings.
         * </p>
         * 
         * @param findingIds
         *        If the task will apply a mitigation action to one or more listed findings, this value uniquely
         *        identifies those findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingIds(String... findingIds);

        /**
         * <p>
         * Specifies a filter in the form of an audit check and set of reason codes that identify the findings from the
         * audit to which the audit mitigation actions task apply.
         * </p>
         * 
         * @param auditCheckToReasonCodeFilter
         *        Specifies a filter in the form of an audit check and set of reason codes that identify the findings
         *        from the audit to which the audit mitigation actions task apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditCheckToReasonCodeFilter(Map<String, ? extends Collection<String>> auditCheckToReasonCodeFilter);
    }

    static final class BuilderImpl implements Builder {
        private String auditTaskId;

        private List<String> findingIds = DefaultSdkAutoConstructList.getInstance();

        private Map<String, List<String>> auditCheckToReasonCodeFilter = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuditMitigationActionsTaskTarget model) {
            auditTaskId(model.auditTaskId);
            findingIds(model.findingIds);
            auditCheckToReasonCodeFilter(model.auditCheckToReasonCodeFilter);
        }

        public final String getAuditTaskId() {
            return auditTaskId;
        }

        public final void setAuditTaskId(String auditTaskId) {
            this.auditTaskId = auditTaskId;
        }

        @Override
        @Transient
        public final Builder auditTaskId(String auditTaskId) {
            this.auditTaskId = auditTaskId;
            return this;
        }

        public final Collection<String> getFindingIds() {
            if (findingIds instanceof SdkAutoConstructList) {
                return null;
            }
            return findingIds;
        }

        public final void setFindingIds(Collection<String> findingIds) {
            this.findingIds = FindingIdsCopier.copy(findingIds);
        }

        @Override
        @Transient
        public final Builder findingIds(Collection<String> findingIds) {
            this.findingIds = FindingIdsCopier.copy(findingIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder findingIds(String... findingIds) {
            findingIds(Arrays.asList(findingIds));
            return this;
        }

        public final Map<String, ? extends Collection<String>> getAuditCheckToReasonCodeFilter() {
            if (auditCheckToReasonCodeFilter instanceof SdkAutoConstructMap) {
                return null;
            }
            return auditCheckToReasonCodeFilter;
        }

        public final void setAuditCheckToReasonCodeFilter(Map<String, ? extends Collection<String>> auditCheckToReasonCodeFilter) {
            this.auditCheckToReasonCodeFilter = AuditCheckToReasonCodeFilterCopier.copy(auditCheckToReasonCodeFilter);
        }

        @Override
        @Transient
        public final Builder auditCheckToReasonCodeFilter(Map<String, ? extends Collection<String>> auditCheckToReasonCodeFilter) {
            this.auditCheckToReasonCodeFilter = AuditCheckToReasonCodeFilterCopier.copy(auditCheckToReasonCodeFilter);
            return this;
        }

        @Override
        public AuditMitigationActionsTaskTarget build() {
            return new AuditMitigationActionsTaskTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
