/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterCertificateWithoutCaResponse extends IotResponse implements
        ToCopyableBuilder<RegisterCertificateWithoutCaResponse.Builder, RegisterCertificateWithoutCaResponse> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateArn").getter(getter(RegisterCertificateWithoutCaResponse::certificateArn))
            .setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()).build();

    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateId").getter(getter(RegisterCertificateWithoutCaResponse::certificateId))
            .setter(setter(Builder::certificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD,
            CERTIFICATE_ID_FIELD));

    private final String certificateArn;

    private final String certificateId;

    private RegisterCertificateWithoutCaResponse(BuilderImpl builder) {
        super(builder);
        this.certificateArn = builder.certificateArn;
        this.certificateId = builder.certificateId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the registered certificate.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the registered certificate.
     */
    public final String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The ID of the registered certificate. (The last part of the certificate ARN contains the certificate ID.
     * </p>
     * 
     * @return The ID of the registered certificate. (The last part of the certificate ARN contains the certificate ID.
     */
    public final String certificateId() {
        return certificateId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterCertificateWithoutCaResponse)) {
            return false;
        }
        RegisterCertificateWithoutCaResponse other = (RegisterCertificateWithoutCaResponse) obj;
        return Objects.equals(certificateArn(), other.certificateArn()) && Objects.equals(certificateId(), other.certificateId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterCertificateWithoutCaResponse").add("CertificateArn", certificateArn())
                .add("CertificateId", certificateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "certificateId":
            return Optional.ofNullable(clazz.cast(certificateId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterCertificateWithoutCaResponse, T> g) {
        return obj -> g.apply((RegisterCertificateWithoutCaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, RegisterCertificateWithoutCaResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the registered certificate.
         * </p>
         * 
         * @param certificateArn
         *        The Amazon Resource Name (ARN) of the registered certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The ID of the registered certificate. (The last part of the certificate ARN contains the certificate ID.
         * </p>
         * 
         * @param certificateId
         *        The ID of the registered certificate. (The last part of the certificate ARN contains the certificate
         *        ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String certificateArn;

        private String certificateId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterCertificateWithoutCaResponse model) {
            super(model);
            certificateArn(model.certificateArn);
            certificateId(model.certificateId);
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        @Transient
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getCertificateId() {
            return certificateId;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Override
        @Transient
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        @Override
        public RegisterCertificateWithoutCaResponse build() {
            return new RegisterCertificateWithoutCaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
