/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateJobTemplateRequest extends IotRequest implements
        ToCopyableBuilder<CreateJobTemplateRequest.Builder, CreateJobTemplateRequest> {
    private static final SdkField<String> JOB_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobTemplateId").getter(getter(CreateJobTemplateRequest::jobTemplateId))
            .setter(setter(Builder::jobTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobTemplateId").build()).build();

    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobArn")
            .getter(getter(CreateJobTemplateRequest::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()).build();

    private static final SdkField<String> DOCUMENT_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentSource").getter(getter(CreateJobTemplateRequest::documentSource))
            .setter(setter(Builder::documentSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentSource").build()).build();

    private static final SdkField<String> DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("document").getter(getter(CreateJobTemplateRequest::document)).setter(setter(Builder::document))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateJobTemplateRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<PresignedUrlConfig> PRESIGNED_URL_CONFIG_FIELD = SdkField
            .<PresignedUrlConfig> builder(MarshallingType.SDK_POJO).memberName("presignedUrlConfig")
            .getter(getter(CreateJobTemplateRequest::presignedUrlConfig)).setter(setter(Builder::presignedUrlConfig))
            .constructor(PresignedUrlConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("presignedUrlConfig").build())
            .build();

    private static final SdkField<JobExecutionsRolloutConfig> JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD = SdkField
            .<JobExecutionsRolloutConfig> builder(MarshallingType.SDK_POJO)
            .memberName("jobExecutionsRolloutConfig")
            .getter(getter(CreateJobTemplateRequest::jobExecutionsRolloutConfig))
            .setter(setter(Builder::jobExecutionsRolloutConfig))
            .constructor(JobExecutionsRolloutConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobExecutionsRolloutConfig").build())
            .build();

    private static final SdkField<AbortConfig> ABORT_CONFIG_FIELD = SdkField.<AbortConfig> builder(MarshallingType.SDK_POJO)
            .memberName("abortConfig").getter(getter(CreateJobTemplateRequest::abortConfig)).setter(setter(Builder::abortConfig))
            .constructor(AbortConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("abortConfig").build()).build();

    private static final SdkField<TimeoutConfig> TIMEOUT_CONFIG_FIELD = SdkField
            .<TimeoutConfig> builder(MarshallingType.SDK_POJO).memberName("timeoutConfig")
            .getter(getter(CreateJobTemplateRequest::timeoutConfig)).setter(setter(Builder::timeoutConfig))
            .constructor(TimeoutConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutConfig").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateJobTemplateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_TEMPLATE_ID_FIELD,
            JOB_ARN_FIELD, DOCUMENT_SOURCE_FIELD, DOCUMENT_FIELD, DESCRIPTION_FIELD, PRESIGNED_URL_CONFIG_FIELD,
            JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD, ABORT_CONFIG_FIELD, TIMEOUT_CONFIG_FIELD, TAGS_FIELD));

    private final String jobTemplateId;

    private final String jobArn;

    private final String documentSource;

    private final String document;

    private final String description;

    private final PresignedUrlConfig presignedUrlConfig;

    private final JobExecutionsRolloutConfig jobExecutionsRolloutConfig;

    private final AbortConfig abortConfig;

    private final TimeoutConfig timeoutConfig;

    private final List<Tag> tags;

    private CreateJobTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.jobTemplateId = builder.jobTemplateId;
        this.jobArn = builder.jobArn;
        this.documentSource = builder.documentSource;
        this.document = builder.document;
        this.description = builder.description;
        this.presignedUrlConfig = builder.presignedUrlConfig;
        this.jobExecutionsRolloutConfig = builder.jobExecutionsRolloutConfig;
        this.abortConfig = builder.abortConfig;
        this.timeoutConfig = builder.timeoutConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique identifier for the job template. We recommend using a UUID. Alpha-numeric characters, "-", and "_" are
     * valid for use here.
     * </p>
     * 
     * @return A unique identifier for the job template. We recommend using a UUID. Alpha-numeric characters, "-", and
     *         "_" are valid for use here.
     */
    public final String jobTemplateId() {
        return jobTemplateId;
    }

    /**
     * <p>
     * The ARN of the job to use as the basis for the job template.
     * </p>
     * 
     * @return The ARN of the job to use as the basis for the job template.
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * An S3 link to the job document to use in the template. Required if you don't specify a value for
     * <code>document</code>.
     * </p>
     * <note>
     * <p>
     * If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.
     * </p>
     * <p>
     * The placeholder link is of the following form:
     * </p>
     * <p>
     * <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code>
     * </p>
     * <p>
     * where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are linking.
     * </p>
     * </note>
     * 
     * @return An S3 link to the job document to use in the template. Required if you don't specify a value for
     *         <code>document</code>.</p> <note>
     *         <p>
     *         If the job document resides in an S3 bucket, you must use a placeholder link when specifying the
     *         document.
     *         </p>
     *         <p>
     *         The placeholder link is of the following form:
     *         </p>
     *         <p>
     *         <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code>
     *         </p>
     *         <p>
     *         where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are
     *         linking.
     *         </p>
     */
    public final String documentSource() {
        return documentSource;
    }

    /**
     * <p>
     * The job document. Required if you don't specify a value for <code>documentSource</code>.
     * </p>
     * 
     * @return The job document. Required if you don't specify a value for <code>documentSource</code>.
     */
    public final String document() {
        return document;
    }

    /**
     * <p>
     * A description of the job document.
     * </p>
     * 
     * @return A description of the job document.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the PresignedUrlConfig property for this object.
     * 
     * @return The value of the PresignedUrlConfig property for this object.
     */
    public final PresignedUrlConfig presignedUrlConfig() {
        return presignedUrlConfig;
    }

    /**
     * Returns the value of the JobExecutionsRolloutConfig property for this object.
     * 
     * @return The value of the JobExecutionsRolloutConfig property for this object.
     */
    public final JobExecutionsRolloutConfig jobExecutionsRolloutConfig() {
        return jobExecutionsRolloutConfig;
    }

    /**
     * Returns the value of the AbortConfig property for this object.
     * 
     * @return The value of the AbortConfig property for this object.
     */
    public final AbortConfig abortConfig() {
        return abortConfig;
    }

    /**
     * Returns the value of the TimeoutConfig property for this object.
     * 
     * @return The value of the TimeoutConfig property for this object.
     */
    public final TimeoutConfig timeoutConfig() {
        return timeoutConfig;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata that can be used to manage the job template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Metadata that can be used to manage the job template.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(documentSource());
        hashCode = 31 * hashCode + Objects.hashCode(document());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(presignedUrlConfig());
        hashCode = 31 * hashCode + Objects.hashCode(jobExecutionsRolloutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(abortConfig());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobTemplateRequest)) {
            return false;
        }
        CreateJobTemplateRequest other = (CreateJobTemplateRequest) obj;
        return Objects.equals(jobTemplateId(), other.jobTemplateId()) && Objects.equals(jobArn(), other.jobArn())
                && Objects.equals(documentSource(), other.documentSource()) && Objects.equals(document(), other.document())
                && Objects.equals(description(), other.description())
                && Objects.equals(presignedUrlConfig(), other.presignedUrlConfig())
                && Objects.equals(jobExecutionsRolloutConfig(), other.jobExecutionsRolloutConfig())
                && Objects.equals(abortConfig(), other.abortConfig()) && Objects.equals(timeoutConfig(), other.timeoutConfig())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateJobTemplateRequest").add("JobTemplateId", jobTemplateId()).add("JobArn", jobArn())
                .add("DocumentSource", documentSource()).add("Document", document()).add("Description", description())
                .add("PresignedUrlConfig", presignedUrlConfig()).add("JobExecutionsRolloutConfig", jobExecutionsRolloutConfig())
                .add("AbortConfig", abortConfig()).add("TimeoutConfig", timeoutConfig()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobTemplateId":
            return Optional.ofNullable(clazz.cast(jobTemplateId()));
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "documentSource":
            return Optional.ofNullable(clazz.cast(documentSource()));
        case "document":
            return Optional.ofNullable(clazz.cast(document()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "presignedUrlConfig":
            return Optional.ofNullable(clazz.cast(presignedUrlConfig()));
        case "jobExecutionsRolloutConfig":
            return Optional.ofNullable(clazz.cast(jobExecutionsRolloutConfig()));
        case "abortConfig":
            return Optional.ofNullable(clazz.cast(abortConfig()));
        case "timeoutConfig":
            return Optional.ofNullable(clazz.cast(timeoutConfig()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJobTemplateRequest, T> g) {
        return obj -> g.apply((CreateJobTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateJobTemplateRequest> {
        /**
         * <p>
         * A unique identifier for the job template. We recommend using a UUID. Alpha-numeric characters, "-", and "_"
         * are valid for use here.
         * </p>
         * 
         * @param jobTemplateId
         *        A unique identifier for the job template. We recommend using a UUID. Alpha-numeric characters, "-",
         *        and "_" are valid for use here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTemplateId(String jobTemplateId);

        /**
         * <p>
         * The ARN of the job to use as the basis for the job template.
         * </p>
         * 
         * @param jobArn
         *        The ARN of the job to use as the basis for the job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * An S3 link to the job document to use in the template. Required if you don't specify a value for
         * <code>document</code>.
         * </p>
         * <note>
         * <p>
         * If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.
         * </p>
         * <p>
         * The placeholder link is of the following form:
         * </p>
         * <p>
         * <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code>
         * </p>
         * <p>
         * where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are linking.
         * </p>
         * </note>
         * 
         * @param documentSource
         *        An S3 link to the job document to use in the template. Required if you don't specify a value for
         *        <code>document</code>.</p> <note>
         *        <p>
         *        If the job document resides in an S3 bucket, you must use a placeholder link when specifying the
         *        document.
         *        </p>
         *        <p>
         *        The placeholder link is of the following form:
         *        </p>
         *        <p>
         *        <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code>
         *        </p>
         *        <p>
         *        where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are
         *        linking.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentSource(String documentSource);

        /**
         * <p>
         * The job document. Required if you don't specify a value for <code>documentSource</code>.
         * </p>
         * 
         * @param document
         *        The job document. Required if you don't specify a value for <code>documentSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(String document);

        /**
         * <p>
         * A description of the job document.
         * </p>
         * 
         * @param description
         *        A description of the job document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the PresignedUrlConfig property for this object.
         *
         * @param presignedUrlConfig
         *        The new value for the PresignedUrlConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presignedUrlConfig(PresignedUrlConfig presignedUrlConfig);

        /**
         * Sets the value of the PresignedUrlConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link PresignedUrlConfig.Builder} avoiding the need to
         * create one manually via {@link PresignedUrlConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link PresignedUrlConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #presignedUrlConfig(PresignedUrlConfig)}.
         * 
         * @param presignedUrlConfig
         *        a consumer that will call methods on {@link PresignedUrlConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #presignedUrlConfig(PresignedUrlConfig)
         */
        default Builder presignedUrlConfig(Consumer<PresignedUrlConfig.Builder> presignedUrlConfig) {
            return presignedUrlConfig(PresignedUrlConfig.builder().applyMutation(presignedUrlConfig).build());
        }

        /**
         * Sets the value of the JobExecutionsRolloutConfig property for this object.
         *
         * @param jobExecutionsRolloutConfig
         *        The new value for the JobExecutionsRolloutConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobExecutionsRolloutConfig(JobExecutionsRolloutConfig jobExecutionsRolloutConfig);

        /**
         * Sets the value of the JobExecutionsRolloutConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link JobExecutionsRolloutConfig.Builder} avoiding the
         * need to create one manually via {@link JobExecutionsRolloutConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobExecutionsRolloutConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #jobExecutionsRolloutConfig(JobExecutionsRolloutConfig)}.
         * 
         * @param jobExecutionsRolloutConfig
         *        a consumer that will call methods on {@link JobExecutionsRolloutConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobExecutionsRolloutConfig(JobExecutionsRolloutConfig)
         */
        default Builder jobExecutionsRolloutConfig(Consumer<JobExecutionsRolloutConfig.Builder> jobExecutionsRolloutConfig) {
            return jobExecutionsRolloutConfig(JobExecutionsRolloutConfig.builder().applyMutation(jobExecutionsRolloutConfig)
                    .build());
        }

        /**
         * Sets the value of the AbortConfig property for this object.
         *
         * @param abortConfig
         *        The new value for the AbortConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortConfig(AbortConfig abortConfig);

        /**
         * Sets the value of the AbortConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link AbortConfig.Builder} avoiding the need to create
         * one manually via {@link AbortConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AbortConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #abortConfig(AbortConfig)}.
         * 
         * @param abortConfig
         *        a consumer that will call methods on {@link AbortConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #abortConfig(AbortConfig)
         */
        default Builder abortConfig(Consumer<AbortConfig.Builder> abortConfig) {
            return abortConfig(AbortConfig.builder().applyMutation(abortConfig).build());
        }

        /**
         * Sets the value of the TimeoutConfig property for this object.
         *
         * @param timeoutConfig
         *        The new value for the TimeoutConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutConfig(TimeoutConfig timeoutConfig);

        /**
         * Sets the value of the TimeoutConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link TimeoutConfig.Builder} avoiding the need to
         * create one manually via {@link TimeoutConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimeoutConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #timeoutConfig(TimeoutConfig)}.
         * 
         * @param timeoutConfig
         *        a consumer that will call methods on {@link TimeoutConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeoutConfig(TimeoutConfig)
         */
        default Builder timeoutConfig(Consumer<TimeoutConfig.Builder> timeoutConfig) {
            return timeoutConfig(TimeoutConfig.builder().applyMutation(timeoutConfig).build());
        }

        /**
         * <p>
         * Metadata that can be used to manage the job template.
         * </p>
         * 
         * @param tags
         *        Metadata that can be used to manage the job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Metadata that can be used to manage the job template.
         * </p>
         * 
         * @param tags
         *        Metadata that can be used to manage the job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Metadata that can be used to manage the job template.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String jobTemplateId;

        private String jobArn;

        private String documentSource;

        private String document;

        private String description;

        private PresignedUrlConfig presignedUrlConfig;

        private JobExecutionsRolloutConfig jobExecutionsRolloutConfig;

        private AbortConfig abortConfig;

        private TimeoutConfig timeoutConfig;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobTemplateRequest model) {
            super(model);
            jobTemplateId(model.jobTemplateId);
            jobArn(model.jobArn);
            documentSource(model.documentSource);
            document(model.document);
            description(model.description);
            presignedUrlConfig(model.presignedUrlConfig);
            jobExecutionsRolloutConfig(model.jobExecutionsRolloutConfig);
            abortConfig(model.abortConfig);
            timeoutConfig(model.timeoutConfig);
            tags(model.tags);
        }

        public final String getJobTemplateId() {
            return jobTemplateId;
        }

        public final void setJobTemplateId(String jobTemplateId) {
            this.jobTemplateId = jobTemplateId;
        }

        @Override
        @Transient
        public final Builder jobTemplateId(String jobTemplateId) {
            this.jobTemplateId = jobTemplateId;
            return this;
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        @Transient
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getDocumentSource() {
            return documentSource;
        }

        public final void setDocumentSource(String documentSource) {
            this.documentSource = documentSource;
        }

        @Override
        @Transient
        public final Builder documentSource(String documentSource) {
            this.documentSource = documentSource;
            return this;
        }

        public final String getDocument() {
            return document;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        @Override
        @Transient
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final PresignedUrlConfig.Builder getPresignedUrlConfig() {
            return presignedUrlConfig != null ? presignedUrlConfig.toBuilder() : null;
        }

        public final void setPresignedUrlConfig(PresignedUrlConfig.BuilderImpl presignedUrlConfig) {
            this.presignedUrlConfig = presignedUrlConfig != null ? presignedUrlConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder presignedUrlConfig(PresignedUrlConfig presignedUrlConfig) {
            this.presignedUrlConfig = presignedUrlConfig;
            return this;
        }

        public final JobExecutionsRolloutConfig.Builder getJobExecutionsRolloutConfig() {
            return jobExecutionsRolloutConfig != null ? jobExecutionsRolloutConfig.toBuilder() : null;
        }

        public final void setJobExecutionsRolloutConfig(JobExecutionsRolloutConfig.BuilderImpl jobExecutionsRolloutConfig) {
            this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig != null ? jobExecutionsRolloutConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder jobExecutionsRolloutConfig(JobExecutionsRolloutConfig jobExecutionsRolloutConfig) {
            this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig;
            return this;
        }

        public final AbortConfig.Builder getAbortConfig() {
            return abortConfig != null ? abortConfig.toBuilder() : null;
        }

        public final void setAbortConfig(AbortConfig.BuilderImpl abortConfig) {
            this.abortConfig = abortConfig != null ? abortConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder abortConfig(AbortConfig abortConfig) {
            this.abortConfig = abortConfig;
            return this;
        }

        public final TimeoutConfig.Builder getTimeoutConfig() {
            return timeoutConfig != null ? timeoutConfig.toBuilder() : null;
        }

        public final void setTimeoutConfig(TimeoutConfig.BuilderImpl timeoutConfig) {
            this.timeoutConfig = timeoutConfig != null ? timeoutConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder timeoutConfig(TimeoutConfig timeoutConfig) {
            this.timeoutConfig = timeoutConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJobTemplateRequest build() {
            return new CreateJobTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
