/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The criteria that determine when and how a job abort takes place.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsJobAbortConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsJobAbortConfig.Builder, AwsJobAbortConfig> {
    private static final SdkField<List<AwsJobAbortCriteria>> ABORT_CRITERIA_LIST_FIELD = SdkField
            .<List<AwsJobAbortCriteria>> builder(MarshallingType.LIST)
            .memberName("abortCriteriaList")
            .getter(getter(AwsJobAbortConfig::abortCriteriaList))
            .setter(setter(Builder::abortCriteriaList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("abortCriteriaList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsJobAbortCriteria> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsJobAbortCriteria::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ABORT_CRITERIA_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AwsJobAbortCriteria> abortCriteriaList;

    private AwsJobAbortConfig(BuilderImpl builder) {
        this.abortCriteriaList = builder.abortCriteriaList;
    }

    /**
     * Returns true if the AbortCriteriaList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAbortCriteriaList() {
        return abortCriteriaList != null && !(abortCriteriaList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of criteria that determine when and how to abort the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAbortCriteriaList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of criteria that determine when and how to abort the job.
     */
    public final List<AwsJobAbortCriteria> abortCriteriaList() {
        return abortCriteriaList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAbortCriteriaList() ? abortCriteriaList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsJobAbortConfig)) {
            return false;
        }
        AwsJobAbortConfig other = (AwsJobAbortConfig) obj;
        return hasAbortCriteriaList() == other.hasAbortCriteriaList()
                && Objects.equals(abortCriteriaList(), other.abortCriteriaList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsJobAbortConfig")
                .add("AbortCriteriaList", hasAbortCriteriaList() ? abortCriteriaList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "abortCriteriaList":
            return Optional.ofNullable(clazz.cast(abortCriteriaList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsJobAbortConfig, T> g) {
        return obj -> g.apply((AwsJobAbortConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsJobAbortConfig> {
        /**
         * <p>
         * The list of criteria that determine when and how to abort the job.
         * </p>
         * 
         * @param abortCriteriaList
         *        The list of criteria that determine when and how to abort the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortCriteriaList(Collection<AwsJobAbortCriteria> abortCriteriaList);

        /**
         * <p>
         * The list of criteria that determine when and how to abort the job.
         * </p>
         * 
         * @param abortCriteriaList
         *        The list of criteria that determine when and how to abort the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortCriteriaList(AwsJobAbortCriteria... abortCriteriaList);

        /**
         * <p>
         * The list of criteria that determine when and how to abort the job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsJobAbortCriteria>.Builder} avoiding the
         * need to create one manually via {@link List<AwsJobAbortCriteria>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsJobAbortCriteria>.Builder#build()} is called immediately
         * and its result is passed to {@link #abortCriteriaList(List<AwsJobAbortCriteria>)}.
         * 
         * @param abortCriteriaList
         *        a consumer that will call methods on {@link List<AwsJobAbortCriteria>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #abortCriteriaList(List<AwsJobAbortCriteria>)
         */
        Builder abortCriteriaList(Consumer<AwsJobAbortCriteria.Builder>... abortCriteriaList);
    }

    static final class BuilderImpl implements Builder {
        private List<AwsJobAbortCriteria> abortCriteriaList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsJobAbortConfig model) {
            abortCriteriaList(model.abortCriteriaList);
        }

        public final List<AwsJobAbortCriteria.Builder> getAbortCriteriaList() {
            List<AwsJobAbortCriteria.Builder> result = AwsJobAbortCriteriaListCopier.copyToBuilder(this.abortCriteriaList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAbortCriteriaList(Collection<AwsJobAbortCriteria.BuilderImpl> abortCriteriaList) {
            this.abortCriteriaList = AwsJobAbortCriteriaListCopier.copyFromBuilder(abortCriteriaList);
        }

        @Override
        @Transient
        public final Builder abortCriteriaList(Collection<AwsJobAbortCriteria> abortCriteriaList) {
            this.abortCriteriaList = AwsJobAbortCriteriaListCopier.copy(abortCriteriaList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder abortCriteriaList(AwsJobAbortCriteria... abortCriteriaList) {
            abortCriteriaList(Arrays.asList(abortCriteriaList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder abortCriteriaList(Consumer<AwsJobAbortCriteria.Builder>... abortCriteriaList) {
            abortCriteriaList(Stream.of(abortCriteriaList).map(c -> AwsJobAbortCriteria.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsJobAbortConfig build() {
            return new AwsJobAbortConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
