/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAuditMitigationActionsExecutionsResponse extends IotResponse implements
        ToCopyableBuilder<ListAuditMitigationActionsExecutionsResponse.Builder, ListAuditMitigationActionsExecutionsResponse> {
    private static final SdkField<List<AuditMitigationActionExecutionMetadata>> ACTIONS_EXECUTIONS_FIELD = SdkField
            .<List<AuditMitigationActionExecutionMetadata>> builder(MarshallingType.LIST)
            .memberName("actionsExecutions")
            .getter(getter(ListAuditMitigationActionsExecutionsResponse::actionsExecutions))
            .setter(setter(Builder::actionsExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionsExecutions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuditMitigationActionExecutionMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuditMitigationActionExecutionMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAuditMitigationActionsExecutionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_EXECUTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AuditMitigationActionExecutionMetadata> actionsExecutions;

    private final String nextToken;

    private ListAuditMitigationActionsExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.actionsExecutions = builder.actionsExecutions;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ActionsExecutions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasActionsExecutions() {
        return actionsExecutions != null && !(actionsExecutions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of task execution results based on the input parameters. Details include the mitigation action applied,
     * start time, and task status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActionsExecutions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A set of task execution results based on the input parameters. Details include the mitigation action
     *         applied, start time, and task status.
     */
    public final List<AuditMitigationActionExecutionMetadata> actionsExecutions() {
        return actionsExecutions;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasActionsExecutions() ? actionsExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuditMitigationActionsExecutionsResponse)) {
            return false;
        }
        ListAuditMitigationActionsExecutionsResponse other = (ListAuditMitigationActionsExecutionsResponse) obj;
        return hasActionsExecutions() == other.hasActionsExecutions()
                && Objects.equals(actionsExecutions(), other.actionsExecutions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAuditMitigationActionsExecutionsResponse")
                .add("ActionsExecutions", hasActionsExecutions() ? actionsExecutions() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionsExecutions":
            return Optional.ofNullable(clazz.cast(actionsExecutions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAuditMitigationActionsExecutionsResponse, T> g) {
        return obj -> g.apply((ListAuditMitigationActionsExecutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAuditMitigationActionsExecutionsResponse> {
        /**
         * <p>
         * A set of task execution results based on the input parameters. Details include the mitigation action applied,
         * start time, and task status.
         * </p>
         * 
         * @param actionsExecutions
         *        A set of task execution results based on the input parameters. Details include the mitigation action
         *        applied, start time, and task status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionsExecutions(Collection<AuditMitigationActionExecutionMetadata> actionsExecutions);

        /**
         * <p>
         * A set of task execution results based on the input parameters. Details include the mitigation action applied,
         * start time, and task status.
         * </p>
         * 
         * @param actionsExecutions
         *        A set of task execution results based on the input parameters. Details include the mitigation action
         *        applied, start time, and task status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionsExecutions(AuditMitigationActionExecutionMetadata... actionsExecutions);

        /**
         * <p>
         * A set of task execution results based on the input parameters. Details include the mitigation action applied,
         * start time, and task status.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AuditMitigationActionExecutionMetadata>.Builder} avoiding the need to create one manually via {@link List
         * <AuditMitigationActionExecutionMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AuditMitigationActionExecutionMetadata>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #actionsExecutions(List<AuditMitigationActionExecutionMetadata>)}.
         * 
         * @param actionsExecutions
         *        a consumer that will call methods on {@link List<AuditMitigationActionExecutionMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionsExecutions(List<AuditMitigationActionExecutionMetadata>)
         */
        Builder actionsExecutions(Consumer<AuditMitigationActionExecutionMetadata.Builder>... actionsExecutions);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<AuditMitigationActionExecutionMetadata> actionsExecutions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuditMitigationActionsExecutionsResponse model) {
            super(model);
            actionsExecutions(model.actionsExecutions);
            nextToken(model.nextToken);
        }

        public final List<AuditMitigationActionExecutionMetadata.Builder> getActionsExecutions() {
            List<AuditMitigationActionExecutionMetadata.Builder> result = AuditMitigationActionExecutionMetadataListCopier
                    .copyToBuilder(this.actionsExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionsExecutions(Collection<AuditMitigationActionExecutionMetadata.BuilderImpl> actionsExecutions) {
            this.actionsExecutions = AuditMitigationActionExecutionMetadataListCopier.copyFromBuilder(actionsExecutions);
        }

        @Override
        @Transient
        public final Builder actionsExecutions(Collection<AuditMitigationActionExecutionMetadata> actionsExecutions) {
            this.actionsExecutions = AuditMitigationActionExecutionMetadataListCopier.copy(actionsExecutions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actionsExecutions(AuditMitigationActionExecutionMetadata... actionsExecutions) {
            actionsExecutions(Arrays.asList(actionsExecutions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actionsExecutions(Consumer<AuditMitigationActionExecutionMetadata.Builder>... actionsExecutions) {
            actionsExecutions(Stream.of(actionsExecutions)
                    .map(c -> AuditMitigationActionExecutionMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAuditMitigationActionsExecutionsResponse build() {
            return new ListAuditMitigationActionsExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
