/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListThingsInThingGroupResponse extends IotResponse implements
        ToCopyableBuilder<ListThingsInThingGroupResponse.Builder, ListThingsInThingGroupResponse> {
    private static final SdkField<List<String>> THINGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("things")
            .getter(getter(ListThingsInThingGroupResponse::things))
            .setter(setter(Builder::things))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("things").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListThingsInThingGroupResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(THINGS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> things;

    private final String nextToken;

    private ListThingsInThingGroupResponse(BuilderImpl builder) {
        super(builder);
        this.things = builder.things;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Things property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasThings() {
        return things != null && !(things instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The things in the specified thing group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasThings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The things in the specified thing group.
     */
    public final List<String> things() {
        return things;
    }

    /**
     * <p>
     * The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasThings() ? things() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingsInThingGroupResponse)) {
            return false;
        }
        ListThingsInThingGroupResponse other = (ListThingsInThingGroupResponse) obj;
        return hasThings() == other.hasThings() && Objects.equals(things(), other.things())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListThingsInThingGroupResponse").add("Things", hasThings() ? things() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "things":
            return Optional.ofNullable(clazz.cast(things()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListThingsInThingGroupResponse, T> g) {
        return obj -> g.apply((ListThingsInThingGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListThingsInThingGroupResponse> {
        /**
         * <p>
         * The things in the specified thing group.
         * </p>
         * 
         * @param things
         *        The things in the specified thing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder things(Collection<String> things);

        /**
         * <p>
         * The things in the specified thing group.
         * </p>
         * 
         * @param things
         *        The things in the specified thing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder things(String... things);

        /**
         * <p>
         * The token to use to get the next set of results, or <b>null</b> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to get the next set of results, or <b>null</b> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<String> things = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingsInThingGroupResponse model) {
            super(model);
            things(model.things);
            nextToken(model.nextToken);
        }

        public final Collection<String> getThings() {
            if (things instanceof SdkAutoConstructList) {
                return null;
            }
            return things;
        }

        public final void setThings(Collection<String> things) {
            this.things = ThingNameListCopier.copy(things);
        }

        @Override
        @Transient
        public final Builder things(Collection<String> things) {
            this.things = ThingNameListCopier.copy(things);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder things(String... things) {
            things(Arrays.asList(things));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListThingsInThingGroupResponse build() {
            return new ListThingsInThingGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
