/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDimensionRequest extends IotRequest implements
        ToCopyableBuilder<UpdateDimensionRequest.Builder, UpdateDimensionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateDimensionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<List<String>> STRING_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("stringValues")
            .getter(getter(UpdateDimensionRequest::stringValues))
            .setter(setter(Builder::stringValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            STRING_VALUES_FIELD));

    private final String name;

    private final List<String> stringValues;

    private UpdateDimensionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.stringValues = builder.stringValues;
    }

    /**
     * <p>
     * A unique identifier for the dimension. Choose something that describes the type and value to make it easy to
     * remember what it does.
     * </p>
     * 
     * @return A unique identifier for the dimension. Choose something that describes the type and value to make it easy
     *         to remember what it does.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns true if the StringValues property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasStringValues() {
        return stringValues != null && !(stringValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the value or list of values for the dimension. For <code>TOPIC_FILTER</code> dimensions, this is a
     * pattern used to match the MQTT topic (for example, "admin/#").
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStringValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the value or list of values for the dimension. For <code>TOPIC_FILTER</code> dimensions, this
     *         is a pattern used to match the MQTT topic (for example, "admin/#").
     */
    public final List<String> stringValues() {
        return stringValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasStringValues() ? stringValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDimensionRequest)) {
            return false;
        }
        UpdateDimensionRequest other = (UpdateDimensionRequest) obj;
        return Objects.equals(name(), other.name()) && hasStringValues() == other.hasStringValues()
                && Objects.equals(stringValues(), other.stringValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDimensionRequest").add("Name", name())
                .add("StringValues", hasStringValues() ? stringValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "stringValues":
            return Optional.ofNullable(clazz.cast(stringValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDimensionRequest, T> g) {
        return obj -> g.apply((UpdateDimensionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDimensionRequest> {
        /**
         * <p>
         * A unique identifier for the dimension. Choose something that describes the type and value to make it easy to
         * remember what it does.
         * </p>
         * 
         * @param name
         *        A unique identifier for the dimension. Choose something that describes the type and value to make it
         *        easy to remember what it does.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the value or list of values for the dimension. For <code>TOPIC_FILTER</code> dimensions, this is a
         * pattern used to match the MQTT topic (for example, "admin/#").
         * </p>
         * 
         * @param stringValues
         *        Specifies the value or list of values for the dimension. For <code>TOPIC_FILTER</code> dimensions,
         *        this is a pattern used to match the MQTT topic (for example, "admin/#").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValues(Collection<String> stringValues);

        /**
         * <p>
         * Specifies the value or list of values for the dimension. For <code>TOPIC_FILTER</code> dimensions, this is a
         * pattern used to match the MQTT topic (for example, "admin/#").
         * </p>
         * 
         * @param stringValues
         *        Specifies the value or list of values for the dimension. For <code>TOPIC_FILTER</code> dimensions,
         *        this is a pattern used to match the MQTT topic (for example, "admin/#").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValues(String... stringValues);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String name;

        private List<String> stringValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDimensionRequest model) {
            super(model);
            name(model.name);
            stringValues(model.stringValues);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getStringValues() {
            if (stringValues instanceof SdkAutoConstructList) {
                return null;
            }
            return stringValues;
        }

        public final void setStringValues(Collection<String> stringValues) {
            this.stringValues = DimensionStringValuesCopier.copy(stringValues);
        }

        @Override
        @Transient
        public final Builder stringValues(Collection<String> stringValues) {
            this.stringValues = DimensionStringValuesCopier.copy(stringValues);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder stringValues(String... stringValues) {
            stringValues(Arrays.asList(stringValues));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDimensionRequest build() {
            return new UpdateDimensionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
