/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The statistics of a mitigation action task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectMitigationActionsTaskStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectMitigationActionsTaskStatistics.Builder, DetectMitigationActionsTaskStatistics> {
    private static final SdkField<Long> ACTIONS_EXECUTED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("actionsExecuted").getter(getter(DetectMitigationActionsTaskStatistics::actionsExecuted))
            .setter(setter(Builder::actionsExecuted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionsExecuted").build()).build();

    private static final SdkField<Long> ACTIONS_SKIPPED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("actionsSkipped").getter(getter(DetectMitigationActionsTaskStatistics::actionsSkipped))
            .setter(setter(Builder::actionsSkipped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionsSkipped").build()).build();

    private static final SdkField<Long> ACTIONS_FAILED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("actionsFailed").getter(getter(DetectMitigationActionsTaskStatistics::actionsFailed))
            .setter(setter(Builder::actionsFailed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionsFailed").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_EXECUTED_FIELD,
            ACTIONS_SKIPPED_FIELD, ACTIONS_FAILED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long actionsExecuted;

    private final Long actionsSkipped;

    private final Long actionsFailed;

    private DetectMitigationActionsTaskStatistics(BuilderImpl builder) {
        this.actionsExecuted = builder.actionsExecuted;
        this.actionsSkipped = builder.actionsSkipped;
        this.actionsFailed = builder.actionsFailed;
    }

    /**
     * <p>
     * The actions that were performed.
     * </p>
     * 
     * @return The actions that were performed.
     */
    public final Long actionsExecuted() {
        return actionsExecuted;
    }

    /**
     * <p>
     * The actions that were skipped.
     * </p>
     * 
     * @return The actions that were skipped.
     */
    public final Long actionsSkipped() {
        return actionsSkipped;
    }

    /**
     * <p>
     * The actions that failed.
     * </p>
     * 
     * @return The actions that failed.
     */
    public final Long actionsFailed() {
        return actionsFailed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionsExecuted());
        hashCode = 31 * hashCode + Objects.hashCode(actionsSkipped());
        hashCode = 31 * hashCode + Objects.hashCode(actionsFailed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectMitigationActionsTaskStatistics)) {
            return false;
        }
        DetectMitigationActionsTaskStatistics other = (DetectMitigationActionsTaskStatistics) obj;
        return Objects.equals(actionsExecuted(), other.actionsExecuted())
                && Objects.equals(actionsSkipped(), other.actionsSkipped())
                && Objects.equals(actionsFailed(), other.actionsFailed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectMitigationActionsTaskStatistics").add("ActionsExecuted", actionsExecuted())
                .add("ActionsSkipped", actionsSkipped()).add("ActionsFailed", actionsFailed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionsExecuted":
            return Optional.ofNullable(clazz.cast(actionsExecuted()));
        case "actionsSkipped":
            return Optional.ofNullable(clazz.cast(actionsSkipped()));
        case "actionsFailed":
            return Optional.ofNullable(clazz.cast(actionsFailed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectMitigationActionsTaskStatistics, T> g) {
        return obj -> g.apply((DetectMitigationActionsTaskStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectMitigationActionsTaskStatistics> {
        /**
         * <p>
         * The actions that were performed.
         * </p>
         * 
         * @param actionsExecuted
         *        The actions that were performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionsExecuted(Long actionsExecuted);

        /**
         * <p>
         * The actions that were skipped.
         * </p>
         * 
         * @param actionsSkipped
         *        The actions that were skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionsSkipped(Long actionsSkipped);

        /**
         * <p>
         * The actions that failed.
         * </p>
         * 
         * @param actionsFailed
         *        The actions that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionsFailed(Long actionsFailed);
    }

    static final class BuilderImpl implements Builder {
        private Long actionsExecuted;

        private Long actionsSkipped;

        private Long actionsFailed;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectMitigationActionsTaskStatistics model) {
            actionsExecuted(model.actionsExecuted);
            actionsSkipped(model.actionsSkipped);
            actionsFailed(model.actionsFailed);
        }

        public final Long getActionsExecuted() {
            return actionsExecuted;
        }

        public final void setActionsExecuted(Long actionsExecuted) {
            this.actionsExecuted = actionsExecuted;
        }

        @Override
        @Transient
        public final Builder actionsExecuted(Long actionsExecuted) {
            this.actionsExecuted = actionsExecuted;
            return this;
        }

        public final Long getActionsSkipped() {
            return actionsSkipped;
        }

        public final void setActionsSkipped(Long actionsSkipped) {
            this.actionsSkipped = actionsSkipped;
        }

        @Override
        @Transient
        public final Builder actionsSkipped(Long actionsSkipped) {
            this.actionsSkipped = actionsSkipped;
            return this;
        }

        public final Long getActionsFailed() {
            return actionsFailed;
        }

        public final void setActionsFailed(Long actionsFailed) {
            this.actionsFailed = actionsFailed;
        }

        @Override
        @Transient
        public final Builder actionsFailed(Long actionsFailed) {
            this.actionsFailed = actionsFailed;
            return this;
        }

        @Override
        public DetectMitigationActionsTaskStatistics build() {
            return new DetectMitigationActionsTaskStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
