/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAuditFindingsRequest extends IotRequest implements
        ToCopyableBuilder<ListAuditFindingsRequest.Builder, ListAuditFindingsRequest> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(ListAuditFindingsRequest::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final SdkField<String> CHECK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("checkName").getter(getter(ListAuditFindingsRequest::checkName)).setter(setter(Builder::checkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkName").build()).build();

    private static final SdkField<ResourceIdentifier> RESOURCE_IDENTIFIER_FIELD = SdkField
            .<ResourceIdentifier> builder(MarshallingType.SDK_POJO).memberName("resourceIdentifier")
            .getter(getter(ListAuditFindingsRequest::resourceIdentifier)).setter(setter(Builder::resourceIdentifier))
            .constructor(ResourceIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListAuditFindingsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAuditFindingsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(ListAuditFindingsRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(ListAuditFindingsRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<Boolean> LIST_SUPPRESSED_FINDINGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("listSuppressedFindings").getter(getter(ListAuditFindingsRequest::listSuppressedFindings))
            .setter(setter(Builder::listSuppressedFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listSuppressedFindings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD,
            CHECK_NAME_FIELD, RESOURCE_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, START_TIME_FIELD, END_TIME_FIELD,
            LIST_SUPPRESSED_FINDINGS_FIELD));

    private final String taskId;

    private final String checkName;

    private final ResourceIdentifier resourceIdentifier;

    private final Integer maxResults;

    private final String nextToken;

    private final Instant startTime;

    private final Instant endTime;

    private final Boolean listSuppressedFindings;

    private ListAuditFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
        this.checkName = builder.checkName;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.listSuppressedFindings = builder.listSuppressedFindings;
    }

    /**
     * <p>
     * A filter to limit results to the audit with the specified ID. You must specify either the taskId or the startTime
     * and endTime, but not both.
     * </p>
     * 
     * @return A filter to limit results to the audit with the specified ID. You must specify either the taskId or the
     *         startTime and endTime, but not both.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * A filter to limit results to the findings for the specified audit check.
     * </p>
     * 
     * @return A filter to limit results to the findings for the specified audit check.
     */
    public final String checkName() {
        return checkName;
    }

    /**
     * <p>
     * Information identifying the noncompliant resource.
     * </p>
     * 
     * @return Information identifying the noncompliant resource.
     */
    public final ResourceIdentifier resourceIdentifier() {
        return resourceIdentifier;
    }

    /**
     * <p>
     * The maximum number of results to return at one time. The default is 25.
     * </p>
     * 
     * @return The maximum number of results to return at one time. The default is 25.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A filter to limit results to those found after the specified time. You must specify either the startTime and
     * endTime or the taskId, but not both.
     * </p>
     * 
     * @return A filter to limit results to those found after the specified time. You must specify either the startTime
     *         and endTime or the taskId, but not both.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * A filter to limit results to those found before the specified time. You must specify either the startTime and
     * endTime or the taskId, but not both.
     * </p>
     * 
     * @return A filter to limit results to those found before the specified time. You must specify either the startTime
     *         and endTime or the taskId, but not both.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Boolean flag indicating whether only the suppressed findings or the unsuppressed findings should be listed. If
     * this parameter isn't provided, the response will list both suppressed and unsuppressed findings.
     * </p>
     * 
     * @return Boolean flag indicating whether only the suppressed findings or the unsuppressed findings should be
     *         listed. If this parameter isn't provided, the response will list both suppressed and unsuppressed
     *         findings.
     */
    public final Boolean listSuppressedFindings() {
        return listSuppressedFindings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(checkName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(listSuppressedFindings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuditFindingsRequest)) {
            return false;
        }
        ListAuditFindingsRequest other = (ListAuditFindingsRequest) obj;
        return Objects.equals(taskId(), other.taskId()) && Objects.equals(checkName(), other.checkName())
                && Objects.equals(resourceIdentifier(), other.resourceIdentifier())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(listSuppressedFindings(), other.listSuppressedFindings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAuditFindingsRequest").add("TaskId", taskId()).add("CheckName", checkName())
                .add("ResourceIdentifier", resourceIdentifier()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("ListSuppressedFindings", listSuppressedFindings())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "checkName":
            return Optional.ofNullable(clazz.cast(checkName()));
        case "resourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "listSuppressedFindings":
            return Optional.ofNullable(clazz.cast(listSuppressedFindings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAuditFindingsRequest, T> g) {
        return obj -> g.apply((ListAuditFindingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAuditFindingsRequest> {
        /**
         * <p>
         * A filter to limit results to the audit with the specified ID. You must specify either the taskId or the
         * startTime and endTime, but not both.
         * </p>
         * 
         * @param taskId
         *        A filter to limit results to the audit with the specified ID. You must specify either the taskId or
         *        the startTime and endTime, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * A filter to limit results to the findings for the specified audit check.
         * </p>
         * 
         * @param checkName
         *        A filter to limit results to the findings for the specified audit check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkName(String checkName);

        /**
         * <p>
         * Information identifying the noncompliant resource.
         * </p>
         * 
         * @param resourceIdentifier
         *        Information identifying the noncompliant resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(ResourceIdentifier resourceIdentifier);

        /**
         * <p>
         * Information identifying the noncompliant resource.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceIdentifier.Builder} avoiding the need to
         * create one manually via {@link ResourceIdentifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceIdentifier(ResourceIdentifier)}.
         * 
         * @param resourceIdentifier
         *        a consumer that will call methods on {@link ResourceIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceIdentifier(ResourceIdentifier)
         */
        default Builder resourceIdentifier(Consumer<ResourceIdentifier.Builder> resourceIdentifier) {
            return resourceIdentifier(ResourceIdentifier.builder().applyMutation(resourceIdentifier).build());
        }

        /**
         * <p>
         * The maximum number of results to return at one time. The default is 25.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return at one time. The default is 25.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A filter to limit results to those found after the specified time. You must specify either the startTime and
         * endTime or the taskId, but not both.
         * </p>
         * 
         * @param startTime
         *        A filter to limit results to those found after the specified time. You must specify either the
         *        startTime and endTime or the taskId, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * A filter to limit results to those found before the specified time. You must specify either the startTime and
         * endTime or the taskId, but not both.
         * </p>
         * 
         * @param endTime
         *        A filter to limit results to those found before the specified time. You must specify either the
         *        startTime and endTime or the taskId, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Boolean flag indicating whether only the suppressed findings or the unsuppressed findings should be listed.
         * If this parameter isn't provided, the response will list both suppressed and unsuppressed findings.
         * </p>
         * 
         * @param listSuppressedFindings
         *        Boolean flag indicating whether only the suppressed findings or the unsuppressed findings should be
         *        listed. If this parameter isn't provided, the response will list both suppressed and unsuppressed
         *        findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listSuppressedFindings(Boolean listSuppressedFindings);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String taskId;

        private String checkName;

        private ResourceIdentifier resourceIdentifier;

        private Integer maxResults;

        private String nextToken;

        private Instant startTime;

        private Instant endTime;

        private Boolean listSuppressedFindings;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuditFindingsRequest model) {
            super(model);
            taskId(model.taskId);
            checkName(model.checkName);
            resourceIdentifier(model.resourceIdentifier);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            startTime(model.startTime);
            endTime(model.endTime);
            listSuppressedFindings(model.listSuppressedFindings);
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        @Transient
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getCheckName() {
            return checkName;
        }

        public final void setCheckName(String checkName) {
            this.checkName = checkName;
        }

        @Override
        @Transient
        public final Builder checkName(String checkName) {
            this.checkName = checkName;
            return this;
        }

        public final ResourceIdentifier.Builder getResourceIdentifier() {
            return resourceIdentifier != null ? resourceIdentifier.toBuilder() : null;
        }

        public final void setResourceIdentifier(ResourceIdentifier.BuilderImpl resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier != null ? resourceIdentifier.build() : null;
        }

        @Override
        @Transient
        public final Builder resourceIdentifier(ResourceIdentifier resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Boolean getListSuppressedFindings() {
            return listSuppressedFindings;
        }

        public final void setListSuppressedFindings(Boolean listSuppressedFindings) {
            this.listSuppressedFindings = listSuppressedFindings;
        }

        @Override
        @Transient
        public final Builder listSuppressedFindings(Boolean listSuppressedFindings) {
            this.listSuppressedFindings = listSuppressedFindings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAuditFindingsRequest build() {
            return new ListAuditFindingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
