/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a CA certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CACertificateDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<CACertificateDescription.Builder, CACertificateDescription> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateArn").getter(getter(CACertificateDescription::certificateArn))
            .setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()).build();

    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateId").getter(getter(CACertificateDescription::certificateId))
            .setter(setter(Builder::certificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CACertificateDescription::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> CERTIFICATE_PEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificatePem").getter(getter(CACertificateDescription::certificatePem))
            .setter(setter(Builder::certificatePem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificatePem").build()).build();

    private static final SdkField<String> OWNED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownedBy").getter(getter(CACertificateDescription::ownedBy)).setter(setter(Builder::ownedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownedBy").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(CACertificateDescription::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<String> AUTO_REGISTRATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("autoRegistrationStatus").getter(getter(CACertificateDescription::autoRegistrationStatusAsString))
            .setter(setter(Builder::autoRegistrationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRegistrationStatus").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedDate").getter(getter(CACertificateDescription::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final SdkField<Integer> CUSTOMER_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("customerVersion").getter(getter(CACertificateDescription::customerVersion))
            .setter(setter(Builder::customerVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerVersion").build()).build();

    private static final SdkField<String> GENERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("generationId").getter(getter(CACertificateDescription::generationId))
            .setter(setter(Builder::generationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationId").build()).build();

    private static final SdkField<CertificateValidity> VALIDITY_FIELD = SdkField
            .<CertificateValidity> builder(MarshallingType.SDK_POJO).memberName("validity")
            .getter(getter(CACertificateDescription::validity)).setter(setter(Builder::validity))
            .constructor(CertificateValidity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CERTIFICATE_ARN_FIELD, CERTIFICATE_ID_FIELD, STATUS_FIELD, CERTIFICATE_PEM_FIELD, OWNED_BY_FIELD,
                    CREATION_DATE_FIELD, AUTO_REGISTRATION_STATUS_FIELD, LAST_MODIFIED_DATE_FIELD, CUSTOMER_VERSION_FIELD,
                    GENERATION_ID_FIELD, VALIDITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String certificateArn;

    private final String certificateId;

    private final String status;

    private final String certificatePem;

    private final String ownedBy;

    private final Instant creationDate;

    private final String autoRegistrationStatus;

    private final Instant lastModifiedDate;

    private final Integer customerVersion;

    private final String generationId;

    private final CertificateValidity validity;

    private CACertificateDescription(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificateId = builder.certificateId;
        this.status = builder.status;
        this.certificatePem = builder.certificatePem;
        this.ownedBy = builder.ownedBy;
        this.creationDate = builder.creationDate;
        this.autoRegistrationStatus = builder.autoRegistrationStatus;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.customerVersion = builder.customerVersion;
        this.generationId = builder.generationId;
        this.validity = builder.validity;
    }

    /**
     * <p>
     * The CA certificate ARN.
     * </p>
     * 
     * @return The CA certificate ARN.
     */
    public final String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The CA certificate ID.
     * </p>
     * 
     * @return The CA certificate ID.
     */
    public final String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The status of a CA certificate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CACertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a CA certificate.
     * @see CACertificateStatus
     */
    public final CACertificateStatus status() {
        return CACertificateStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a CA certificate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CACertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a CA certificate.
     * @see CACertificateStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The CA certificate data, in PEM format.
     * </p>
     * 
     * @return The CA certificate data, in PEM format.
     */
    public final String certificatePem() {
        return certificatePem;
    }

    /**
     * <p>
     * The owner of the CA certificate.
     * </p>
     * 
     * @return The owner of the CA certificate.
     */
    public final String ownedBy() {
        return ownedBy;
    }

    /**
     * <p>
     * The date the CA certificate was created.
     * </p>
     * 
     * @return The date the CA certificate was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * Whether the CA certificate configured for auto registration of device certificates. Valid values are "ENABLE" and
     * "DISABLE"
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoRegistrationStatus} will return {@link AutoRegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #autoRegistrationStatusAsString}.
     * </p>
     * 
     * @return Whether the CA certificate configured for auto registration of device certificates. Valid values are
     *         "ENABLE" and "DISABLE"
     * @see AutoRegistrationStatus
     */
    public final AutoRegistrationStatus autoRegistrationStatus() {
        return AutoRegistrationStatus.fromValue(autoRegistrationStatus);
    }

    /**
     * <p>
     * Whether the CA certificate configured for auto registration of device certificates. Valid values are "ENABLE" and
     * "DISABLE"
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoRegistrationStatus} will return {@link AutoRegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #autoRegistrationStatusAsString}.
     * </p>
     * 
     * @return Whether the CA certificate configured for auto registration of device certificates. Valid values are
     *         "ENABLE" and "DISABLE"
     * @see AutoRegistrationStatus
     */
    public final String autoRegistrationStatusAsString() {
        return autoRegistrationStatus;
    }

    /**
     * <p>
     * The date the CA certificate was last modified.
     * </p>
     * 
     * @return The date the CA certificate was last modified.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The customer version of the CA certificate.
     * </p>
     * 
     * @return The customer version of the CA certificate.
     */
    public final Integer customerVersion() {
        return customerVersion;
    }

    /**
     * <p>
     * The generation ID of the CA certificate.
     * </p>
     * 
     * @return The generation ID of the CA certificate.
     */
    public final String generationId() {
        return generationId;
    }

    /**
     * <p>
     * When the CA certificate is valid.
     * </p>
     * 
     * @return When the CA certificate is valid.
     */
    public final CertificateValidity validity() {
        return validity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(certificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(ownedBy());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(autoRegistrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(customerVersion());
        hashCode = 31 * hashCode + Objects.hashCode(generationId());
        hashCode = 31 * hashCode + Objects.hashCode(validity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CACertificateDescription)) {
            return false;
        }
        CACertificateDescription other = (CACertificateDescription) obj;
        return Objects.equals(certificateArn(), other.certificateArn()) && Objects.equals(certificateId(), other.certificateId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(certificatePem(), other.certificatePem()) && Objects.equals(ownedBy(), other.ownedBy())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(autoRegistrationStatusAsString(), other.autoRegistrationStatusAsString())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(customerVersion(), other.customerVersion())
                && Objects.equals(generationId(), other.generationId()) && Objects.equals(validity(), other.validity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CACertificateDescription").add("CertificateArn", certificateArn())
                .add("CertificateId", certificateId()).add("Status", statusAsString()).add("CertificatePem", certificatePem())
                .add("OwnedBy", ownedBy()).add("CreationDate", creationDate())
                .add("AutoRegistrationStatus", autoRegistrationStatusAsString()).add("LastModifiedDate", lastModifiedDate())
                .add("CustomerVersion", customerVersion()).add("GenerationId", generationId()).add("Validity", validity())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "certificateId":
            return Optional.ofNullable(clazz.cast(certificateId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "certificatePem":
            return Optional.ofNullable(clazz.cast(certificatePem()));
        case "ownedBy":
            return Optional.ofNullable(clazz.cast(ownedBy()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "autoRegistrationStatus":
            return Optional.ofNullable(clazz.cast(autoRegistrationStatusAsString()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "customerVersion":
            return Optional.ofNullable(clazz.cast(customerVersion()));
        case "generationId":
            return Optional.ofNullable(clazz.cast(generationId()));
        case "validity":
            return Optional.ofNullable(clazz.cast(validity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CACertificateDescription, T> g) {
        return obj -> g.apply((CACertificateDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CACertificateDescription> {
        /**
         * <p>
         * The CA certificate ARN.
         * </p>
         * 
         * @param certificateArn
         *        The CA certificate ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The CA certificate ID.
         * </p>
         * 
         * @param certificateId
         *        The CA certificate ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The status of a CA certificate.
         * </p>
         * 
         * @param status
         *        The status of a CA certificate.
         * @see CACertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CACertificateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a CA certificate.
         * </p>
         * 
         * @param status
         *        The status of a CA certificate.
         * @see CACertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CACertificateStatus
         */
        Builder status(CACertificateStatus status);

        /**
         * <p>
         * The CA certificate data, in PEM format.
         * </p>
         * 
         * @param certificatePem
         *        The CA certificate data, in PEM format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatePem(String certificatePem);

        /**
         * <p>
         * The owner of the CA certificate.
         * </p>
         * 
         * @param ownedBy
         *        The owner of the CA certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownedBy(String ownedBy);

        /**
         * <p>
         * The date the CA certificate was created.
         * </p>
         * 
         * @param creationDate
         *        The date the CA certificate was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * Whether the CA certificate configured for auto registration of device certificates. Valid values are "ENABLE"
         * and "DISABLE"
         * </p>
         * 
         * @param autoRegistrationStatus
         *        Whether the CA certificate configured for auto registration of device certificates. Valid values are
         *        "ENABLE" and "DISABLE"
         * @see AutoRegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoRegistrationStatus
         */
        Builder autoRegistrationStatus(String autoRegistrationStatus);

        /**
         * <p>
         * Whether the CA certificate configured for auto registration of device certificates. Valid values are "ENABLE"
         * and "DISABLE"
         * </p>
         * 
         * @param autoRegistrationStatus
         *        Whether the CA certificate configured for auto registration of device certificates. Valid values are
         *        "ENABLE" and "DISABLE"
         * @see AutoRegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoRegistrationStatus
         */
        Builder autoRegistrationStatus(AutoRegistrationStatus autoRegistrationStatus);

        /**
         * <p>
         * The date the CA certificate was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date the CA certificate was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The customer version of the CA certificate.
         * </p>
         * 
         * @param customerVersion
         *        The customer version of the CA certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerVersion(Integer customerVersion);

        /**
         * <p>
         * The generation ID of the CA certificate.
         * </p>
         * 
         * @param generationId
         *        The generation ID of the CA certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationId(String generationId);

        /**
         * <p>
         * When the CA certificate is valid.
         * </p>
         * 
         * @param validity
         *        When the CA certificate is valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validity(CertificateValidity validity);

        /**
         * <p>
         * When the CA certificate is valid.
         * </p>
         * This is a convenience method that creates an instance of the {@link CertificateValidity.Builder} avoiding the
         * need to create one manually via {@link CertificateValidity#builder()}.
         *
         * When the {@link Consumer} completes, {@link CertificateValidity.Builder#build()} is called immediately and
         * its result is passed to {@link #validity(CertificateValidity)}.
         * 
         * @param validity
         *        a consumer that will call methods on {@link CertificateValidity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validity(CertificateValidity)
         */
        default Builder validity(Consumer<CertificateValidity.Builder> validity) {
            return validity(CertificateValidity.builder().applyMutation(validity).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String certificateArn;

        private String certificateId;

        private String status;

        private String certificatePem;

        private String ownedBy;

        private Instant creationDate;

        private String autoRegistrationStatus;

        private Instant lastModifiedDate;

        private Integer customerVersion;

        private String generationId;

        private CertificateValidity validity;

        private BuilderImpl() {
        }

        private BuilderImpl(CACertificateDescription model) {
            certificateArn(model.certificateArn);
            certificateId(model.certificateId);
            status(model.status);
            certificatePem(model.certificatePem);
            ownedBy(model.ownedBy);
            creationDate(model.creationDate);
            autoRegistrationStatus(model.autoRegistrationStatus);
            lastModifiedDate(model.lastModifiedDate);
            customerVersion(model.customerVersion);
            generationId(model.generationId);
            validity(model.validity);
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        @Transient
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getCertificateId() {
            return certificateId;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Override
        @Transient
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(CACertificateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCertificatePem() {
            return certificatePem;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        @Override
        @Transient
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final String getOwnedBy() {
            return ownedBy;
        }

        public final void setOwnedBy(String ownedBy) {
            this.ownedBy = ownedBy;
        }

        @Override
        @Transient
        public final Builder ownedBy(String ownedBy) {
            this.ownedBy = ownedBy;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        @Transient
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getAutoRegistrationStatus() {
            return autoRegistrationStatus;
        }

        public final void setAutoRegistrationStatus(String autoRegistrationStatus) {
            this.autoRegistrationStatus = autoRegistrationStatus;
        }

        @Override
        @Transient
        public final Builder autoRegistrationStatus(String autoRegistrationStatus) {
            this.autoRegistrationStatus = autoRegistrationStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder autoRegistrationStatus(AutoRegistrationStatus autoRegistrationStatus) {
            this.autoRegistrationStatus(autoRegistrationStatus == null ? null : autoRegistrationStatus.toString());
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        @Transient
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final Integer getCustomerVersion() {
            return customerVersion;
        }

        public final void setCustomerVersion(Integer customerVersion) {
            this.customerVersion = customerVersion;
        }

        @Override
        @Transient
        public final Builder customerVersion(Integer customerVersion) {
            this.customerVersion = customerVersion;
            return this;
        }

        public final String getGenerationId() {
            return generationId;
        }

        public final void setGenerationId(String generationId) {
            this.generationId = generationId;
        }

        @Override
        @Transient
        public final Builder generationId(String generationId) {
            this.generationId = generationId;
            return this;
        }

        public final CertificateValidity.Builder getValidity() {
            return validity != null ? validity.toBuilder() : null;
        }

        public final void setValidity(CertificateValidity.BuilderImpl validity) {
            this.validity = validity != null ? validity.build() : null;
        }

        @Override
        @Transient
        public final Builder validity(CertificateValidity validity) {
            this.validity = validity;
            return this;
        }

        @Override
        public CACertificateDescription build() {
            return new CACertificateDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
