/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAuthorizerRequest extends IotRequest implements
        ToCopyableBuilder<CreateAuthorizerRequest.Builder, CreateAuthorizerRequest> {
    private static final SdkField<String> AUTHORIZER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorizerName").getter(getter(CreateAuthorizerRequest::authorizerName))
            .setter(setter(Builder::authorizerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("authorizerName").build()).build();

    private static final SdkField<String> AUTHORIZER_FUNCTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorizerFunctionArn").getter(getter(CreateAuthorizerRequest::authorizerFunctionArn))
            .setter(setter(Builder::authorizerFunctionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerFunctionArn").build())
            .build();

    private static final SdkField<String> TOKEN_KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tokenKeyName").getter(getter(CreateAuthorizerRequest::tokenKeyName))
            .setter(setter(Builder::tokenKeyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenKeyName").build()).build();

    private static final SdkField<Map<String, String>> TOKEN_SIGNING_PUBLIC_KEYS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tokenSigningPublicKeys")
            .getter(getter(CreateAuthorizerRequest::tokenSigningPublicKeys))
            .setter(setter(Builder::tokenSigningPublicKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenSigningPublicKeys").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateAuthorizerRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateAuthorizerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> SIGNING_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("signingDisabled").getter(getter(CreateAuthorizerRequest::signingDisabled))
            .setter(setter(Builder::signingDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingDisabled").build()).build();

    private static final SdkField<Boolean> ENABLE_CACHING_FOR_HTTP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableCachingForHttp").getter(getter(CreateAuthorizerRequest::enableCachingForHttp))
            .setter(setter(Builder::enableCachingForHttp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableCachingForHttp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZER_NAME_FIELD,
            AUTHORIZER_FUNCTION_ARN_FIELD, TOKEN_KEY_NAME_FIELD, TOKEN_SIGNING_PUBLIC_KEYS_FIELD, STATUS_FIELD, TAGS_FIELD,
            SIGNING_DISABLED_FIELD, ENABLE_CACHING_FOR_HTTP_FIELD));

    private final String authorizerName;

    private final String authorizerFunctionArn;

    private final String tokenKeyName;

    private final Map<String, String> tokenSigningPublicKeys;

    private final String status;

    private final List<Tag> tags;

    private final Boolean signingDisabled;

    private final Boolean enableCachingForHttp;

    private CreateAuthorizerRequest(BuilderImpl builder) {
        super(builder);
        this.authorizerName = builder.authorizerName;
        this.authorizerFunctionArn = builder.authorizerFunctionArn;
        this.tokenKeyName = builder.tokenKeyName;
        this.tokenSigningPublicKeys = builder.tokenSigningPublicKeys;
        this.status = builder.status;
        this.tags = builder.tags;
        this.signingDisabled = builder.signingDisabled;
        this.enableCachingForHttp = builder.enableCachingForHttp;
    }

    /**
     * <p>
     * The authorizer name.
     * </p>
     * 
     * @return The authorizer name.
     */
    public final String authorizerName() {
        return authorizerName;
    }

    /**
     * <p>
     * The ARN of the authorizer's Lambda function.
     * </p>
     * 
     * @return The ARN of the authorizer's Lambda function.
     */
    public final String authorizerFunctionArn() {
        return authorizerFunctionArn;
    }

    /**
     * <p>
     * The name of the token key used to extract the token from the HTTP headers.
     * </p>
     * 
     * @return The name of the token key used to extract the token from the HTTP headers.
     */
    public final String tokenKeyName() {
        return tokenKeyName;
    }

    /**
     * For responses, this returns true if the service returned a value for the TokenSigningPublicKeys property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTokenSigningPublicKeys() {
        return tokenSigningPublicKeys != null && !(tokenSigningPublicKeys instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The public keys used to verify the digital signature returned by your custom authentication service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTokenSigningPublicKeys} method.
     * </p>
     * 
     * @return The public keys used to verify the digital signature returned by your custom authentication service.
     */
    public final Map<String, String> tokenSigningPublicKeys() {
        return tokenSigningPublicKeys;
    }

    /**
     * <p>
     * The status of the create authorizer request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AuthorizerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the create authorizer request.
     * @see AuthorizerStatus
     */
    public final AuthorizerStatus status() {
        return AuthorizerStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the create authorizer request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AuthorizerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the create authorizer request.
     * @see AuthorizerStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata which can be used to manage the custom authorizer.
     * </p>
     * <note>
     * <p>
     * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
     * </p>
     * <p>
     * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
     * </p>
     * <p>
     * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata which can be used to manage the custom authorizer.</p> <note>
     *         <p>
     *         For URI Request parameters use format: ...key1=value1&amp;key2=value2...
     *         </p>
     *         <p>
     *         For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
     *         </p>
     *         <p>
     *         For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
     *         </p>
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies whether IoT validates the token signature in an authorization request.
     * </p>
     * 
     * @return Specifies whether IoT validates the token signature in an authorization request.
     */
    public final Boolean signingDisabled() {
        return signingDisabled;
    }

    /**
     * <p>
     * When <code>true</code>, the result from the authorizer’s Lambda function is cached for clients that use
     * persistent HTTP connections. The results are cached for the time specified by the Lambda function in
     * <code>refreshAfterInSeconds</code>. This value does not affect authorization of clients that use MQTT
     * connections.
     * </p>
     * <p>
     * The default value is <code>false</code>.
     * </p>
     * 
     * @return When <code>true</code>, the result from the authorizer’s Lambda function is cached for clients that use
     *         persistent HTTP connections. The results are cached for the time specified by the Lambda function in
     *         <code>refreshAfterInSeconds</code>. This value does not affect authorization of clients that use MQTT
     *         connections.</p>
     *         <p>
     *         The default value is <code>false</code>.
     */
    public final Boolean enableCachingForHttp() {
        return enableCachingForHttp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authorizerName());
        hashCode = 31 * hashCode + Objects.hashCode(authorizerFunctionArn());
        hashCode = 31 * hashCode + Objects.hashCode(tokenKeyName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTokenSigningPublicKeys() ? tokenSigningPublicKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(signingDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(enableCachingForHttp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAuthorizerRequest)) {
            return false;
        }
        CreateAuthorizerRequest other = (CreateAuthorizerRequest) obj;
        return Objects.equals(authorizerName(), other.authorizerName())
                && Objects.equals(authorizerFunctionArn(), other.authorizerFunctionArn())
                && Objects.equals(tokenKeyName(), other.tokenKeyName())
                && hasTokenSigningPublicKeys() == other.hasTokenSigningPublicKeys()
                && Objects.equals(tokenSigningPublicKeys(), other.tokenSigningPublicKeys())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(signingDisabled(), other.signingDisabled())
                && Objects.equals(enableCachingForHttp(), other.enableCachingForHttp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAuthorizerRequest").add("AuthorizerName", authorizerName())
                .add("AuthorizerFunctionArn", authorizerFunctionArn()).add("TokenKeyName", tokenKeyName())
                .add("TokenSigningPublicKeys", hasTokenSigningPublicKeys() ? tokenSigningPublicKeys() : null)
                .add("Status", statusAsString()).add("Tags", hasTags() ? tags() : null).add("SigningDisabled", signingDisabled())
                .add("EnableCachingForHttp", enableCachingForHttp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorizerName":
            return Optional.ofNullable(clazz.cast(authorizerName()));
        case "authorizerFunctionArn":
            return Optional.ofNullable(clazz.cast(authorizerFunctionArn()));
        case "tokenKeyName":
            return Optional.ofNullable(clazz.cast(tokenKeyName()));
        case "tokenSigningPublicKeys":
            return Optional.ofNullable(clazz.cast(tokenSigningPublicKeys()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "signingDisabled":
            return Optional.ofNullable(clazz.cast(signingDisabled()));
        case "enableCachingForHttp":
            return Optional.ofNullable(clazz.cast(enableCachingForHttp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAuthorizerRequest, T> g) {
        return obj -> g.apply((CreateAuthorizerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAuthorizerRequest> {
        /**
         * <p>
         * The authorizer name.
         * </p>
         * 
         * @param authorizerName
         *        The authorizer name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerName(String authorizerName);

        /**
         * <p>
         * The ARN of the authorizer's Lambda function.
         * </p>
         * 
         * @param authorizerFunctionArn
         *        The ARN of the authorizer's Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerFunctionArn(String authorizerFunctionArn);

        /**
         * <p>
         * The name of the token key used to extract the token from the HTTP headers.
         * </p>
         * 
         * @param tokenKeyName
         *        The name of the token key used to extract the token from the HTTP headers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenKeyName(String tokenKeyName);

        /**
         * <p>
         * The public keys used to verify the digital signature returned by your custom authentication service.
         * </p>
         * 
         * @param tokenSigningPublicKeys
         *        The public keys used to verify the digital signature returned by your custom authentication service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenSigningPublicKeys(Map<String, String> tokenSigningPublicKeys);

        /**
         * <p>
         * The status of the create authorizer request.
         * </p>
         * 
         * @param status
         *        The status of the create authorizer request.
         * @see AuthorizerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizerStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the create authorizer request.
         * </p>
         * 
         * @param status
         *        The status of the create authorizer request.
         * @see AuthorizerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizerStatus
         */
        Builder status(AuthorizerStatus status);

        /**
         * <p>
         * Metadata which can be used to manage the custom authorizer.
         * </p>
         * <note>
         * <p>
         * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         * </p>
         * <p>
         * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
         * </p>
         * <p>
         * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         * </p>
         * </note>
         * 
         * @param tags
         *        Metadata which can be used to manage the custom authorizer.</p> <note>
         *        <p>
         *        For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         *        </p>
         *        <p>
         *        For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
         *        </p>
         *        <p>
         *        For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Metadata which can be used to manage the custom authorizer.
         * </p>
         * <note>
         * <p>
         * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         * </p>
         * <p>
         * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
         * </p>
         * <p>
         * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         * </p>
         * </note>
         * 
         * @param tags
         *        Metadata which can be used to manage the custom authorizer.</p> <note>
         *        <p>
         *        For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         *        </p>
         *        <p>
         *        For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
         *        </p>
         *        <p>
         *        For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Metadata which can be used to manage the custom authorizer.
         * </p>
         * <note>
         * <p>
         * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         * </p>
         * <p>
         * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
         * </p>
         * <p>
         * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the
         * need to create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Specifies whether IoT validates the token signature in an authorization request.
         * </p>
         * 
         * @param signingDisabled
         *        Specifies whether IoT validates the token signature in an authorization request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingDisabled(Boolean signingDisabled);

        /**
         * <p>
         * When <code>true</code>, the result from the authorizer’s Lambda function is cached for clients that use
         * persistent HTTP connections. The results are cached for the time specified by the Lambda function in
         * <code>refreshAfterInSeconds</code>. This value does not affect authorization of clients that use MQTT
         * connections.
         * </p>
         * <p>
         * The default value is <code>false</code>.
         * </p>
         * 
         * @param enableCachingForHttp
         *        When <code>true</code>, the result from the authorizer’s Lambda function is cached for clients that
         *        use persistent HTTP connections. The results are cached for the time specified by the Lambda function
         *        in <code>refreshAfterInSeconds</code>. This value does not affect authorization of clients that use
         *        MQTT connections.</p>
         *        <p>
         *        The default value is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCachingForHttp(Boolean enableCachingForHttp);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String authorizerName;

        private String authorizerFunctionArn;

        private String tokenKeyName;

        private Map<String, String> tokenSigningPublicKeys = DefaultSdkAutoConstructMap.getInstance();

        private String status;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Boolean signingDisabled;

        private Boolean enableCachingForHttp;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAuthorizerRequest model) {
            super(model);
            authorizerName(model.authorizerName);
            authorizerFunctionArn(model.authorizerFunctionArn);
            tokenKeyName(model.tokenKeyName);
            tokenSigningPublicKeys(model.tokenSigningPublicKeys);
            status(model.status);
            tags(model.tags);
            signingDisabled(model.signingDisabled);
            enableCachingForHttp(model.enableCachingForHttp);
        }

        public final String getAuthorizerName() {
            return authorizerName;
        }

        public final void setAuthorizerName(String authorizerName) {
            this.authorizerName = authorizerName;
        }

        @Override
        @Transient
        public final Builder authorizerName(String authorizerName) {
            this.authorizerName = authorizerName;
            return this;
        }

        public final String getAuthorizerFunctionArn() {
            return authorizerFunctionArn;
        }

        public final void setAuthorizerFunctionArn(String authorizerFunctionArn) {
            this.authorizerFunctionArn = authorizerFunctionArn;
        }

        @Override
        @Transient
        public final Builder authorizerFunctionArn(String authorizerFunctionArn) {
            this.authorizerFunctionArn = authorizerFunctionArn;
            return this;
        }

        public final String getTokenKeyName() {
            return tokenKeyName;
        }

        public final void setTokenKeyName(String tokenKeyName) {
            this.tokenKeyName = tokenKeyName;
        }

        @Override
        @Transient
        public final Builder tokenKeyName(String tokenKeyName) {
            this.tokenKeyName = tokenKeyName;
            return this;
        }

        public final Map<String, String> getTokenSigningPublicKeys() {
            if (tokenSigningPublicKeys instanceof SdkAutoConstructMap) {
                return null;
            }
            return tokenSigningPublicKeys;
        }

        public final void setTokenSigningPublicKeys(Map<String, String> tokenSigningPublicKeys) {
            this.tokenSigningPublicKeys = PublicKeyMapCopier.copy(tokenSigningPublicKeys);
        }

        @Override
        @Transient
        public final Builder tokenSigningPublicKeys(Map<String, String> tokenSigningPublicKeys) {
            this.tokenSigningPublicKeys = PublicKeyMapCopier.copy(tokenSigningPublicKeys);
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(AuthorizerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getSigningDisabled() {
            return signingDisabled;
        }

        public final void setSigningDisabled(Boolean signingDisabled) {
            this.signingDisabled = signingDisabled;
        }

        @Override
        @Transient
        public final Builder signingDisabled(Boolean signingDisabled) {
            this.signingDisabled = signingDisabled;
            return this;
        }

        public final Boolean getEnableCachingForHttp() {
            return enableCachingForHttp;
        }

        public final void setEnableCachingForHttp(Boolean enableCachingForHttp) {
            this.enableCachingForHttp = enableCachingForHttp;
        }

        @Override
        @Transient
        public final Builder enableCachingForHttp(Boolean enableCachingForHttp) {
            this.enableCachingForHttp = enableCachingForHttp;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAuthorizerRequest build() {
            return new CreateAuthorizerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
