/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFleetMetricResponse extends IotResponse implements
        ToCopyableBuilder<DescribeFleetMetricResponse.Builder, DescribeFleetMetricResponse> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricName").getter(getter(DescribeFleetMetricResponse::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryString").getter(getter(DescribeFleetMetricResponse::queryString))
            .setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()).build();

    private static final SdkField<AggregationType> AGGREGATION_TYPE_FIELD = SdkField
            .<AggregationType> builder(MarshallingType.SDK_POJO).memberName("aggregationType")
            .getter(getter(DescribeFleetMetricResponse::aggregationType)).setter(setter(Builder::aggregationType))
            .constructor(AggregationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationType").build()).build();

    private static final SdkField<Integer> PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("period").getter(getter(DescribeFleetMetricResponse::period)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()).build();

    private static final SdkField<String> AGGREGATION_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aggregationField").getter(getter(DescribeFleetMetricResponse::aggregationField))
            .setter(setter(Builder::aggregationField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationField").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DescribeFleetMetricResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> QUERY_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryVersion").getter(getter(DescribeFleetMetricResponse::queryVersion))
            .setter(setter(Builder::queryVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryVersion").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexName").getter(getter(DescribeFleetMetricResponse::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(DescribeFleetMetricResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedDate").getter(getter(DescribeFleetMetricResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("unit")
            .getter(getter(DescribeFleetMetricResponse::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("version")
            .getter(getter(DescribeFleetMetricResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> METRIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricArn").getter(getter(DescribeFleetMetricResponse::metricArn)).setter(setter(Builder::metricArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD,
            QUERY_STRING_FIELD, AGGREGATION_TYPE_FIELD, PERIOD_FIELD, AGGREGATION_FIELD_FIELD, DESCRIPTION_FIELD,
            QUERY_VERSION_FIELD, INDEX_NAME_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD, UNIT_FIELD, VERSION_FIELD,
            METRIC_ARN_FIELD));

    private final String metricName;

    private final String queryString;

    private final AggregationType aggregationType;

    private final Integer period;

    private final String aggregationField;

    private final String description;

    private final String queryVersion;

    private final String indexName;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private final String unit;

    private final Long version;

    private final String metricArn;

    private DescribeFleetMetricResponse(BuilderImpl builder) {
        super(builder);
        this.metricName = builder.metricName;
        this.queryString = builder.queryString;
        this.aggregationType = builder.aggregationType;
        this.period = builder.period;
        this.aggregationField = builder.aggregationField;
        this.description = builder.description;
        this.queryVersion = builder.queryVersion;
        this.indexName = builder.indexName;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.unit = builder.unit;
        this.version = builder.version;
        this.metricArn = builder.metricArn;
    }

    /**
     * <p>
     * The name of the fleet metric to describe.
     * </p>
     * 
     * @return The name of the fleet metric to describe.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The search query string.
     * </p>
     * 
     * @return The search query string.
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * <p>
     * The type of the aggregation query.
     * </p>
     * 
     * @return The type of the aggregation query.
     */
    public final AggregationType aggregationType() {
        return aggregationType;
    }

    /**
     * <p>
     * The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1 day)] and must be multiple of 60.
     * </p>
     * 
     * @return The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1 day)] and must be multiple
     *         of 60.
     */
    public final Integer period() {
        return period;
    }

    /**
     * <p>
     * The field to aggregate.
     * </p>
     * 
     * @return The field to aggregate.
     */
    public final String aggregationField() {
        return aggregationField;
    }

    /**
     * <p>
     * The fleet metric description.
     * </p>
     * 
     * @return The fleet metric description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The query version.
     * </p>
     * 
     * @return The query version.
     */
    public final String queryVersion() {
        return queryVersion;
    }

    /**
     * <p>
     * The name of the index to search.
     * </p>
     * 
     * @return The name of the index to search.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The date when the fleet metric is created.
     * </p>
     * 
     * @return The date when the fleet metric is created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date when the fleet metric is last modified.
     * </p>
     * 
     * @return The date when the fleet metric is last modified.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a href=
     * "https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html"
     * >CW metric</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link FleetMetricUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a
     *         href=
     *         "https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html"
     *         >CW metric</a>.
     * @see FleetMetricUnit
     */
    public final FleetMetricUnit unit() {
        return FleetMetricUnit.fromValue(unit);
    }

    /**
     * <p>
     * Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a href=
     * "https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html"
     * >CW metric</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link FleetMetricUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a
     *         href=
     *         "https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html"
     *         >CW metric</a>.
     * @see FleetMetricUnit
     */
    public final String unitAsString() {
        return unit;
    }

    /**
     * <p>
     * The version of the fleet metric.
     * </p>
     * 
     * @return The version of the fleet metric.
     */
    public final Long version() {
        return version;
    }

    /**
     * <p>
     * The ARN of the fleet metric to describe.
     * </p>
     * 
     * @return The ARN of the fleet metric to describe.
     */
    public final String metricArn() {
        return metricArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationType());
        hashCode = 31 * hashCode + Objects.hashCode(period());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationField());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(queryVersion());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(metricArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetMetricResponse)) {
            return false;
        }
        DescribeFleetMetricResponse other = (DescribeFleetMetricResponse) obj;
        return Objects.equals(metricName(), other.metricName()) && Objects.equals(queryString(), other.queryString())
                && Objects.equals(aggregationType(), other.aggregationType()) && Objects.equals(period(), other.period())
                && Objects.equals(aggregationField(), other.aggregationField())
                && Objects.equals(description(), other.description()) && Objects.equals(queryVersion(), other.queryVersion())
                && Objects.equals(indexName(), other.indexName()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(unitAsString(), other.unitAsString()) && Objects.equals(version(), other.version())
                && Objects.equals(metricArn(), other.metricArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFleetMetricResponse").add("MetricName", metricName()).add("QueryString", queryString())
                .add("AggregationType", aggregationType()).add("Period", period()).add("AggregationField", aggregationField())
                .add("Description", description()).add("QueryVersion", queryVersion()).add("IndexName", indexName())
                .add("CreationDate", creationDate()).add("LastModifiedDate", lastModifiedDate()).add("Unit", unitAsString())
                .add("Version", version()).add("MetricArn", metricArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "queryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "aggregationType":
            return Optional.ofNullable(clazz.cast(aggregationType()));
        case "period":
            return Optional.ofNullable(clazz.cast(period()));
        case "aggregationField":
            return Optional.ofNullable(clazz.cast(aggregationField()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "queryVersion":
            return Optional.ofNullable(clazz.cast(queryVersion()));
        case "indexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "metricArn":
            return Optional.ofNullable(clazz.cast(metricArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetMetricResponse, T> g) {
        return obj -> g.apply((DescribeFleetMetricResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFleetMetricResponse> {
        /**
         * <p>
         * The name of the fleet metric to describe.
         * </p>
         * 
         * @param metricName
         *        The name of the fleet metric to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The search query string.
         * </p>
         * 
         * @param queryString
         *        The search query string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * The type of the aggregation query.
         * </p>
         * 
         * @param aggregationType
         *        The type of the aggregation query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationType(AggregationType aggregationType);

        /**
         * <p>
         * The type of the aggregation query.
         * </p>
         * This is a convenience method that creates an instance of the {@link AggregationType.Builder} avoiding the
         * need to create one manually via {@link AggregationType#builder()}.
         *
         * When the {@link Consumer} completes, {@link AggregationType.Builder#build()} is called immediately and its
         * result is passed to {@link #aggregationType(AggregationType)}.
         * 
         * @param aggregationType
         *        a consumer that will call methods on {@link AggregationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregationType(AggregationType)
         */
        default Builder aggregationType(Consumer<AggregationType.Builder> aggregationType) {
            return aggregationType(AggregationType.builder().applyMutation(aggregationType).build());
        }

        /**
         * <p>
         * The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1 day)] and must be multiple of
         * 60.
         * </p>
         * 
         * @param period
         *        The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1 day)] and must be
         *        multiple of 60.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);

        /**
         * <p>
         * The field to aggregate.
         * </p>
         * 
         * @param aggregationField
         *        The field to aggregate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationField(String aggregationField);

        /**
         * <p>
         * The fleet metric description.
         * </p>
         * 
         * @param description
         *        The fleet metric description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The query version.
         * </p>
         * 
         * @param queryVersion
         *        The query version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryVersion(String queryVersion);

        /**
         * <p>
         * The name of the index to search.
         * </p>
         * 
         * @param indexName
         *        The name of the index to search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The date when the fleet metric is created.
         * </p>
         * 
         * @param creationDate
         *        The date when the fleet metric is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date when the fleet metric is last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date when the fleet metric is last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a href=
         * "https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html"
         * >CW metric</a>.
         * </p>
         * 
         * @param unit
         *        Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a
         *        href=
         *        "https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html"
         *        >CW metric</a>.
         * @see FleetMetricUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetMetricUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a href=
         * "https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html"
         * >CW metric</a>.
         * </p>
         * 
         * @param unit
         *        Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a
         *        href=
         *        "https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html"
         *        >CW metric</a>.
         * @see FleetMetricUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetMetricUnit
         */
        Builder unit(FleetMetricUnit unit);

        /**
         * <p>
         * The version of the fleet metric.
         * </p>
         * 
         * @param version
         *        The version of the fleet metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);

        /**
         * <p>
         * The ARN of the fleet metric to describe.
         * </p>
         * 
         * @param metricArn
         *        The ARN of the fleet metric to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricArn(String metricArn);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String metricName;

        private String queryString;

        private AggregationType aggregationType;

        private Integer period;

        private String aggregationField;

        private String description;

        private String queryVersion;

        private String indexName;

        private Instant creationDate;

        private Instant lastModifiedDate;

        private String unit;

        private Long version;

        private String metricArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetMetricResponse model) {
            super(model);
            metricName(model.metricName);
            queryString(model.queryString);
            aggregationType(model.aggregationType);
            period(model.period);
            aggregationField(model.aggregationField);
            description(model.description);
            queryVersion(model.queryVersion);
            indexName(model.indexName);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
            unit(model.unit);
            version(model.version);
            metricArn(model.metricArn);
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        @Transient
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        @Transient
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final AggregationType.Builder getAggregationType() {
            return aggregationType != null ? aggregationType.toBuilder() : null;
        }

        public final void setAggregationType(AggregationType.BuilderImpl aggregationType) {
            this.aggregationType = aggregationType != null ? aggregationType.build() : null;
        }

        @Override
        @Transient
        public final Builder aggregationType(AggregationType aggregationType) {
            this.aggregationType = aggregationType;
            return this;
        }

        public final Integer getPeriod() {
            return period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        @Transient
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final String getAggregationField() {
            return aggregationField;
        }

        public final void setAggregationField(String aggregationField) {
            this.aggregationField = aggregationField;
        }

        @Override
        @Transient
        public final Builder aggregationField(String aggregationField) {
            this.aggregationField = aggregationField;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getQueryVersion() {
            return queryVersion;
        }

        public final void setQueryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
        }

        @Override
        @Transient
        public final Builder queryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
            return this;
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        @Transient
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        @Transient
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        @Transient
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        @Transient
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        @Transient
        public final Builder unit(FleetMetricUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final Long getVersion() {
            return version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final String getMetricArn() {
            return metricArn;
        }

        public final void setMetricArn(String metricArn) {
            this.metricArn = metricArn;
        }

        @Override
        @Transient
        public final Builder metricArn(String metricArn) {
            this.metricArn = metricArn;
            return this;
        }

        @Override
        public DescribeFleetMetricResponse build() {
            return new DescribeFleetMetricResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
