/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSecurityProfileResponse extends IotResponse implements
        ToCopyableBuilder<DescribeSecurityProfileResponse.Builder, DescribeSecurityProfileResponse> {
    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("securityProfileName").getter(getter(DescribeSecurityProfileResponse::securityProfileName))
            .setter(setter(Builder::securityProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileName").build())
            .build();

    private static final SdkField<String> SECURITY_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("securityProfileArn").getter(getter(DescribeSecurityProfileResponse::securityProfileArn))
            .setter(setter(Builder::securityProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileArn").build())
            .build();

    private static final SdkField<String> SECURITY_PROFILE_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("securityProfileDescription")
            .getter(getter(DescribeSecurityProfileResponse::securityProfileDescription))
            .setter(setter(Builder::securityProfileDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileDescription").build())
            .build();

    private static final SdkField<List<Behavior>> BEHAVIORS_FIELD = SdkField
            .<List<Behavior>> builder(MarshallingType.LIST)
            .memberName("behaviors")
            .getter(getter(DescribeSecurityProfileResponse::behaviors))
            .setter(setter(Builder::behaviors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behaviors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Behavior> builder(MarshallingType.SDK_POJO)
                                            .constructor(Behavior::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, AlertTarget>> ALERT_TARGETS_FIELD = SdkField
            .<Map<String, AlertTarget>> builder(MarshallingType.MAP)
            .memberName("alertTargets")
            .getter(getter(DescribeSecurityProfileResponse::alertTargetsAsStrings))
            .setter(setter(Builder::alertTargetsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alertTargets").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AlertTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(AlertTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> ADDITIONAL_METRICS_TO_RETAIN_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("additionalMetricsToRetain")
            .getter(getter(DescribeSecurityProfileResponse::additionalMetricsToRetain))
            .setter(setter(Builder::additionalMetricsToRetain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalMetricsToRetain").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MetricToRetain>> ADDITIONAL_METRICS_TO_RETAIN_V2_FIELD = SdkField
            .<List<MetricToRetain>> builder(MarshallingType.LIST)
            .memberName("additionalMetricsToRetainV2")
            .getter(getter(DescribeSecurityProfileResponse::additionalMetricsToRetainV2))
            .setter(setter(Builder::additionalMetricsToRetainV2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalMetricsToRetainV2")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricToRetain> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricToRetain::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("version")
            .getter(getter(DescribeSecurityProfileResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(DescribeSecurityProfileResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedDate").getter(getter(DescribeSecurityProfileResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_PROFILE_NAME_FIELD,
            SECURITY_PROFILE_ARN_FIELD, SECURITY_PROFILE_DESCRIPTION_FIELD, BEHAVIORS_FIELD, ALERT_TARGETS_FIELD,
            ADDITIONAL_METRICS_TO_RETAIN_FIELD, ADDITIONAL_METRICS_TO_RETAIN_V2_FIELD, VERSION_FIELD, CREATION_DATE_FIELD,
            LAST_MODIFIED_DATE_FIELD));

    private final String securityProfileName;

    private final String securityProfileArn;

    private final String securityProfileDescription;

    private final List<Behavior> behaviors;

    private final Map<String, AlertTarget> alertTargets;

    private final List<String> additionalMetricsToRetain;

    private final List<MetricToRetain> additionalMetricsToRetainV2;

    private final Long version;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private DescribeSecurityProfileResponse(BuilderImpl builder) {
        super(builder);
        this.securityProfileName = builder.securityProfileName;
        this.securityProfileArn = builder.securityProfileArn;
        this.securityProfileDescription = builder.securityProfileDescription;
        this.behaviors = builder.behaviors;
        this.alertTargets = builder.alertTargets;
        this.additionalMetricsToRetain = builder.additionalMetricsToRetain;
        this.additionalMetricsToRetainV2 = builder.additionalMetricsToRetainV2;
        this.version = builder.version;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * The name of the security profile.
     * </p>
     * 
     * @return The name of the security profile.
     */
    public final String securityProfileName() {
        return securityProfileName;
    }

    /**
     * <p>
     * The ARN of the security profile.
     * </p>
     * 
     * @return The ARN of the security profile.
     */
    public final String securityProfileArn() {
        return securityProfileArn;
    }

    /**
     * <p>
     * A description of the security profile (associated with the security profile when it was created or updated).
     * </p>
     * 
     * @return A description of the security profile (associated with the security profile when it was created or
     *         updated).
     */
    public final String securityProfileDescription() {
        return securityProfileDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the Behaviors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBehaviors() {
        return behaviors != null && !(behaviors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the behaviors that, when violated by a device (thing), cause an alert.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBehaviors} method.
     * </p>
     * 
     * @return Specifies the behaviors that, when violated by a device (thing), cause an alert.
     */
    public final List<Behavior> behaviors() {
        return behaviors;
    }

    /**
     * <p>
     * Where the alerts are sent. (Alerts are always sent to the console.)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlertTargets} method.
     * </p>
     * 
     * @return Where the alerts are sent. (Alerts are always sent to the console.)
     */
    public final Map<AlertTargetType, AlertTarget> alertTargets() {
        return AlertTargetsCopier.copyStringToEnum(alertTargets);
    }

    /**
     * For responses, this returns true if the service returned a value for the AlertTargets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAlertTargets() {
        return alertTargets != null && !(alertTargets instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Where the alerts are sent. (Alerts are always sent to the console.)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlertTargets} method.
     * </p>
     * 
     * @return Where the alerts are sent. (Alerts are always sent to the console.)
     */
    public final Map<String, AlertTarget> alertTargetsAsStrings() {
        return alertTargets;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalMetricsToRetain property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     *
     * @deprecated Use additionalMetricsToRetainV2.
     */
    @Deprecated
    public final boolean hasAdditionalMetricsToRetain() {
        return additionalMetricsToRetain != null && !(additionalMetricsToRetain instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * <i>Please use <a>DescribeSecurityProfileResponse$additionalMetricsToRetainV2</a> instead.</i>
     * </p>
     * <p>
     * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the
     * profile's <code>behaviors</code>, but it is also retained for any metric specified here.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalMetricsToRetain} method.
     * </p>
     * 
     * @return <i>Please use <a>DescribeSecurityProfileResponse$additionalMetricsToRetainV2</a> instead.</i> </p>
     *         <p>
     *         A list of metrics whose data is retained (stored). By default, data is retained for any metric used in
     *         the profile's <code>behaviors</code>, but it is also retained for any metric specified here.
     * @deprecated Use additionalMetricsToRetainV2.
     */
    @Deprecated
    public final List<String> additionalMetricsToRetain() {
        return additionalMetricsToRetain;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalMetricsToRetainV2 property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalMetricsToRetainV2() {
        return additionalMetricsToRetainV2 != null && !(additionalMetricsToRetainV2 instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the
     * profile's behaviors, but it is also retained for any metric specified here.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalMetricsToRetainV2} method.
     * </p>
     * 
     * @return A list of metrics whose data is retained (stored). By default, data is retained for any metric used in
     *         the profile's behaviors, but it is also retained for any metric specified here.
     */
    public final List<MetricToRetain> additionalMetricsToRetainV2() {
        return additionalMetricsToRetainV2;
    }

    /**
     * <p>
     * The version of the security profile. A new version is generated whenever the security profile is updated.
     * </p>
     * 
     * @return The version of the security profile. A new version is generated whenever the security profile is updated.
     */
    public final Long version() {
        return version;
    }

    /**
     * <p>
     * The time the security profile was created.
     * </p>
     * 
     * @return The time the security profile was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The time the security profile was last modified.
     * </p>
     * 
     * @return The time the security profile was last modified.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasBehaviors() ? behaviors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAlertTargets() ? alertTargetsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalMetricsToRetain() ? additionalMetricsToRetain() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalMetricsToRetainV2() ? additionalMetricsToRetainV2() : null);
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityProfileResponse)) {
            return false;
        }
        DescribeSecurityProfileResponse other = (DescribeSecurityProfileResponse) obj;
        return Objects.equals(securityProfileName(), other.securityProfileName())
                && Objects.equals(securityProfileArn(), other.securityProfileArn())
                && Objects.equals(securityProfileDescription(), other.securityProfileDescription())
                && hasBehaviors() == other.hasBehaviors() && Objects.equals(behaviors(), other.behaviors())
                && hasAlertTargets() == other.hasAlertTargets()
                && Objects.equals(alertTargetsAsStrings(), other.alertTargetsAsStrings())
                && hasAdditionalMetricsToRetain() == other.hasAdditionalMetricsToRetain()
                && Objects.equals(additionalMetricsToRetain(), other.additionalMetricsToRetain())
                && hasAdditionalMetricsToRetainV2() == other.hasAdditionalMetricsToRetainV2()
                && Objects.equals(additionalMetricsToRetainV2(), other.additionalMetricsToRetainV2())
                && Objects.equals(version(), other.version()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSecurityProfileResponse").add("SecurityProfileName", securityProfileName())
                .add("SecurityProfileArn", securityProfileArn()).add("SecurityProfileDescription", securityProfileDescription())
                .add("Behaviors", hasBehaviors() ? behaviors() : null)
                .add("AlertTargets", hasAlertTargets() ? alertTargetsAsStrings() : null)
                .add("AdditionalMetricsToRetain", hasAdditionalMetricsToRetain() ? additionalMetricsToRetain() : null)
                .add("AdditionalMetricsToRetainV2", hasAdditionalMetricsToRetainV2() ? additionalMetricsToRetainV2() : null)
                .add("Version", version()).add("CreationDate", creationDate()).add("LastModifiedDate", lastModifiedDate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "securityProfileName":
            return Optional.ofNullable(clazz.cast(securityProfileName()));
        case "securityProfileArn":
            return Optional.ofNullable(clazz.cast(securityProfileArn()));
        case "securityProfileDescription":
            return Optional.ofNullable(clazz.cast(securityProfileDescription()));
        case "behaviors":
            return Optional.ofNullable(clazz.cast(behaviors()));
        case "alertTargets":
            return Optional.ofNullable(clazz.cast(alertTargetsAsStrings()));
        case "additionalMetricsToRetain":
            return Optional.ofNullable(clazz.cast(additionalMetricsToRetain()));
        case "additionalMetricsToRetainV2":
            return Optional.ofNullable(clazz.cast(additionalMetricsToRetainV2()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSecurityProfileResponse, T> g) {
        return obj -> g.apply((DescribeSecurityProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSecurityProfileResponse> {
        /**
         * <p>
         * The name of the security profile.
         * </p>
         * 
         * @param securityProfileName
         *        The name of the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileName(String securityProfileName);

        /**
         * <p>
         * The ARN of the security profile.
         * </p>
         * 
         * @param securityProfileArn
         *        The ARN of the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileArn(String securityProfileArn);

        /**
         * <p>
         * A description of the security profile (associated with the security profile when it was created or updated).
         * </p>
         * 
         * @param securityProfileDescription
         *        A description of the security profile (associated with the security profile when it was created or
         *        updated).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileDescription(String securityProfileDescription);

        /**
         * <p>
         * Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * </p>
         * 
         * @param behaviors
         *        Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder behaviors(Collection<Behavior> behaviors);

        /**
         * <p>
         * Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * </p>
         * 
         * @param behaviors
         *        Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder behaviors(Behavior... behaviors);

        /**
         * <p>
         * Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Behavior>.Builder} avoiding the need
         * to create one manually via {@link List<Behavior>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Behavior>.Builder#build()} is called immediately and its
         * result is passed to {@link #behaviors(List<Behavior>)}.
         * 
         * @param behaviors
         *        a consumer that will call methods on {@link List<Behavior>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #behaviors(List<Behavior>)
         */
        Builder behaviors(Consumer<Behavior.Builder>... behaviors);

        /**
         * <p>
         * Where the alerts are sent. (Alerts are always sent to the console.)
         * </p>
         * 
         * @param alertTargets
         *        Where the alerts are sent. (Alerts are always sent to the console.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertTargetsWithStrings(Map<String, AlertTarget> alertTargets);

        /**
         * <p>
         * Where the alerts are sent. (Alerts are always sent to the console.)
         * </p>
         * 
         * @param alertTargets
         *        Where the alerts are sent. (Alerts are always sent to the console.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertTargets(Map<AlertTargetType, AlertTarget> alertTargets);

        /**
         * <p>
         * <i>Please use <a>DescribeSecurityProfileResponse$additionalMetricsToRetainV2</a> instead.</i>
         * </p>
         * <p>
         * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the
         * profile's <code>behaviors</code>, but it is also retained for any metric specified here.
         * </p>
         * 
         * @param additionalMetricsToRetain
         *        <i>Please use <a>DescribeSecurityProfileResponse$additionalMetricsToRetainV2</a> instead.</i> </p>
         *        <p>
         *        A list of metrics whose data is retained (stored). By default, data is retained for any metric used in
         *        the profile's <code>behaviors</code>, but it is also retained for any metric specified here.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Use additionalMetricsToRetainV2.
         */
        @Deprecated
        Builder additionalMetricsToRetain(Collection<String> additionalMetricsToRetain);

        /**
         * <p>
         * <i>Please use <a>DescribeSecurityProfileResponse$additionalMetricsToRetainV2</a> instead.</i>
         * </p>
         * <p>
         * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the
         * profile's <code>behaviors</code>, but it is also retained for any metric specified here.
         * </p>
         * 
         * @param additionalMetricsToRetain
         *        <i>Please use <a>DescribeSecurityProfileResponse$additionalMetricsToRetainV2</a> instead.</i> </p>
         *        <p>
         *        A list of metrics whose data is retained (stored). By default, data is retained for any metric used in
         *        the profile's <code>behaviors</code>, but it is also retained for any metric specified here.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Use additionalMetricsToRetainV2.
         */
        @Deprecated
        Builder additionalMetricsToRetain(String... additionalMetricsToRetain);

        /**
         * <p>
         * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the
         * profile's behaviors, but it is also retained for any metric specified here.
         * </p>
         * 
         * @param additionalMetricsToRetainV2
         *        A list of metrics whose data is retained (stored). By default, data is retained for any metric used in
         *        the profile's behaviors, but it is also retained for any metric specified here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalMetricsToRetainV2(Collection<MetricToRetain> additionalMetricsToRetainV2);

        /**
         * <p>
         * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the
         * profile's behaviors, but it is also retained for any metric specified here.
         * </p>
         * 
         * @param additionalMetricsToRetainV2
         *        A list of metrics whose data is retained (stored). By default, data is retained for any metric used in
         *        the profile's behaviors, but it is also retained for any metric specified here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalMetricsToRetainV2(MetricToRetain... additionalMetricsToRetainV2);

        /**
         * <p>
         * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the
         * profile's behaviors, but it is also retained for any metric specified here.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<MetricToRetain>.Builder} avoiding
         * the need to create one manually via {@link List<MetricToRetain>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricToRetain>.Builder#build()} is called immediately and
         * its result is passed to {@link #additionalMetricsToRetainV2(List<MetricToRetain>)}.
         * 
         * @param additionalMetricsToRetainV2
         *        a consumer that will call methods on {@link List<MetricToRetain>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalMetricsToRetainV2(List<MetricToRetain>)
         */
        Builder additionalMetricsToRetainV2(Consumer<MetricToRetain.Builder>... additionalMetricsToRetainV2);

        /**
         * <p>
         * The version of the security profile. A new version is generated whenever the security profile is updated.
         * </p>
         * 
         * @param version
         *        The version of the security profile. A new version is generated whenever the security profile is
         *        updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);

        /**
         * <p>
         * The time the security profile was created.
         * </p>
         * 
         * @param creationDate
         *        The time the security profile was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The time the security profile was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The time the security profile was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String securityProfileName;

        private String securityProfileArn;

        private String securityProfileDescription;

        private List<Behavior> behaviors = DefaultSdkAutoConstructList.getInstance();

        private Map<String, AlertTarget> alertTargets = DefaultSdkAutoConstructMap.getInstance();

        private List<String> additionalMetricsToRetain = DefaultSdkAutoConstructList.getInstance();

        private List<MetricToRetain> additionalMetricsToRetainV2 = DefaultSdkAutoConstructList.getInstance();

        private Long version;

        private Instant creationDate;

        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecurityProfileResponse model) {
            super(model);
            securityProfileName(model.securityProfileName);
            securityProfileArn(model.securityProfileArn);
            securityProfileDescription(model.securityProfileDescription);
            behaviors(model.behaviors);
            alertTargetsWithStrings(model.alertTargets);
            additionalMetricsToRetain(model.additionalMetricsToRetain);
            additionalMetricsToRetainV2(model.additionalMetricsToRetainV2);
            version(model.version);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final String getSecurityProfileName() {
            return securityProfileName;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        @Override
        @Transient
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final String getSecurityProfileArn() {
            return securityProfileArn;
        }

        public final void setSecurityProfileArn(String securityProfileArn) {
            this.securityProfileArn = securityProfileArn;
        }

        @Override
        @Transient
        public final Builder securityProfileArn(String securityProfileArn) {
            this.securityProfileArn = securityProfileArn;
            return this;
        }

        public final String getSecurityProfileDescription() {
            return securityProfileDescription;
        }

        public final void setSecurityProfileDescription(String securityProfileDescription) {
            this.securityProfileDescription = securityProfileDescription;
        }

        @Override
        @Transient
        public final Builder securityProfileDescription(String securityProfileDescription) {
            this.securityProfileDescription = securityProfileDescription;
            return this;
        }

        public final List<Behavior.Builder> getBehaviors() {
            List<Behavior.Builder> result = BehaviorsCopier.copyToBuilder(this.behaviors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBehaviors(Collection<Behavior.BuilderImpl> behaviors) {
            this.behaviors = BehaviorsCopier.copyFromBuilder(behaviors);
        }

        @Override
        @Transient
        public final Builder behaviors(Collection<Behavior> behaviors) {
            this.behaviors = BehaviorsCopier.copy(behaviors);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder behaviors(Behavior... behaviors) {
            behaviors(Arrays.asList(behaviors));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder behaviors(Consumer<Behavior.Builder>... behaviors) {
            behaviors(Stream.of(behaviors).map(c -> Behavior.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, AlertTarget.Builder> getAlertTargets() {
            Map<String, AlertTarget.Builder> result = AlertTargetsCopier.copyToBuilder(this.alertTargets);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAlertTargets(Map<String, AlertTarget.BuilderImpl> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copyFromBuilder(alertTargets);
        }

        @Override
        @Transient
        public final Builder alertTargetsWithStrings(Map<String, AlertTarget> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copy(alertTargets);
            return this;
        }

        @Override
        @Transient
        public final Builder alertTargets(Map<AlertTargetType, AlertTarget> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copyEnumToString(alertTargets);
            return this;
        }

        @Deprecated
        public final Collection<String> getAdditionalMetricsToRetain() {
            if (additionalMetricsToRetain instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalMetricsToRetain;
        }

        @Deprecated
        public final void setAdditionalMetricsToRetain(Collection<String> additionalMetricsToRetain) {
            this.additionalMetricsToRetain = AdditionalMetricsToRetainListCopier.copy(additionalMetricsToRetain);
        }

        @Override
        @Transient
        @Deprecated
        public final Builder additionalMetricsToRetain(Collection<String> additionalMetricsToRetain) {
            this.additionalMetricsToRetain = AdditionalMetricsToRetainListCopier.copy(additionalMetricsToRetain);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        @Deprecated
        public final Builder additionalMetricsToRetain(String... additionalMetricsToRetain) {
            additionalMetricsToRetain(Arrays.asList(additionalMetricsToRetain));
            return this;
        }

        public final List<MetricToRetain.Builder> getAdditionalMetricsToRetainV2() {
            List<MetricToRetain.Builder> result = AdditionalMetricsToRetainV2ListCopier
                    .copyToBuilder(this.additionalMetricsToRetainV2);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalMetricsToRetainV2(Collection<MetricToRetain.BuilderImpl> additionalMetricsToRetainV2) {
            this.additionalMetricsToRetainV2 = AdditionalMetricsToRetainV2ListCopier.copyFromBuilder(additionalMetricsToRetainV2);
        }

        @Override
        @Transient
        public final Builder additionalMetricsToRetainV2(Collection<MetricToRetain> additionalMetricsToRetainV2) {
            this.additionalMetricsToRetainV2 = AdditionalMetricsToRetainV2ListCopier.copy(additionalMetricsToRetainV2);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder additionalMetricsToRetainV2(MetricToRetain... additionalMetricsToRetainV2) {
            additionalMetricsToRetainV2(Arrays.asList(additionalMetricsToRetainV2));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder additionalMetricsToRetainV2(Consumer<MetricToRetain.Builder>... additionalMetricsToRetainV2) {
            additionalMetricsToRetainV2(Stream.of(additionalMetricsToRetainV2)
                    .map(c -> MetricToRetain.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getVersion() {
            return version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        @Transient
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        @Transient
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        @Override
        public DescribeSecurityProfileResponse build() {
            return new DescribeSecurityProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
