/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the DescribeThingType operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeThingTypeResponse extends IotResponse implements
        ToCopyableBuilder<DescribeThingTypeResponse.Builder, DescribeThingTypeResponse> {
    private static final SdkField<String> THING_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingTypeName").getter(getter(DescribeThingTypeResponse::thingTypeName))
            .setter(setter(Builder::thingTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeName").build()).build();

    private static final SdkField<String> THING_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingTypeId").getter(getter(DescribeThingTypeResponse::thingTypeId))
            .setter(setter(Builder::thingTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeId").build()).build();

    private static final SdkField<String> THING_TYPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingTypeArn").getter(getter(DescribeThingTypeResponse::thingTypeArn))
            .setter(setter(Builder::thingTypeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeArn").build()).build();

    private static final SdkField<ThingTypeProperties> THING_TYPE_PROPERTIES_FIELD = SdkField
            .<ThingTypeProperties> builder(MarshallingType.SDK_POJO).memberName("thingTypeProperties")
            .getter(getter(DescribeThingTypeResponse::thingTypeProperties)).setter(setter(Builder::thingTypeProperties))
            .constructor(ThingTypeProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeProperties").build())
            .build();

    private static final SdkField<ThingTypeMetadata> THING_TYPE_METADATA_FIELD = SdkField
            .<ThingTypeMetadata> builder(MarshallingType.SDK_POJO).memberName("thingTypeMetadata")
            .getter(getter(DescribeThingTypeResponse::thingTypeMetadata)).setter(setter(Builder::thingTypeMetadata))
            .constructor(ThingTypeMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_TYPE_NAME_FIELD,
            THING_TYPE_ID_FIELD, THING_TYPE_ARN_FIELD, THING_TYPE_PROPERTIES_FIELD, THING_TYPE_METADATA_FIELD));

    private final String thingTypeName;

    private final String thingTypeId;

    private final String thingTypeArn;

    private final ThingTypeProperties thingTypeProperties;

    private final ThingTypeMetadata thingTypeMetadata;

    private DescribeThingTypeResponse(BuilderImpl builder) {
        super(builder);
        this.thingTypeName = builder.thingTypeName;
        this.thingTypeId = builder.thingTypeId;
        this.thingTypeArn = builder.thingTypeArn;
        this.thingTypeProperties = builder.thingTypeProperties;
        this.thingTypeMetadata = builder.thingTypeMetadata;
    }

    /**
     * <p>
     * The name of the thing type.
     * </p>
     * 
     * @return The name of the thing type.
     */
    public final String thingTypeName() {
        return thingTypeName;
    }

    /**
     * <p>
     * The thing type ID.
     * </p>
     * 
     * @return The thing type ID.
     */
    public final String thingTypeId() {
        return thingTypeId;
    }

    /**
     * <p>
     * The thing type ARN.
     * </p>
     * 
     * @return The thing type ARN.
     */
    public final String thingTypeArn() {
        return thingTypeArn;
    }

    /**
     * <p>
     * The ThingTypeProperties contains information about the thing type including description, and a list of searchable
     * thing attribute names.
     * </p>
     * 
     * @return The ThingTypeProperties contains information about the thing type including description, and a list of
     *         searchable thing attribute names.
     */
    public final ThingTypeProperties thingTypeProperties() {
        return thingTypeProperties;
    }

    /**
     * <p>
     * The ThingTypeMetadata contains additional information about the thing type including: creation date and time, a
     * value indicating whether the thing type is deprecated, and a date and time when it was deprecated.
     * </p>
     * 
     * @return The ThingTypeMetadata contains additional information about the thing type including: creation date and
     *         time, a value indicating whether the thing type is deprecated, and a date and time when it was
     *         deprecated.
     */
    public final ThingTypeMetadata thingTypeMetadata() {
        return thingTypeMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeArn());
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeProperties());
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeThingTypeResponse)) {
            return false;
        }
        DescribeThingTypeResponse other = (DescribeThingTypeResponse) obj;
        return Objects.equals(thingTypeName(), other.thingTypeName()) && Objects.equals(thingTypeId(), other.thingTypeId())
                && Objects.equals(thingTypeArn(), other.thingTypeArn())
                && Objects.equals(thingTypeProperties(), other.thingTypeProperties())
                && Objects.equals(thingTypeMetadata(), other.thingTypeMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeThingTypeResponse").add("ThingTypeName", thingTypeName())
                .add("ThingTypeId", thingTypeId()).add("ThingTypeArn", thingTypeArn())
                .add("ThingTypeProperties", thingTypeProperties()).add("ThingTypeMetadata", thingTypeMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingTypeName":
            return Optional.ofNullable(clazz.cast(thingTypeName()));
        case "thingTypeId":
            return Optional.ofNullable(clazz.cast(thingTypeId()));
        case "thingTypeArn":
            return Optional.ofNullable(clazz.cast(thingTypeArn()));
        case "thingTypeProperties":
            return Optional.ofNullable(clazz.cast(thingTypeProperties()));
        case "thingTypeMetadata":
            return Optional.ofNullable(clazz.cast(thingTypeMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeThingTypeResponse, T> g) {
        return obj -> g.apply((DescribeThingTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeThingTypeResponse> {
        /**
         * <p>
         * The name of the thing type.
         * </p>
         * 
         * @param thingTypeName
         *        The name of the thing type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeName(String thingTypeName);

        /**
         * <p>
         * The thing type ID.
         * </p>
         * 
         * @param thingTypeId
         *        The thing type ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeId(String thingTypeId);

        /**
         * <p>
         * The thing type ARN.
         * </p>
         * 
         * @param thingTypeArn
         *        The thing type ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeArn(String thingTypeArn);

        /**
         * <p>
         * The ThingTypeProperties contains information about the thing type including description, and a list of
         * searchable thing attribute names.
         * </p>
         * 
         * @param thingTypeProperties
         *        The ThingTypeProperties contains information about the thing type including description, and a list of
         *        searchable thing attribute names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeProperties(ThingTypeProperties thingTypeProperties);

        /**
         * <p>
         * The ThingTypeProperties contains information about the thing type including description, and a list of
         * searchable thing attribute names.
         * </p>
         * This is a convenience method that creates an instance of the {@link ThingTypeProperties.Builder} avoiding the
         * need to create one manually via {@link ThingTypeProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThingTypeProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #thingTypeProperties(ThingTypeProperties)}.
         * 
         * @param thingTypeProperties
         *        a consumer that will call methods on {@link ThingTypeProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thingTypeProperties(ThingTypeProperties)
         */
        default Builder thingTypeProperties(Consumer<ThingTypeProperties.Builder> thingTypeProperties) {
            return thingTypeProperties(ThingTypeProperties.builder().applyMutation(thingTypeProperties).build());
        }

        /**
         * <p>
         * The ThingTypeMetadata contains additional information about the thing type including: creation date and time,
         * a value indicating whether the thing type is deprecated, and a date and time when it was deprecated.
         * </p>
         * 
         * @param thingTypeMetadata
         *        The ThingTypeMetadata contains additional information about the thing type including: creation date
         *        and time, a value indicating whether the thing type is deprecated, and a date and time when it was
         *        deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeMetadata(ThingTypeMetadata thingTypeMetadata);

        /**
         * <p>
         * The ThingTypeMetadata contains additional information about the thing type including: creation date and time,
         * a value indicating whether the thing type is deprecated, and a date and time when it was deprecated.
         * </p>
         * This is a convenience method that creates an instance of the {@link ThingTypeMetadata.Builder} avoiding the
         * need to create one manually via {@link ThingTypeMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThingTypeMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #thingTypeMetadata(ThingTypeMetadata)}.
         * 
         * @param thingTypeMetadata
         *        a consumer that will call methods on {@link ThingTypeMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thingTypeMetadata(ThingTypeMetadata)
         */
        default Builder thingTypeMetadata(Consumer<ThingTypeMetadata.Builder> thingTypeMetadata) {
            return thingTypeMetadata(ThingTypeMetadata.builder().applyMutation(thingTypeMetadata).build());
        }
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String thingTypeName;

        private String thingTypeId;

        private String thingTypeArn;

        private ThingTypeProperties thingTypeProperties;

        private ThingTypeMetadata thingTypeMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeThingTypeResponse model) {
            super(model);
            thingTypeName(model.thingTypeName);
            thingTypeId(model.thingTypeId);
            thingTypeArn(model.thingTypeArn);
            thingTypeProperties(model.thingTypeProperties);
            thingTypeMetadata(model.thingTypeMetadata);
        }

        public final String getThingTypeName() {
            return thingTypeName;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        @Override
        @Transient
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final String getThingTypeId() {
            return thingTypeId;
        }

        public final void setThingTypeId(String thingTypeId) {
            this.thingTypeId = thingTypeId;
        }

        @Override
        @Transient
        public final Builder thingTypeId(String thingTypeId) {
            this.thingTypeId = thingTypeId;
            return this;
        }

        public final String getThingTypeArn() {
            return thingTypeArn;
        }

        public final void setThingTypeArn(String thingTypeArn) {
            this.thingTypeArn = thingTypeArn;
        }

        @Override
        @Transient
        public final Builder thingTypeArn(String thingTypeArn) {
            this.thingTypeArn = thingTypeArn;
            return this;
        }

        public final ThingTypeProperties.Builder getThingTypeProperties() {
            return thingTypeProperties != null ? thingTypeProperties.toBuilder() : null;
        }

        public final void setThingTypeProperties(ThingTypeProperties.BuilderImpl thingTypeProperties) {
            this.thingTypeProperties = thingTypeProperties != null ? thingTypeProperties.build() : null;
        }

        @Override
        @Transient
        public final Builder thingTypeProperties(ThingTypeProperties thingTypeProperties) {
            this.thingTypeProperties = thingTypeProperties;
            return this;
        }

        public final ThingTypeMetadata.Builder getThingTypeMetadata() {
            return thingTypeMetadata != null ? thingTypeMetadata.toBuilder() : null;
        }

        public final void setThingTypeMetadata(ThingTypeMetadata.BuilderImpl thingTypeMetadata) {
            this.thingTypeMetadata = thingTypeMetadata != null ? thingTypeMetadata.build() : null;
        }

        @Override
        @Transient
        public final Builder thingTypeMetadata(ThingTypeMetadata thingTypeMetadata) {
            this.thingTypeMetadata = thingTypeMetadata;
            return this;
        }

        @Override
        public DescribeThingTypeResponse build() {
            return new DescribeThingTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
