/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEffectivePoliciesResponse extends IotResponse implements
        ToCopyableBuilder<GetEffectivePoliciesResponse.Builder, GetEffectivePoliciesResponse> {
    private static final SdkField<List<EffectivePolicy>> EFFECTIVE_POLICIES_FIELD = SdkField
            .<List<EffectivePolicy>> builder(MarshallingType.LIST)
            .memberName("effectivePolicies")
            .getter(getter(GetEffectivePoliciesResponse::effectivePolicies))
            .setter(setter(Builder::effectivePolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectivePolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EffectivePolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(EffectivePolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EFFECTIVE_POLICIES_FIELD));

    private final List<EffectivePolicy> effectivePolicies;

    private GetEffectivePoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.effectivePolicies = builder.effectivePolicies;
    }

    /**
     * For responses, this returns true if the service returned a value for the EffectivePolicies property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEffectivePolicies() {
        return effectivePolicies != null && !(effectivePolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The effective policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEffectivePolicies} method.
     * </p>
     * 
     * @return The effective policies.
     */
    public final List<EffectivePolicy> effectivePolicies() {
        return effectivePolicies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEffectivePolicies() ? effectivePolicies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEffectivePoliciesResponse)) {
            return false;
        }
        GetEffectivePoliciesResponse other = (GetEffectivePoliciesResponse) obj;
        return hasEffectivePolicies() == other.hasEffectivePolicies()
                && Objects.equals(effectivePolicies(), other.effectivePolicies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEffectivePoliciesResponse")
                .add("EffectivePolicies", hasEffectivePolicies() ? effectivePolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "effectivePolicies":
            return Optional.ofNullable(clazz.cast(effectivePolicies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEffectivePoliciesResponse, T> g) {
        return obj -> g.apply((GetEffectivePoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetEffectivePoliciesResponse> {
        /**
         * <p>
         * The effective policies.
         * </p>
         * 
         * @param effectivePolicies
         *        The effective policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectivePolicies(Collection<EffectivePolicy> effectivePolicies);

        /**
         * <p>
         * The effective policies.
         * </p>
         * 
         * @param effectivePolicies
         *        The effective policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectivePolicies(EffectivePolicy... effectivePolicies);

        /**
         * <p>
         * The effective policies.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<EffectivePolicy>.Builder} avoiding
         * the need to create one manually via {@link List<EffectivePolicy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EffectivePolicy>.Builder#build()} is called immediately and
         * its result is passed to {@link #effectivePolicies(List<EffectivePolicy>)}.
         * 
         * @param effectivePolicies
         *        a consumer that will call methods on {@link List<EffectivePolicy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #effectivePolicies(List<EffectivePolicy>)
         */
        Builder effectivePolicies(Consumer<EffectivePolicy.Builder>... effectivePolicies);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<EffectivePolicy> effectivePolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEffectivePoliciesResponse model) {
            super(model);
            effectivePolicies(model.effectivePolicies);
        }

        public final List<EffectivePolicy.Builder> getEffectivePolicies() {
            List<EffectivePolicy.Builder> result = EffectivePoliciesCopier.copyToBuilder(this.effectivePolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEffectivePolicies(Collection<EffectivePolicy.BuilderImpl> effectivePolicies) {
            this.effectivePolicies = EffectivePoliciesCopier.copyFromBuilder(effectivePolicies);
        }

        @Override
        @Transient
        public final Builder effectivePolicies(Collection<EffectivePolicy> effectivePolicies) {
            this.effectivePolicies = EffectivePoliciesCopier.copy(effectivePolicies);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder effectivePolicies(EffectivePolicy... effectivePolicies) {
            effectivePolicies(Arrays.asList(effectivePolicies));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder effectivePolicies(Consumer<EffectivePolicy.Builder>... effectivePolicies) {
            effectivePolicies(Stream.of(effectivePolicies).map(c -> EffectivePolicy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetEffectivePoliciesResponse build() {
            return new GetEffectivePoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
