/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input to the RegisterCACertificate operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterCaCertificateRequest extends IotRequest implements
        ToCopyableBuilder<RegisterCaCertificateRequest.Builder, RegisterCaCertificateRequest> {
    private static final SdkField<String> CA_CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("caCertificate").getter(getter(RegisterCaCertificateRequest::caCertificate))
            .setter(setter(Builder::caCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caCertificate").build()).build();

    private static final SdkField<String> VERIFICATION_CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("verificationCertificate").getter(getter(RegisterCaCertificateRequest::verificationCertificate))
            .setter(setter(Builder::verificationCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verificationCertificate").build())
            .build();

    private static final SdkField<Boolean> SET_AS_ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("setAsActive").getter(getter(RegisterCaCertificateRequest::setAsActive))
            .setter(setter(Builder::setAsActive))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("setAsActive").build()).build();

    private static final SdkField<Boolean> ALLOW_AUTO_REGISTRATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowAutoRegistration").getter(getter(RegisterCaCertificateRequest::allowAutoRegistration))
            .setter(setter(Builder::allowAutoRegistration))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("allowAutoRegistration").build())
            .build();

    private static final SdkField<RegistrationConfig> REGISTRATION_CONFIG_FIELD = SdkField
            .<RegistrationConfig> builder(MarshallingType.SDK_POJO).memberName("registrationConfig")
            .getter(getter(RegisterCaCertificateRequest::registrationConfig)).setter(setter(Builder::registrationConfig))
            .constructor(RegistrationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationConfig").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(RegisterCaCertificateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CA_CERTIFICATE_FIELD,
            VERIFICATION_CERTIFICATE_FIELD, SET_AS_ACTIVE_FIELD, ALLOW_AUTO_REGISTRATION_FIELD, REGISTRATION_CONFIG_FIELD,
            TAGS_FIELD));

    private final String caCertificate;

    private final String verificationCertificate;

    private final Boolean setAsActive;

    private final Boolean allowAutoRegistration;

    private final RegistrationConfig registrationConfig;

    private final List<Tag> tags;

    private RegisterCaCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.caCertificate = builder.caCertificate;
        this.verificationCertificate = builder.verificationCertificate;
        this.setAsActive = builder.setAsActive;
        this.allowAutoRegistration = builder.allowAutoRegistration;
        this.registrationConfig = builder.registrationConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The CA certificate.
     * </p>
     * 
     * @return The CA certificate.
     */
    public final String caCertificate() {
        return caCertificate;
    }

    /**
     * <p>
     * The private key verification certificate.
     * </p>
     * 
     * @return The private key verification certificate.
     */
    public final String verificationCertificate() {
        return verificationCertificate;
    }

    /**
     * <p>
     * A boolean value that specifies if the CA certificate is set to active.
     * </p>
     * 
     * @return A boolean value that specifies if the CA certificate is set to active.
     */
    public final Boolean setAsActive() {
        return setAsActive;
    }

    /**
     * <p>
     * Allows this CA certificate to be used for auto registration of device certificates.
     * </p>
     * 
     * @return Allows this CA certificate to be used for auto registration of device certificates.
     */
    public final Boolean allowAutoRegistration() {
        return allowAutoRegistration;
    }

    /**
     * <p>
     * Information about the registration configuration.
     * </p>
     * 
     * @return Information about the registration configuration.
     */
    public final RegistrationConfig registrationConfig() {
        return registrationConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata which can be used to manage the CA certificate.
     * </p>
     * <note>
     * <p>
     * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
     * </p>
     * <p>
     * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
     * </p>
     * <p>
     * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata which can be used to manage the CA certificate.</p> <note>
     *         <p>
     *         For URI Request parameters use format: ...key1=value1&amp;key2=value2...
     *         </p>
     *         <p>
     *         For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
     *         </p>
     *         <p>
     *         For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
     *         </p>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(caCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(verificationCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(setAsActive());
        hashCode = 31 * hashCode + Objects.hashCode(allowAutoRegistration());
        hashCode = 31 * hashCode + Objects.hashCode(registrationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterCaCertificateRequest)) {
            return false;
        }
        RegisterCaCertificateRequest other = (RegisterCaCertificateRequest) obj;
        return Objects.equals(caCertificate(), other.caCertificate())
                && Objects.equals(verificationCertificate(), other.verificationCertificate())
                && Objects.equals(setAsActive(), other.setAsActive())
                && Objects.equals(allowAutoRegistration(), other.allowAutoRegistration())
                && Objects.equals(registrationConfig(), other.registrationConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterCaCertificateRequest").add("CaCertificate", caCertificate())
                .add("VerificationCertificate", verificationCertificate()).add("SetAsActive", setAsActive())
                .add("AllowAutoRegistration", allowAutoRegistration()).add("RegistrationConfig", registrationConfig())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caCertificate":
            return Optional.ofNullable(clazz.cast(caCertificate()));
        case "verificationCertificate":
            return Optional.ofNullable(clazz.cast(verificationCertificate()));
        case "setAsActive":
            return Optional.ofNullable(clazz.cast(setAsActive()));
        case "allowAutoRegistration":
            return Optional.ofNullable(clazz.cast(allowAutoRegistration()));
        case "registrationConfig":
            return Optional.ofNullable(clazz.cast(registrationConfig()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterCaCertificateRequest, T> g) {
        return obj -> g.apply((RegisterCaCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterCaCertificateRequest> {
        /**
         * <p>
         * The CA certificate.
         * </p>
         * 
         * @param caCertificate
         *        The CA certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificate(String caCertificate);

        /**
         * <p>
         * The private key verification certificate.
         * </p>
         * 
         * @param verificationCertificate
         *        The private key verification certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationCertificate(String verificationCertificate);

        /**
         * <p>
         * A boolean value that specifies if the CA certificate is set to active.
         * </p>
         * 
         * @param setAsActive
         *        A boolean value that specifies if the CA certificate is set to active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setAsActive(Boolean setAsActive);

        /**
         * <p>
         * Allows this CA certificate to be used for auto registration of device certificates.
         * </p>
         * 
         * @param allowAutoRegistration
         *        Allows this CA certificate to be used for auto registration of device certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowAutoRegistration(Boolean allowAutoRegistration);

        /**
         * <p>
         * Information about the registration configuration.
         * </p>
         * 
         * @param registrationConfig
         *        Information about the registration configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationConfig(RegistrationConfig registrationConfig);

        /**
         * <p>
         * Information about the registration configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link RegistrationConfig.Builder} avoiding the
         * need to create one manually via {@link RegistrationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link RegistrationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #registrationConfig(RegistrationConfig)}.
         * 
         * @param registrationConfig
         *        a consumer that will call methods on {@link RegistrationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registrationConfig(RegistrationConfig)
         */
        default Builder registrationConfig(Consumer<RegistrationConfig.Builder> registrationConfig) {
            return registrationConfig(RegistrationConfig.builder().applyMutation(registrationConfig).build());
        }

        /**
         * <p>
         * Metadata which can be used to manage the CA certificate.
         * </p>
         * <note>
         * <p>
         * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         * </p>
         * <p>
         * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
         * </p>
         * <p>
         * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         * </p>
         * </note>
         * 
         * @param tags
         *        Metadata which can be used to manage the CA certificate.</p> <note>
         *        <p>
         *        For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         *        </p>
         *        <p>
         *        For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
         *        </p>
         *        <p>
         *        For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Metadata which can be used to manage the CA certificate.
         * </p>
         * <note>
         * <p>
         * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         * </p>
         * <p>
         * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
         * </p>
         * <p>
         * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         * </p>
         * </note>
         * 
         * @param tags
         *        Metadata which can be used to manage the CA certificate.</p> <note>
         *        <p>
         *        For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         *        </p>
         *        <p>
         *        For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
         *        </p>
         *        <p>
         *        For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Metadata which can be used to manage the CA certificate.
         * </p>
         * <note>
         * <p>
         * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         * </p>
         * <p>
         * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
         * </p>
         * <p>
         * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the
         * need to create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String caCertificate;

        private String verificationCertificate;

        private Boolean setAsActive;

        private Boolean allowAutoRegistration;

        private RegistrationConfig registrationConfig;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterCaCertificateRequest model) {
            super(model);
            caCertificate(model.caCertificate);
            verificationCertificate(model.verificationCertificate);
            setAsActive(model.setAsActive);
            allowAutoRegistration(model.allowAutoRegistration);
            registrationConfig(model.registrationConfig);
            tags(model.tags);
        }

        public final String getCaCertificate() {
            return caCertificate;
        }

        public final void setCaCertificate(String caCertificate) {
            this.caCertificate = caCertificate;
        }

        @Override
        @Transient
        public final Builder caCertificate(String caCertificate) {
            this.caCertificate = caCertificate;
            return this;
        }

        public final String getVerificationCertificate() {
            return verificationCertificate;
        }

        public final void setVerificationCertificate(String verificationCertificate) {
            this.verificationCertificate = verificationCertificate;
        }

        @Override
        @Transient
        public final Builder verificationCertificate(String verificationCertificate) {
            this.verificationCertificate = verificationCertificate;
            return this;
        }

        public final Boolean getSetAsActive() {
            return setAsActive;
        }

        public final void setSetAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
        }

        @Override
        @Transient
        public final Builder setAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
            return this;
        }

        public final Boolean getAllowAutoRegistration() {
            return allowAutoRegistration;
        }

        public final void setAllowAutoRegistration(Boolean allowAutoRegistration) {
            this.allowAutoRegistration = allowAutoRegistration;
        }

        @Override
        @Transient
        public final Builder allowAutoRegistration(Boolean allowAutoRegistration) {
            this.allowAutoRegistration = allowAutoRegistration;
            return this;
        }

        public final RegistrationConfig.Builder getRegistrationConfig() {
            return registrationConfig != null ? registrationConfig.toBuilder() : null;
        }

        public final void setRegistrationConfig(RegistrationConfig.BuilderImpl registrationConfig) {
            this.registrationConfig = registrationConfig != null ? registrationConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder registrationConfig(RegistrationConfig registrationConfig) {
            this.registrationConfig = registrationConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterCaCertificateRequest build() {
            return new RegisterCaCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
