/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicRulePayload implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicRulePayload.Builder, TopicRulePayload> {
    private static final SdkField<String> SQL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sql")
            .getter(getter(TopicRulePayload::sql)).setter(setter(Builder::sql))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sql").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(TopicRulePayload::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<Action>> ACTIONS_FIELD = SdkField
            .<List<Action>> builder(MarshallingType.LIST)
            .memberName("actions")
            .getter(getter(TopicRulePayload::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Action> builder(MarshallingType.SDK_POJO)
                                            .constructor(Action::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> RULE_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ruleDisabled").getter(getter(TopicRulePayload::ruleDisabled)).setter(setter(Builder::ruleDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleDisabled").build()).build();

    private static final SdkField<String> AWS_IOT_SQL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsIotSqlVersion").getter(getter(TopicRulePayload::awsIotSqlVersion))
            .setter(setter(Builder::awsIotSqlVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsIotSqlVersion").build()).build();

    private static final SdkField<Action> ERROR_ACTION_FIELD = SdkField.<Action> builder(MarshallingType.SDK_POJO)
            .memberName("errorAction").getter(getter(TopicRulePayload::errorAction)).setter(setter(Builder::errorAction))
            .constructor(Action::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SQL_FIELD, DESCRIPTION_FIELD,
            ACTIONS_FIELD, RULE_DISABLED_FIELD, AWS_IOT_SQL_VERSION_FIELD, ERROR_ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sql;

    private final String description;

    private final List<Action> actions;

    private final Boolean ruleDisabled;

    private final String awsIotSqlVersion;

    private final Action errorAction;

    private TopicRulePayload(BuilderImpl builder) {
        this.sql = builder.sql;
        this.description = builder.description;
        this.actions = builder.actions;
        this.ruleDisabled = builder.ruleDisabled;
        this.awsIotSqlVersion = builder.awsIotSqlVersion;
        this.errorAction = builder.errorAction;
    }

    /**
     * <p>
     * The SQL statement used to query the topic. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-sql-reference.html">IoT SQL Reference</a> in the
     * <i>IoT Developer Guide</i>.
     * </p>
     * 
     * @return The SQL statement used to query the topic. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-sql-reference.html">IoT SQL Reference</a>
     *         in the <i>IoT Developer Guide</i>.
     */
    public final String sql() {
        return sql;
    }

    /**
     * <p>
     * The description of the rule.
     * </p>
     * 
     * @return The description of the rule.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions associated with the rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The actions associated with the rule.
     */
    public final List<Action> actions() {
        return actions;
    }

    /**
     * <p>
     * Specifies whether the rule is disabled.
     * </p>
     * 
     * @return Specifies whether the rule is disabled.
     */
    public final Boolean ruleDisabled() {
        return ruleDisabled;
    }

    /**
     * <p>
     * The version of the SQL rules engine to use when evaluating the rule.
     * </p>
     * 
     * @return The version of the SQL rules engine to use when evaluating the rule.
     */
    public final String awsIotSqlVersion() {
        return awsIotSqlVersion;
    }

    /**
     * <p>
     * The action to take when an error occurs.
     * </p>
     * 
     * @return The action to take when an error occurs.
     */
    public final Action errorAction() {
        return errorAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sql());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ruleDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(awsIotSqlVersion());
        hashCode = 31 * hashCode + Objects.hashCode(errorAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRulePayload)) {
            return false;
        }
        TopicRulePayload other = (TopicRulePayload) obj;
        return Objects.equals(sql(), other.sql()) && Objects.equals(description(), other.description())
                && hasActions() == other.hasActions() && Objects.equals(actions(), other.actions())
                && Objects.equals(ruleDisabled(), other.ruleDisabled())
                && Objects.equals(awsIotSqlVersion(), other.awsIotSqlVersion())
                && Objects.equals(errorAction(), other.errorAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicRulePayload").add("Sql", sql()).add("Description", description())
                .add("Actions", hasActions() ? actions() : null).add("RuleDisabled", ruleDisabled())
                .add("AwsIotSqlVersion", awsIotSqlVersion()).add("ErrorAction", errorAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sql":
            return Optional.ofNullable(clazz.cast(sql()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "ruleDisabled":
            return Optional.ofNullable(clazz.cast(ruleDisabled()));
        case "awsIotSqlVersion":
            return Optional.ofNullable(clazz.cast(awsIotSqlVersion()));
        case "errorAction":
            return Optional.ofNullable(clazz.cast(errorAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicRulePayload, T> g) {
        return obj -> g.apply((TopicRulePayload) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicRulePayload> {
        /**
         * <p>
         * The SQL statement used to query the topic. For more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-sql-reference.html">IoT SQL Reference</a> in
         * the <i>IoT Developer Guide</i>.
         * </p>
         * 
         * @param sql
         *        The SQL statement used to query the topic. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-sql-reference.html">IoT SQL
         *        Reference</a> in the <i>IoT Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sql(String sql);

        /**
         * <p>
         * The description of the rule.
         * </p>
         * 
         * @param description
         *        The description of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The actions associated with the rule.
         * </p>
         * 
         * @param actions
         *        The actions associated with the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<Action> actions);

        /**
         * <p>
         * The actions associated with the rule.
         * </p>
         * 
         * @param actions
         *        The actions associated with the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Action... actions);

        /**
         * <p>
         * The actions associated with the rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Action>.Builder} avoiding the need
         * to create one manually via {@link List<Action>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Action>.Builder#build()} is called immediately and its
         * result is passed to {@link #actions(List<Action>)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link List<Action>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(List<Action>)
         */
        Builder actions(Consumer<Action.Builder>... actions);

        /**
         * <p>
         * Specifies whether the rule is disabled.
         * </p>
         * 
         * @param ruleDisabled
         *        Specifies whether the rule is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleDisabled(Boolean ruleDisabled);

        /**
         * <p>
         * The version of the SQL rules engine to use when evaluating the rule.
         * </p>
         * 
         * @param awsIotSqlVersion
         *        The version of the SQL rules engine to use when evaluating the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsIotSqlVersion(String awsIotSqlVersion);

        /**
         * <p>
         * The action to take when an error occurs.
         * </p>
         * 
         * @param errorAction
         *        The action to take when an error occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorAction(Action errorAction);

        /**
         * <p>
         * The action to take when an error occurs.
         * </p>
         * This is a convenience method that creates an instance of the {@link Action.Builder} avoiding the need to
         * create one manually via {@link Action#builder()}.
         *
         * When the {@link Consumer} completes, {@link Action.Builder#build()} is called immediately and its result is
         * passed to {@link #errorAction(Action)}.
         * 
         * @param errorAction
         *        a consumer that will call methods on {@link Action.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorAction(Action)
         */
        default Builder errorAction(Consumer<Action.Builder> errorAction) {
            return errorAction(Action.builder().applyMutation(errorAction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sql;

        private String description;

        private List<Action> actions = DefaultSdkAutoConstructList.getInstance();

        private Boolean ruleDisabled;

        private String awsIotSqlVersion;

        private Action errorAction;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRulePayload model) {
            sql(model.sql);
            description(model.description);
            actions(model.actions);
            ruleDisabled(model.ruleDisabled);
            awsIotSqlVersion(model.awsIotSqlVersion);
            errorAction(model.errorAction);
        }

        public final String getSql() {
            return sql;
        }

        public final void setSql(String sql) {
            this.sql = sql;
        }

        @Override
        @Transient
        public final Builder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Action.Builder> getActions() {
            List<Action.Builder> result = ActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionListCopier.copyFromBuilder(actions);
        }

        @Override
        @Transient
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionListCopier.copy(actions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actions(Action... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actions(Consumer<Action.Builder>... actions) {
            actions(Stream.of(actions).map(c -> Action.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getRuleDisabled() {
            return ruleDisabled;
        }

        public final void setRuleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
        }

        @Override
        @Transient
        public final Builder ruleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
            return this;
        }

        public final String getAwsIotSqlVersion() {
            return awsIotSqlVersion;
        }

        public final void setAwsIotSqlVersion(String awsIotSqlVersion) {
            this.awsIotSqlVersion = awsIotSqlVersion;
        }

        @Override
        @Transient
        public final Builder awsIotSqlVersion(String awsIotSqlVersion) {
            this.awsIotSqlVersion = awsIotSqlVersion;
            return this;
        }

        public final Action.Builder getErrorAction() {
            return errorAction != null ? errorAction.toBuilder() : null;
        }

        public final void setErrorAction(Action.BuilderImpl errorAction) {
            this.errorAction = errorAction != null ? errorAction.build() : null;
        }

        @Override
        @Transient
        public final Builder errorAction(Action errorAction) {
            this.errorAction = errorAction;
            return this;
        }

        @Override
        public TopicRulePayload build() {
            return new TopicRulePayload(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
