/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDomainConfigurationRequest extends IotRequest implements
        ToCopyableBuilder<UpdateDomainConfigurationRequest.Builder, UpdateDomainConfigurationRequest> {
    private static final SdkField<String> DOMAIN_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainConfigurationName").getter(getter(UpdateDomainConfigurationRequest::domainConfigurationName))
            .setter(setter(Builder::domainConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainConfigurationName").build())
            .build();

    private static final SdkField<AuthorizerConfig> AUTHORIZER_CONFIG_FIELD = SdkField
            .<AuthorizerConfig> builder(MarshallingType.SDK_POJO).memberName("authorizerConfig")
            .getter(getter(UpdateDomainConfigurationRequest::authorizerConfig)).setter(setter(Builder::authorizerConfig))
            .constructor(AuthorizerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerConfig").build()).build();

    private static final SdkField<String> DOMAIN_CONFIGURATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainConfigurationStatus")
            .getter(getter(UpdateDomainConfigurationRequest::domainConfigurationStatusAsString))
            .setter(setter(Builder::domainConfigurationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainConfigurationStatus").build())
            .build();

    private static final SdkField<Boolean> REMOVE_AUTHORIZER_CONFIG_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("removeAuthorizerConfig").getter(getter(UpdateDomainConfigurationRequest::removeAuthorizerConfig))
            .setter(setter(Builder::removeAuthorizerConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeAuthorizerConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DOMAIN_CONFIGURATION_NAME_FIELD, AUTHORIZER_CONFIG_FIELD, DOMAIN_CONFIGURATION_STATUS_FIELD,
            REMOVE_AUTHORIZER_CONFIG_FIELD));

    private final String domainConfigurationName;

    private final AuthorizerConfig authorizerConfig;

    private final String domainConfigurationStatus;

    private final Boolean removeAuthorizerConfig;

    private UpdateDomainConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.domainConfigurationName = builder.domainConfigurationName;
        this.authorizerConfig = builder.authorizerConfig;
        this.domainConfigurationStatus = builder.domainConfigurationStatus;
        this.removeAuthorizerConfig = builder.removeAuthorizerConfig;
    }

    /**
     * <p>
     * The name of the domain configuration to be updated.
     * </p>
     * 
     * @return The name of the domain configuration to be updated.
     */
    public final String domainConfigurationName() {
        return domainConfigurationName;
    }

    /**
     * <p>
     * An object that specifies the authorization service for a domain.
     * </p>
     * 
     * @return An object that specifies the authorization service for a domain.
     */
    public final AuthorizerConfig authorizerConfig() {
        return authorizerConfig;
    }

    /**
     * <p>
     * The status to which the domain configuration should be updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #domainConfigurationStatus} will return {@link DomainConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #domainConfigurationStatusAsString}.
     * </p>
     * 
     * @return The status to which the domain configuration should be updated.
     * @see DomainConfigurationStatus
     */
    public final DomainConfigurationStatus domainConfigurationStatus() {
        return DomainConfigurationStatus.fromValue(domainConfigurationStatus);
    }

    /**
     * <p>
     * The status to which the domain configuration should be updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #domainConfigurationStatus} will return {@link DomainConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #domainConfigurationStatusAsString}.
     * </p>
     * 
     * @return The status to which the domain configuration should be updated.
     * @see DomainConfigurationStatus
     */
    public final String domainConfigurationStatusAsString() {
        return domainConfigurationStatus;
    }

    /**
     * <p>
     * Removes the authorization configuration from a domain.
     * </p>
     * 
     * @return Removes the authorization configuration from a domain.
     */
    public final Boolean removeAuthorizerConfig() {
        return removeAuthorizerConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(authorizerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(domainConfigurationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(removeAuthorizerConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainConfigurationRequest)) {
            return false;
        }
        UpdateDomainConfigurationRequest other = (UpdateDomainConfigurationRequest) obj;
        return Objects.equals(domainConfigurationName(), other.domainConfigurationName())
                && Objects.equals(authorizerConfig(), other.authorizerConfig())
                && Objects.equals(domainConfigurationStatusAsString(), other.domainConfigurationStatusAsString())
                && Objects.equals(removeAuthorizerConfig(), other.removeAuthorizerConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDomainConfigurationRequest").add("DomainConfigurationName", domainConfigurationName())
                .add("AuthorizerConfig", authorizerConfig())
                .add("DomainConfigurationStatus", domainConfigurationStatusAsString())
                .add("RemoveAuthorizerConfig", removeAuthorizerConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainConfigurationName":
            return Optional.ofNullable(clazz.cast(domainConfigurationName()));
        case "authorizerConfig":
            return Optional.ofNullable(clazz.cast(authorizerConfig()));
        case "domainConfigurationStatus":
            return Optional.ofNullable(clazz.cast(domainConfigurationStatusAsString()));
        case "removeAuthorizerConfig":
            return Optional.ofNullable(clazz.cast(removeAuthorizerConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateDomainConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDomainConfigurationRequest> {
        /**
         * <p>
         * The name of the domain configuration to be updated.
         * </p>
         * 
         * @param domainConfigurationName
         *        The name of the domain configuration to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainConfigurationName(String domainConfigurationName);

        /**
         * <p>
         * An object that specifies the authorization service for a domain.
         * </p>
         * 
         * @param authorizerConfig
         *        An object that specifies the authorization service for a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerConfig(AuthorizerConfig authorizerConfig);

        /**
         * <p>
         * An object that specifies the authorization service for a domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthorizerConfig.Builder} avoiding the
         * need to create one manually via {@link AuthorizerConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AuthorizerConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #authorizerConfig(AuthorizerConfig)}.
         * 
         * @param authorizerConfig
         *        a consumer that will call methods on {@link AuthorizerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizerConfig(AuthorizerConfig)
         */
        default Builder authorizerConfig(Consumer<AuthorizerConfig.Builder> authorizerConfig) {
            return authorizerConfig(AuthorizerConfig.builder().applyMutation(authorizerConfig).build());
        }

        /**
         * <p>
         * The status to which the domain configuration should be updated.
         * </p>
         * 
         * @param domainConfigurationStatus
         *        The status to which the domain configuration should be updated.
         * @see DomainConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainConfigurationStatus
         */
        Builder domainConfigurationStatus(String domainConfigurationStatus);

        /**
         * <p>
         * The status to which the domain configuration should be updated.
         * </p>
         * 
         * @param domainConfigurationStatus
         *        The status to which the domain configuration should be updated.
         * @see DomainConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainConfigurationStatus
         */
        Builder domainConfigurationStatus(DomainConfigurationStatus domainConfigurationStatus);

        /**
         * <p>
         * Removes the authorization configuration from a domain.
         * </p>
         * 
         * @param removeAuthorizerConfig
         *        Removes the authorization configuration from a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeAuthorizerConfig(Boolean removeAuthorizerConfig);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String domainConfigurationName;

        private AuthorizerConfig authorizerConfig;

        private String domainConfigurationStatus;

        private Boolean removeAuthorizerConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainConfigurationRequest model) {
            super(model);
            domainConfigurationName(model.domainConfigurationName);
            authorizerConfig(model.authorizerConfig);
            domainConfigurationStatus(model.domainConfigurationStatus);
            removeAuthorizerConfig(model.removeAuthorizerConfig);
        }

        public final String getDomainConfigurationName() {
            return domainConfigurationName;
        }

        public final void setDomainConfigurationName(String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
        }

        @Override
        @Transient
        public final Builder domainConfigurationName(String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
            return this;
        }

        public final AuthorizerConfig.Builder getAuthorizerConfig() {
            return authorizerConfig != null ? authorizerConfig.toBuilder() : null;
        }

        public final void setAuthorizerConfig(AuthorizerConfig.BuilderImpl authorizerConfig) {
            this.authorizerConfig = authorizerConfig != null ? authorizerConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder authorizerConfig(AuthorizerConfig authorizerConfig) {
            this.authorizerConfig = authorizerConfig;
            return this;
        }

        public final String getDomainConfigurationStatus() {
            return domainConfigurationStatus;
        }

        public final void setDomainConfigurationStatus(String domainConfigurationStatus) {
            this.domainConfigurationStatus = domainConfigurationStatus;
        }

        @Override
        @Transient
        public final Builder domainConfigurationStatus(String domainConfigurationStatus) {
            this.domainConfigurationStatus = domainConfigurationStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder domainConfigurationStatus(DomainConfigurationStatus domainConfigurationStatus) {
            this.domainConfigurationStatus(domainConfigurationStatus == null ? null : domainConfigurationStatus.toString());
            return this;
        }

        public final Boolean getRemoveAuthorizerConfig() {
            return removeAuthorizerConfig;
        }

        public final void setRemoveAuthorizerConfig(Boolean removeAuthorizerConfig) {
            this.removeAuthorizerConfig = removeAuthorizerConfig;
        }

        @Override
        @Transient
        public final Builder removeAuthorizerConfig(Boolean removeAuthorizerConfig) {
            this.removeAuthorizerConfig = removeAuthorizerConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainConfigurationRequest build() {
            return new UpdateDomainConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
