/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProvisioningTemplateRequest extends IotRequest implements
        ToCopyableBuilder<UpdateProvisioningTemplateRequest.Builder, UpdateProvisioningTemplateRequest> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateName").getter(getter(UpdateProvisioningTemplateRequest::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("templateName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateProvisioningTemplateRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(UpdateProvisioningTemplateRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<Integer> DEFAULT_VERSION_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("defaultVersionId").getter(getter(UpdateProvisioningTemplateRequest::defaultVersionId))
            .setter(setter(Builder::defaultVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVersionId").build()).build();

    private static final SdkField<String> PROVISIONING_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provisioningRoleArn").getter(getter(UpdateProvisioningTemplateRequest::provisioningRoleArn))
            .setter(setter(Builder::provisioningRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningRoleArn").build())
            .build();

    private static final SdkField<ProvisioningHook> PRE_PROVISIONING_HOOK_FIELD = SdkField
            .<ProvisioningHook> builder(MarshallingType.SDK_POJO).memberName("preProvisioningHook")
            .getter(getter(UpdateProvisioningTemplateRequest::preProvisioningHook)).setter(setter(Builder::preProvisioningHook))
            .constructor(ProvisioningHook::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preProvisioningHook").build())
            .build();

    private static final SdkField<Boolean> REMOVE_PRE_PROVISIONING_HOOK_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("removePreProvisioningHook")
            .getter(getter(UpdateProvisioningTemplateRequest::removePreProvisioningHook))
            .setter(setter(Builder::removePreProvisioningHook))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removePreProvisioningHook").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD,
            DESCRIPTION_FIELD, ENABLED_FIELD, DEFAULT_VERSION_ID_FIELD, PROVISIONING_ROLE_ARN_FIELD, PRE_PROVISIONING_HOOK_FIELD,
            REMOVE_PRE_PROVISIONING_HOOK_FIELD));

    private final String templateName;

    private final String description;

    private final Boolean enabled;

    private final Integer defaultVersionId;

    private final String provisioningRoleArn;

    private final ProvisioningHook preProvisioningHook;

    private final Boolean removePreProvisioningHook;

    private UpdateProvisioningTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.templateName = builder.templateName;
        this.description = builder.description;
        this.enabled = builder.enabled;
        this.defaultVersionId = builder.defaultVersionId;
        this.provisioningRoleArn = builder.provisioningRoleArn;
        this.preProvisioningHook = builder.preProvisioningHook;
        this.removePreProvisioningHook = builder.removePreProvisioningHook;
    }

    /**
     * <p>
     * The name of the fleet provisioning template.
     * </p>
     * 
     * @return The name of the fleet provisioning template.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The description of the fleet provisioning template.
     * </p>
     * 
     * @return The description of the fleet provisioning template.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * True to enable the fleet provisioning template, otherwise false.
     * </p>
     * 
     * @return True to enable the fleet provisioning template, otherwise false.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The ID of the default provisioning template version.
     * </p>
     * 
     * @return The ID of the default provisioning template version.
     */
    public final Integer defaultVersionId() {
        return defaultVersionId;
    }

    /**
     * <p>
     * The ARN of the role associated with the provisioning template. This IoT role grants permission to provision a
     * device.
     * </p>
     * 
     * @return The ARN of the role associated with the provisioning template. This IoT role grants permission to
     *         provision a device.
     */
    public final String provisioningRoleArn() {
        return provisioningRoleArn;
    }

    /**
     * <p>
     * Updates the pre-provisioning hook template.
     * </p>
     * 
     * @return Updates the pre-provisioning hook template.
     */
    public final ProvisioningHook preProvisioningHook() {
        return preProvisioningHook;
    }

    /**
     * <p>
     * Removes pre-provisioning hook template.
     * </p>
     * 
     * @return Removes pre-provisioning hook template.
     */
    public final Boolean removePreProvisioningHook() {
        return removePreProvisioningHook;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(defaultVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(preProvisioningHook());
        hashCode = 31 * hashCode + Objects.hashCode(removePreProvisioningHook());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProvisioningTemplateRequest)) {
            return false;
        }
        UpdateProvisioningTemplateRequest other = (UpdateProvisioningTemplateRequest) obj;
        return Objects.equals(templateName(), other.templateName()) && Objects.equals(description(), other.description())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(defaultVersionId(), other.defaultVersionId())
                && Objects.equals(provisioningRoleArn(), other.provisioningRoleArn())
                && Objects.equals(preProvisioningHook(), other.preProvisioningHook())
                && Objects.equals(removePreProvisioningHook(), other.removePreProvisioningHook());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProvisioningTemplateRequest").add("TemplateName", templateName())
                .add("Description", description()).add("Enabled", enabled()).add("DefaultVersionId", defaultVersionId())
                .add("ProvisioningRoleArn", provisioningRoleArn()).add("PreProvisioningHook", preProvisioningHook())
                .add("RemovePreProvisioningHook", removePreProvisioningHook()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "templateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "defaultVersionId":
            return Optional.ofNullable(clazz.cast(defaultVersionId()));
        case "provisioningRoleArn":
            return Optional.ofNullable(clazz.cast(provisioningRoleArn()));
        case "preProvisioningHook":
            return Optional.ofNullable(clazz.cast(preProvisioningHook()));
        case "removePreProvisioningHook":
            return Optional.ofNullable(clazz.cast(removePreProvisioningHook()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProvisioningTemplateRequest, T> g) {
        return obj -> g.apply((UpdateProvisioningTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateProvisioningTemplateRequest> {
        /**
         * <p>
         * The name of the fleet provisioning template.
         * </p>
         * 
         * @param templateName
         *        The name of the fleet provisioning template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The description of the fleet provisioning template.
         * </p>
         * 
         * @param description
         *        The description of the fleet provisioning template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * True to enable the fleet provisioning template, otherwise false.
         * </p>
         * 
         * @param enabled
         *        True to enable the fleet provisioning template, otherwise false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The ID of the default provisioning template version.
         * </p>
         * 
         * @param defaultVersionId
         *        The ID of the default provisioning template version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVersionId(Integer defaultVersionId);

        /**
         * <p>
         * The ARN of the role associated with the provisioning template. This IoT role grants permission to provision a
         * device.
         * </p>
         * 
         * @param provisioningRoleArn
         *        The ARN of the role associated with the provisioning template. This IoT role grants permission to
         *        provision a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningRoleArn(String provisioningRoleArn);

        /**
         * <p>
         * Updates the pre-provisioning hook template.
         * </p>
         * 
         * @param preProvisioningHook
         *        Updates the pre-provisioning hook template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preProvisioningHook(ProvisioningHook preProvisioningHook);

        /**
         * <p>
         * Updates the pre-provisioning hook template.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProvisioningHook.Builder} avoiding the
         * need to create one manually via {@link ProvisioningHook#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProvisioningHook.Builder#build()} is called immediately and its
         * result is passed to {@link #preProvisioningHook(ProvisioningHook)}.
         * 
         * @param preProvisioningHook
         *        a consumer that will call methods on {@link ProvisioningHook.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preProvisioningHook(ProvisioningHook)
         */
        default Builder preProvisioningHook(Consumer<ProvisioningHook.Builder> preProvisioningHook) {
            return preProvisioningHook(ProvisioningHook.builder().applyMutation(preProvisioningHook).build());
        }

        /**
         * <p>
         * Removes pre-provisioning hook template.
         * </p>
         * 
         * @param removePreProvisioningHook
         *        Removes pre-provisioning hook template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removePreProvisioningHook(Boolean removePreProvisioningHook);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String templateName;

        private String description;

        private Boolean enabled;

        private Integer defaultVersionId;

        private String provisioningRoleArn;

        private ProvisioningHook preProvisioningHook;

        private Boolean removePreProvisioningHook;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProvisioningTemplateRequest model) {
            super(model);
            templateName(model.templateName);
            description(model.description);
            enabled(model.enabled);
            defaultVersionId(model.defaultVersionId);
            provisioningRoleArn(model.provisioningRoleArn);
            preProvisioningHook(model.preProvisioningHook);
            removePreProvisioningHook(model.removePreProvisioningHook);
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        @Transient
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        @Transient
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getDefaultVersionId() {
            return defaultVersionId;
        }

        public final void setDefaultVersionId(Integer defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
        }

        @Override
        @Transient
        public final Builder defaultVersionId(Integer defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
            return this;
        }

        public final String getProvisioningRoleArn() {
            return provisioningRoleArn;
        }

        public final void setProvisioningRoleArn(String provisioningRoleArn) {
            this.provisioningRoleArn = provisioningRoleArn;
        }

        @Override
        @Transient
        public final Builder provisioningRoleArn(String provisioningRoleArn) {
            this.provisioningRoleArn = provisioningRoleArn;
            return this;
        }

        public final ProvisioningHook.Builder getPreProvisioningHook() {
            return preProvisioningHook != null ? preProvisioningHook.toBuilder() : null;
        }

        public final void setPreProvisioningHook(ProvisioningHook.BuilderImpl preProvisioningHook) {
            this.preProvisioningHook = preProvisioningHook != null ? preProvisioningHook.build() : null;
        }

        @Override
        @Transient
        public final Builder preProvisioningHook(ProvisioningHook preProvisioningHook) {
            this.preProvisioningHook = preProvisioningHook;
            return this;
        }

        public final Boolean getRemovePreProvisioningHook() {
            return removePreProvisioningHook;
        }

        public final void setRemovePreProvisioningHook(Boolean removePreProvisioningHook) {
            this.removePreProvisioningHook = removePreProvisioningHook;
        }

        @Override
        @Transient
        public final Builder removePreProvisioningHook(Boolean removePreProvisioningHook) {
            this.removePreProvisioningHook = removePreProvisioningHook;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProvisioningTemplateRequest build() {
            return new UpdateProvisioningTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
