/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidateSecurityProfileBehaviorsRequest extends IotRequest implements
        ToCopyableBuilder<ValidateSecurityProfileBehaviorsRequest.Builder, ValidateSecurityProfileBehaviorsRequest> {
    private static final SdkField<List<Behavior>> BEHAVIORS_FIELD = SdkField
            .<List<Behavior>> builder(MarshallingType.LIST)
            .memberName("behaviors")
            .getter(getter(ValidateSecurityProfileBehaviorsRequest::behaviors))
            .setter(setter(Builder::behaviors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behaviors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Behavior> builder(MarshallingType.SDK_POJO)
                                            .constructor(Behavior::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEHAVIORS_FIELD));

    private final List<Behavior> behaviors;

    private ValidateSecurityProfileBehaviorsRequest(BuilderImpl builder) {
        super(builder);
        this.behaviors = builder.behaviors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Behaviors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBehaviors() {
        return behaviors != null && !(behaviors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the behaviors that, when violated by a device (thing), cause an alert.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBehaviors} method.
     * </p>
     * 
     * @return Specifies the behaviors that, when violated by a device (thing), cause an alert.
     */
    public final List<Behavior> behaviors() {
        return behaviors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBehaviors() ? behaviors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateSecurityProfileBehaviorsRequest)) {
            return false;
        }
        ValidateSecurityProfileBehaviorsRequest other = (ValidateSecurityProfileBehaviorsRequest) obj;
        return hasBehaviors() == other.hasBehaviors() && Objects.equals(behaviors(), other.behaviors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidateSecurityProfileBehaviorsRequest").add("Behaviors", hasBehaviors() ? behaviors() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "behaviors":
            return Optional.ofNullable(clazz.cast(behaviors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidateSecurityProfileBehaviorsRequest, T> g) {
        return obj -> g.apply((ValidateSecurityProfileBehaviorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ValidateSecurityProfileBehaviorsRequest> {
        /**
         * <p>
         * Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * </p>
         * 
         * @param behaviors
         *        Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder behaviors(Collection<Behavior> behaviors);

        /**
         * <p>
         * Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * </p>
         * 
         * @param behaviors
         *        Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder behaviors(Behavior... behaviors);

        /**
         * <p>
         * Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Behavior>.Builder} avoiding the need
         * to create one manually via {@link List<Behavior>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Behavior>.Builder#build()} is called immediately and its
         * result is passed to {@link #behaviors(List<Behavior>)}.
         * 
         * @param behaviors
         *        a consumer that will call methods on {@link List<Behavior>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #behaviors(List<Behavior>)
         */
        Builder behaviors(Consumer<Behavior.Builder>... behaviors);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private List<Behavior> behaviors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateSecurityProfileBehaviorsRequest model) {
            super(model);
            behaviors(model.behaviors);
        }

        public final List<Behavior.Builder> getBehaviors() {
            List<Behavior.Builder> result = BehaviorsCopier.copyToBuilder(this.behaviors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBehaviors(Collection<Behavior.BuilderImpl> behaviors) {
            this.behaviors = BehaviorsCopier.copyFromBuilder(behaviors);
        }

        @Override
        @Transient
        public final Builder behaviors(Collection<Behavior> behaviors) {
            this.behaviors = BehaviorsCopier.copy(behaviors);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder behaviors(Behavior... behaviors) {
            behaviors(Arrays.asList(behaviors));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder behaviors(Consumer<Behavior.Builder>... behaviors) {
            behaviors(Stream.of(behaviors).map(c -> Behavior.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ValidateSecurityProfileBehaviorsRequest build() {
            return new ValidateSecurityProfileBehaviorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
