/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties of the thing, including thing name, thing type name, and a list of thing attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThingAttribute implements SdkPojo, Serializable, ToCopyableBuilder<ThingAttribute.Builder, ThingAttribute> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(ThingAttribute::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()).build();

    private static final SdkField<String> THING_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingTypeName").getter(getter(ThingAttribute::thingTypeName)).setter(setter(Builder::thingTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeName").build()).build();

    private static final SdkField<String> THING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingArn").getter(getter(ThingAttribute::thingArn)).setter(setter(Builder::thingArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingArn").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("attributes")
            .getter(getter(ThingAttribute::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("version")
            .getter(getter(ThingAttribute::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD,
            THING_TYPE_NAME_FIELD, THING_ARN_FIELD, ATTRIBUTES_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String thingName;

    private final String thingTypeName;

    private final String thingArn;

    private final Map<String, String> attributes;

    private final Long version;

    private ThingAttribute(BuilderImpl builder) {
        this.thingName = builder.thingName;
        this.thingTypeName = builder.thingTypeName;
        this.thingArn = builder.thingArn;
        this.attributes = builder.attributes;
        this.version = builder.version;
    }

    /**
     * <p>
     * The name of the thing.
     * </p>
     * 
     * @return The name of the thing.
     */
    public final String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The name of the thing type, if the thing has been associated with a type.
     * </p>
     * 
     * @return The name of the thing type, if the thing has been associated with a type.
     */
    public final String thingTypeName() {
        return thingTypeName;
    }

    /**
     * <p>
     * The thing ARN.
     * </p>
     * 
     * @return The thing ARN.
     */
    public final String thingArn() {
        return thingArn;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of thing attributes which are name-value pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of thing attributes which are name-value pairs.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The version of the thing record in the registry.
     * </p>
     * 
     * @return The version of the thing record in the registry.
     */
    public final Long version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(thingArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingAttribute)) {
            return false;
        }
        ThingAttribute other = (ThingAttribute) obj;
        return Objects.equals(thingName(), other.thingName()) && Objects.equals(thingTypeName(), other.thingTypeName())
                && Objects.equals(thingArn(), other.thingArn()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThingAttribute").add("ThingName", thingName()).add("ThingTypeName", thingTypeName())
                .add("ThingArn", thingArn()).add("Attributes", hasAttributes() ? attributes() : null).add("Version", version())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "thingTypeName":
            return Optional.ofNullable(clazz.cast(thingTypeName()));
        case "thingArn":
            return Optional.ofNullable(clazz.cast(thingArn()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThingAttribute, T> g) {
        return obj -> g.apply((ThingAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThingAttribute> {
        /**
         * <p>
         * The name of the thing.
         * </p>
         * 
         * @param thingName
         *        The name of the thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The name of the thing type, if the thing has been associated with a type.
         * </p>
         * 
         * @param thingTypeName
         *        The name of the thing type, if the thing has been associated with a type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeName(String thingTypeName);

        /**
         * <p>
         * The thing ARN.
         * </p>
         * 
         * @param thingArn
         *        The thing ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingArn(String thingArn);

        /**
         * <p>
         * A list of thing attributes which are name-value pairs.
         * </p>
         * 
         * @param attributes
         *        A list of thing attributes which are name-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * The version of the thing record in the registry.
         * </p>
         * 
         * @param version
         *        The version of the thing record in the registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);
    }

    static final class BuilderImpl implements Builder {
        private String thingName;

        private String thingTypeName;

        private String thingArn;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private Long version;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingAttribute model) {
            thingName(model.thingName);
            thingTypeName(model.thingTypeName);
            thingArn(model.thingArn);
            attributes(model.attributes);
            version(model.version);
        }

        public final String getThingName() {
            return thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        @Transient
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final String getThingTypeName() {
            return thingTypeName;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        @Override
        @Transient
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final String getThingArn() {
            return thingArn;
        }

        public final void setThingArn(String thingArn) {
            this.thingArn = thingArn;
        }

        @Override
        @Transient
        public final Builder thingArn(String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        @Transient
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final Long getVersion() {
            return version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        @Override
        public ThingAttribute build() {
            return new ThingAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
