/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMetricValuesResponse extends IotResponse implements
        ToCopyableBuilder<ListMetricValuesResponse.Builder, ListMetricValuesResponse> {
    private static final SdkField<List<MetricDatum>> METRIC_DATUM_LIST_FIELD = SdkField
            .<List<MetricDatum>> builder(MarshallingType.LIST)
            .memberName("metricDatumList")
            .getter(getter(ListMetricValuesResponse::metricDatumList))
            .setter(setter(Builder::metricDatumList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricDatumList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricDatum> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricDatum::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListMetricValuesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_DATUM_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<MetricDatum> metricDatumList;

    private final String nextToken;

    private ListMetricValuesResponse(BuilderImpl builder) {
        super(builder);
        this.metricDatumList = builder.metricDatumList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricDatumList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricDatumList() {
        return metricDatumList != null && !(metricDatumList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data the thing reports for the metric during the specified time period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricDatumList} method.
     * </p>
     * 
     * @return The data the thing reports for the metric during the specified time period.
     */
    public final List<MetricDatum> metricDatumList() {
        return metricDatumList;
    }

    /**
     * <p>
     * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
     * results.
     * </p>
     * 
     * @return A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
     *         additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricDatumList() ? metricDatumList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetricValuesResponse)) {
            return false;
        }
        ListMetricValuesResponse other = (ListMetricValuesResponse) obj;
        return hasMetricDatumList() == other.hasMetricDatumList() && Objects.equals(metricDatumList(), other.metricDatumList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMetricValuesResponse")
                .add("MetricDatumList", hasMetricDatumList() ? metricDatumList() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metricDatumList":
            return Optional.ofNullable(clazz.cast(metricDatumList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMetricValuesResponse, T> g) {
        return obj -> g.apply((ListMetricValuesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListMetricValuesResponse> {
        /**
         * <p>
         * The data the thing reports for the metric during the specified time period.
         * </p>
         * 
         * @param metricDatumList
         *        The data the thing reports for the metric during the specified time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDatumList(Collection<MetricDatum> metricDatumList);

        /**
         * <p>
         * The data the thing reports for the metric during the specified time period.
         * </p>
         * 
         * @param metricDatumList
         *        The data the thing reports for the metric during the specified time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDatumList(MetricDatum... metricDatumList);

        /**
         * <p>
         * The data the thing reports for the metric during the specified time period.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<MetricDatum>.Builder} avoiding the
         * need to create one manually via {@link List<MetricDatum>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricDatum>.Builder#build()} is called immediately and its
         * result is passed to {@link #metricDatumList(List<MetricDatum>)}.
         * 
         * @param metricDatumList
         *        a consumer that will call methods on {@link List<MetricDatum>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricDatumList(List<MetricDatum>)
         */
        Builder metricDatumList(Consumer<MetricDatum.Builder>... metricDatumList);

        /**
         * <p>
         * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
         * results.
         * </p>
         * 
         * @param nextToken
         *        A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
         *        additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<MetricDatum> metricDatumList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMetricValuesResponse model) {
            super(model);
            metricDatumList(model.metricDatumList);
            nextToken(model.nextToken);
        }

        public final List<MetricDatum.Builder> getMetricDatumList() {
            List<MetricDatum.Builder> result = MetricDatumListCopier.copyToBuilder(this.metricDatumList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDatumList(Collection<MetricDatum.BuilderImpl> metricDatumList) {
            this.metricDatumList = MetricDatumListCopier.copyFromBuilder(metricDatumList);
        }

        @Override
        public final Builder metricDatumList(Collection<MetricDatum> metricDatumList) {
            this.metricDatumList = MetricDatumListCopier.copy(metricDatumList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDatumList(MetricDatum... metricDatumList) {
            metricDatumList(Arrays.asList(metricDatumList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDatumList(Consumer<MetricDatum.Builder>... metricDatumList) {
            metricDatumList(Stream.of(metricDatumList).map(c -> MetricDatum.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMetricValuesResponse build() {
            return new ListMetricValuesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
