/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateScheduledAuditRequest extends IotRequest implements
        ToCopyableBuilder<CreateScheduledAuditRequest.Builder, CreateScheduledAuditRequest> {
    private static final SdkField<String> FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("frequency").getter(getter(CreateScheduledAuditRequest::frequencyAsString))
            .setter(setter(Builder::frequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequency").build()).build();

    private static final SdkField<String> DAY_OF_MONTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dayOfMonth").getter(getter(CreateScheduledAuditRequest::dayOfMonth)).setter(setter(Builder::dayOfMonth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dayOfMonth").build()).build();

    private static final SdkField<String> DAY_OF_WEEK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dayOfWeek").getter(getter(CreateScheduledAuditRequest::dayOfWeekAsString))
            .setter(setter(Builder::dayOfWeek))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dayOfWeek").build()).build();

    private static final SdkField<List<String>> TARGET_CHECK_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("targetCheckNames")
            .getter(getter(CreateScheduledAuditRequest::targetCheckNames))
            .setter(setter(Builder::targetCheckNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetCheckNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SCHEDULED_AUDIT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scheduledAuditName").getter(getter(CreateScheduledAuditRequest::scheduledAuditName))
            .setter(setter(Builder::scheduledAuditName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("scheduledAuditName").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateScheduledAuditRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FREQUENCY_FIELD,
            DAY_OF_MONTH_FIELD, DAY_OF_WEEK_FIELD, TARGET_CHECK_NAMES_FIELD, SCHEDULED_AUDIT_NAME_FIELD, TAGS_FIELD));

    private final String frequency;

    private final String dayOfMonth;

    private final String dayOfWeek;

    private final List<String> targetCheckNames;

    private final String scheduledAuditName;

    private final List<Tag> tags;

    private CreateScheduledAuditRequest(BuilderImpl builder) {
        super(builder);
        this.frequency = builder.frequency;
        this.dayOfMonth = builder.dayOfMonth;
        this.dayOfWeek = builder.dayOfWeek;
        this.targetCheckNames = builder.targetCheckNames;
        this.scheduledAuditName = builder.scheduledAuditName;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * How often the scheduled audit takes place, either <code>DAILY</code>, <code>WEEKLY</code>, <code>BIWEEKLY</code>
     * or <code>MONTHLY</code>. The start time of each audit is determined by the system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link AuditFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frequencyAsString}.
     * </p>
     * 
     * @return How often the scheduled audit takes place, either <code>DAILY</code>, <code>WEEKLY</code>,
     *         <code>BIWEEKLY</code> or <code>MONTHLY</code>. The start time of each audit is determined by the system.
     * @see AuditFrequency
     */
    public final AuditFrequency frequency() {
        return AuditFrequency.fromValue(frequency);
    }

    /**
     * <p>
     * How often the scheduled audit takes place, either <code>DAILY</code>, <code>WEEKLY</code>, <code>BIWEEKLY</code>
     * or <code>MONTHLY</code>. The start time of each audit is determined by the system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link AuditFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frequencyAsString}.
     * </p>
     * 
     * @return How often the scheduled audit takes place, either <code>DAILY</code>, <code>WEEKLY</code>,
     *         <code>BIWEEKLY</code> or <code>MONTHLY</code>. The start time of each audit is determined by the system.
     * @see AuditFrequency
     */
    public final String frequencyAsString() {
        return frequency;
    }

    /**
     * <p>
     * The day of the month on which the scheduled audit takes place. This can be "1" through "31" or "LAST". This field
     * is required if the "frequency" parameter is set to <code>MONTHLY</code>. If days 29 to 31 are specified, and the
     * month doesn't have that many days, the audit takes place on the <code>LAST</code> day of the month.
     * </p>
     * 
     * @return The day of the month on which the scheduled audit takes place. This can be "1" through "31" or "LAST".
     *         This field is required if the "frequency" parameter is set to <code>MONTHLY</code>. If days 29 to 31 are
     *         specified, and the month doesn't have that many days, the audit takes place on the <code>LAST</code> day
     *         of the month.
     */
    public final String dayOfMonth() {
        return dayOfMonth;
    }

    /**
     * <p>
     * The day of the week on which the scheduled audit takes place, either <code>SUN</code>, <code>MON</code>,
     * <code>TUE</code>, <code>WED</code>, <code>THU</code>, <code>FRI</code>, or <code>SAT</code>. This field is
     * required if the <code>frequency</code> parameter is set to <code>WEEKLY</code> or <code>BIWEEKLY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dayOfWeek} will
     * return {@link DayOfWeek#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dayOfWeekAsString}.
     * </p>
     * 
     * @return The day of the week on which the scheduled audit takes place, either <code>SUN</code>, <code>MON</code>,
     *         <code>TUE</code>, <code>WED</code>, <code>THU</code>, <code>FRI</code>, or <code>SAT</code>. This field
     *         is required if the <code>frequency</code> parameter is set to <code>WEEKLY</code> or
     *         <code>BIWEEKLY</code>.
     * @see DayOfWeek
     */
    public final DayOfWeek dayOfWeek() {
        return DayOfWeek.fromValue(dayOfWeek);
    }

    /**
     * <p>
     * The day of the week on which the scheduled audit takes place, either <code>SUN</code>, <code>MON</code>,
     * <code>TUE</code>, <code>WED</code>, <code>THU</code>, <code>FRI</code>, or <code>SAT</code>. This field is
     * required if the <code>frequency</code> parameter is set to <code>WEEKLY</code> or <code>BIWEEKLY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dayOfWeek} will
     * return {@link DayOfWeek#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dayOfWeekAsString}.
     * </p>
     * 
     * @return The day of the week on which the scheduled audit takes place, either <code>SUN</code>, <code>MON</code>,
     *         <code>TUE</code>, <code>WED</code>, <code>THU</code>, <code>FRI</code>, or <code>SAT</code>. This field
     *         is required if the <code>frequency</code> parameter is set to <code>WEEKLY</code> or
     *         <code>BIWEEKLY</code>.
     * @see DayOfWeek
     */
    public final String dayOfWeekAsString() {
        return dayOfWeek;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetCheckNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetCheckNames() {
        return targetCheckNames != null && !(targetCheckNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use
     * <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or
     * use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetCheckNames} method.
     * </p>
     * 
     * @return Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use
     *         <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are
     *         enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)
     */
    public final List<String> targetCheckNames() {
        return targetCheckNames;
    }

    /**
     * <p>
     * The name you want to give to the scheduled audit. (Max. 128 chars)
     * </p>
     * 
     * @return The name you want to give to the scheduled audit. (Max. 128 chars)
     */
    public final String scheduledAuditName() {
        return scheduledAuditName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata that can be used to manage the scheduled audit.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata that can be used to manage the scheduled audit.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(frequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dayOfMonth());
        hashCode = 31 * hashCode + Objects.hashCode(dayOfWeekAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetCheckNames() ? targetCheckNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scheduledAuditName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScheduledAuditRequest)) {
            return false;
        }
        CreateScheduledAuditRequest other = (CreateScheduledAuditRequest) obj;
        return Objects.equals(frequencyAsString(), other.frequencyAsString()) && Objects.equals(dayOfMonth(), other.dayOfMonth())
                && Objects.equals(dayOfWeekAsString(), other.dayOfWeekAsString())
                && hasTargetCheckNames() == other.hasTargetCheckNames()
                && Objects.equals(targetCheckNames(), other.targetCheckNames())
                && Objects.equals(scheduledAuditName(), other.scheduledAuditName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateScheduledAuditRequest").add("Frequency", frequencyAsString())
                .add("DayOfMonth", dayOfMonth()).add("DayOfWeek", dayOfWeekAsString())
                .add("TargetCheckNames", hasTargetCheckNames() ? targetCheckNames() : null)
                .add("ScheduledAuditName", scheduledAuditName()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "frequency":
            return Optional.ofNullable(clazz.cast(frequencyAsString()));
        case "dayOfMonth":
            return Optional.ofNullable(clazz.cast(dayOfMonth()));
        case "dayOfWeek":
            return Optional.ofNullable(clazz.cast(dayOfWeekAsString()));
        case "targetCheckNames":
            return Optional.ofNullable(clazz.cast(targetCheckNames()));
        case "scheduledAuditName":
            return Optional.ofNullable(clazz.cast(scheduledAuditName()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateScheduledAuditRequest, T> g) {
        return obj -> g.apply((CreateScheduledAuditRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateScheduledAuditRequest> {
        /**
         * <p>
         * How often the scheduled audit takes place, either <code>DAILY</code>, <code>WEEKLY</code>,
         * <code>BIWEEKLY</code> or <code>MONTHLY</code>. The start time of each audit is determined by the system.
         * </p>
         * 
         * @param frequency
         *        How often the scheduled audit takes place, either <code>DAILY</code>, <code>WEEKLY</code>,
         *        <code>BIWEEKLY</code> or <code>MONTHLY</code>. The start time of each audit is determined by the
         *        system.
         * @see AuditFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditFrequency
         */
        Builder frequency(String frequency);

        /**
         * <p>
         * How often the scheduled audit takes place, either <code>DAILY</code>, <code>WEEKLY</code>,
         * <code>BIWEEKLY</code> or <code>MONTHLY</code>. The start time of each audit is determined by the system.
         * </p>
         * 
         * @param frequency
         *        How often the scheduled audit takes place, either <code>DAILY</code>, <code>WEEKLY</code>,
         *        <code>BIWEEKLY</code> or <code>MONTHLY</code>. The start time of each audit is determined by the
         *        system.
         * @see AuditFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditFrequency
         */
        Builder frequency(AuditFrequency frequency);

        /**
         * <p>
         * The day of the month on which the scheduled audit takes place. This can be "1" through "31" or "LAST". This
         * field is required if the "frequency" parameter is set to <code>MONTHLY</code>. If days 29 to 31 are
         * specified, and the month doesn't have that many days, the audit takes place on the <code>LAST</code> day of
         * the month.
         * </p>
         * 
         * @param dayOfMonth
         *        The day of the month on which the scheduled audit takes place. This can be "1" through "31" or "LAST".
         *        This field is required if the "frequency" parameter is set to <code>MONTHLY</code>. If days 29 to 31
         *        are specified, and the month doesn't have that many days, the audit takes place on the
         *        <code>LAST</code> day of the month.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dayOfMonth(String dayOfMonth);

        /**
         * <p>
         * The day of the week on which the scheduled audit takes place, either <code>SUN</code>, <code>MON</code>,
         * <code>TUE</code>, <code>WED</code>, <code>THU</code>, <code>FRI</code>, or <code>SAT</code>. This field is
         * required if the <code>frequency</code> parameter is set to <code>WEEKLY</code> or <code>BIWEEKLY</code>.
         * </p>
         * 
         * @param dayOfWeek
         *        The day of the week on which the scheduled audit takes place, either <code>SUN</code>,
         *        <code>MON</code>, <code>TUE</code>, <code>WED</code>, <code>THU</code>, <code>FRI</code>, or
         *        <code>SAT</code>. This field is required if the <code>frequency</code> parameter is set to
         *        <code>WEEKLY</code> or <code>BIWEEKLY</code>.
         * @see DayOfWeek
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DayOfWeek
         */
        Builder dayOfWeek(String dayOfWeek);

        /**
         * <p>
         * The day of the week on which the scheduled audit takes place, either <code>SUN</code>, <code>MON</code>,
         * <code>TUE</code>, <code>WED</code>, <code>THU</code>, <code>FRI</code>, or <code>SAT</code>. This field is
         * required if the <code>frequency</code> parameter is set to <code>WEEKLY</code> or <code>BIWEEKLY</code>.
         * </p>
         * 
         * @param dayOfWeek
         *        The day of the week on which the scheduled audit takes place, either <code>SUN</code>,
         *        <code>MON</code>, <code>TUE</code>, <code>WED</code>, <code>THU</code>, <code>FRI</code>, or
         *        <code>SAT</code>. This field is required if the <code>frequency</code> parameter is set to
         *        <code>WEEKLY</code> or <code>BIWEEKLY</code>.
         * @see DayOfWeek
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DayOfWeek
         */
        Builder dayOfWeek(DayOfWeek dayOfWeek);

        /**
         * <p>
         * Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use
         * <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are
         * enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)
         * </p>
         * 
         * @param targetCheckNames
         *        Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use
         *        <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are
         *        enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCheckNames(Collection<String> targetCheckNames);

        /**
         * <p>
         * Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use
         * <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are
         * enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)
         * </p>
         * 
         * @param targetCheckNames
         *        Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use
         *        <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are
         *        enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCheckNames(String... targetCheckNames);

        /**
         * <p>
         * The name you want to give to the scheduled audit. (Max. 128 chars)
         * </p>
         * 
         * @param scheduledAuditName
         *        The name you want to give to the scheduled audit. (Max. 128 chars)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledAuditName(String scheduledAuditName);

        /**
         * <p>
         * Metadata that can be used to manage the scheduled audit.
         * </p>
         * 
         * @param tags
         *        Metadata that can be used to manage the scheduled audit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Metadata that can be used to manage the scheduled audit.
         * </p>
         * 
         * @param tags
         *        Metadata that can be used to manage the scheduled audit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Metadata that can be used to manage the scheduled audit.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String frequency;

        private String dayOfMonth;

        private String dayOfWeek;

        private List<String> targetCheckNames = DefaultSdkAutoConstructList.getInstance();

        private String scheduledAuditName;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScheduledAuditRequest model) {
            super(model);
            frequency(model.frequency);
            dayOfMonth(model.dayOfMonth);
            dayOfWeek(model.dayOfWeek);
            targetCheckNames(model.targetCheckNames);
            scheduledAuditName(model.scheduledAuditName);
            tags(model.tags);
        }

        public final String getFrequency() {
            return frequency;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(AuditFrequency frequency) {
            this.frequency(frequency == null ? null : frequency.toString());
            return this;
        }

        public final String getDayOfMonth() {
            return dayOfMonth;
        }

        public final void setDayOfMonth(String dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
        }

        @Override
        public final Builder dayOfMonth(String dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        public final String getDayOfWeek() {
            return dayOfWeek;
        }

        public final void setDayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        @Override
        public final Builder dayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        @Override
        public final Builder dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek(dayOfWeek == null ? null : dayOfWeek.toString());
            return this;
        }

        public final Collection<String> getTargetCheckNames() {
            if (targetCheckNames instanceof SdkAutoConstructList) {
                return null;
            }
            return targetCheckNames;
        }

        public final void setTargetCheckNames(Collection<String> targetCheckNames) {
            this.targetCheckNames = TargetAuditCheckNamesCopier.copy(targetCheckNames);
        }

        @Override
        public final Builder targetCheckNames(Collection<String> targetCheckNames) {
            this.targetCheckNames = TargetAuditCheckNamesCopier.copy(targetCheckNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetCheckNames(String... targetCheckNames) {
            targetCheckNames(Arrays.asList(targetCheckNames));
            return this;
        }

        public final String getScheduledAuditName() {
            return scheduledAuditName;
        }

        public final void setScheduledAuditName(String scheduledAuditName) {
            this.scheduledAuditName = scheduledAuditName;
        }

        @Override
        public final Builder scheduledAuditName(String scheduledAuditName) {
            this.scheduledAuditName = scheduledAuditName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateScheduledAuditRequest build() {
            return new CreateScheduledAuditRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
