/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.ProvisioningHook;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProvisioningTemplateResponse
extends IotResponse
implements ToCopyableBuilder<Builder, DescribeProvisioningTemplateResponse> {
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateArn").getter(DescribeProvisioningTemplateResponse.getter(DescribeProvisioningTemplateResponse::templateArn)).setter(DescribeProvisioningTemplateResponse.setter(Builder::templateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateArn").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateName").getter(DescribeProvisioningTemplateResponse.getter(DescribeProvisioningTemplateResponse::templateName)).setter(DescribeProvisioningTemplateResponse.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(DescribeProvisioningTemplateResponse.getter(DescribeProvisioningTemplateResponse::description)).setter(DescribeProvisioningTemplateResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(DescribeProvisioningTemplateResponse.getter(DescribeProvisioningTemplateResponse::creationDate)).setter(DescribeProvisioningTemplateResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedDate").getter(DescribeProvisioningTemplateResponse.getter(DescribeProvisioningTemplateResponse::lastModifiedDate)).setter(DescribeProvisioningTemplateResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final SdkField<Integer> DEFAULT_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("defaultVersionId").getter(DescribeProvisioningTemplateResponse.getter(DescribeProvisioningTemplateResponse::defaultVersionId)).setter(DescribeProvisioningTemplateResponse.setter(Builder::defaultVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVersionId").build()}).build();
    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateBody").getter(DescribeProvisioningTemplateResponse.getter(DescribeProvisioningTemplateResponse::templateBody)).setter(DescribeProvisioningTemplateResponse.setter(Builder::templateBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateBody").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(DescribeProvisioningTemplateResponse.getter(DescribeProvisioningTemplateResponse::enabled)).setter(DescribeProvisioningTemplateResponse.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<String> PROVISIONING_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provisioningRoleArn").getter(DescribeProvisioningTemplateResponse.getter(DescribeProvisioningTemplateResponse::provisioningRoleArn)).setter(DescribeProvisioningTemplateResponse.setter(Builder::provisioningRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningRoleArn").build()}).build();
    private static final SdkField<ProvisioningHook> PRE_PROVISIONING_HOOK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("preProvisioningHook").getter(DescribeProvisioningTemplateResponse.getter(DescribeProvisioningTemplateResponse::preProvisioningHook)).setter(DescribeProvisioningTemplateResponse.setter(Builder::preProvisioningHook)).constructor(ProvisioningHook::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preProvisioningHook").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ARN_FIELD, TEMPLATE_NAME_FIELD, DESCRIPTION_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD, DEFAULT_VERSION_ID_FIELD, TEMPLATE_BODY_FIELD, ENABLED_FIELD, PROVISIONING_ROLE_ARN_FIELD, PRE_PROVISIONING_HOOK_FIELD));
    private final String templateArn;
    private final String templateName;
    private final String description;
    private final Instant creationDate;
    private final Instant lastModifiedDate;
    private final Integer defaultVersionId;
    private final String templateBody;
    private final Boolean enabled;
    private final String provisioningRoleArn;
    private final ProvisioningHook preProvisioningHook;

    private DescribeProvisioningTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.templateArn = builder.templateArn;
        this.templateName = builder.templateName;
        this.description = builder.description;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.defaultVersionId = builder.defaultVersionId;
        this.templateBody = builder.templateBody;
        this.enabled = builder.enabled;
        this.provisioningRoleArn = builder.provisioningRoleArn;
        this.preProvisioningHook = builder.preProvisioningHook;
    }

    public final String templateArn() {
        return this.templateArn;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final String description() {
        return this.description;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final Integer defaultVersionId() {
        return this.defaultVersionId;
    }

    public final String templateBody() {
        return this.templateBody;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String provisioningRoleArn() {
        return this.provisioningRoleArn;
    }

    public final ProvisioningHook preProvisioningHook() {
        return this.preProvisioningHook;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.preProvisioningHook());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProvisioningTemplateResponse)) {
            return false;
        }
        DescribeProvisioningTemplateResponse other = (DescribeProvisioningTemplateResponse)((Object)obj);
        return Objects.equals(this.templateArn(), other.templateArn()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.defaultVersionId(), other.defaultVersionId()) && Objects.equals(this.templateBody(), other.templateBody()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.provisioningRoleArn(), other.provisioningRoleArn()) && Objects.equals(this.preProvisioningHook(), other.preProvisioningHook());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeProvisioningTemplateResponse").add("TemplateArn", (Object)this.templateArn()).add("TemplateName", (Object)this.templateName()).add("Description", (Object)this.description()).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("DefaultVersionId", (Object)this.defaultVersionId()).add("TemplateBody", (Object)this.templateBody()).add("Enabled", (Object)this.enabled()).add("ProvisioningRoleArn", (Object)this.provisioningRoleArn()).add("PreProvisioningHook", (Object)this.preProvisioningHook()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "templateArn": {
                return Optional.ofNullable(clazz.cast(this.templateArn()));
            }
            case "templateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "defaultVersionId": {
                return Optional.ofNullable(clazz.cast(this.defaultVersionId()));
            }
            case "templateBody": {
                return Optional.ofNullable(clazz.cast(this.templateBody()));
            }
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "provisioningRoleArn": {
                return Optional.ofNullable(clazz.cast(this.provisioningRoleArn()));
            }
            case "preProvisioningHook": {
                return Optional.ofNullable(clazz.cast(this.preProvisioningHook()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProvisioningTemplateResponse, T> g) {
        return obj -> g.apply((DescribeProvisioningTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String templateArn;
        private String templateName;
        private String description;
        private Instant creationDate;
        private Instant lastModifiedDate;
        private Integer defaultVersionId;
        private String templateBody;
        private Boolean enabled;
        private String provisioningRoleArn;
        private ProvisioningHook preProvisioningHook;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProvisioningTemplateResponse model) {
            super(model);
            this.templateArn(model.templateArn);
            this.templateName(model.templateName);
            this.description(model.description);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
            this.defaultVersionId(model.defaultVersionId);
            this.templateBody(model.templateBody);
            this.enabled(model.enabled);
            this.provisioningRoleArn(model.provisioningRoleArn);
            this.preProvisioningHook(model.preProvisioningHook);
        }

        public final String getTemplateArn() {
            return this.templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final Integer getDefaultVersionId() {
            return this.defaultVersionId;
        }

        public final void setDefaultVersionId(Integer defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
        }

        @Override
        public final Builder defaultVersionId(Integer defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
            return this;
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getProvisioningRoleArn() {
            return this.provisioningRoleArn;
        }

        public final void setProvisioningRoleArn(String provisioningRoleArn) {
            this.provisioningRoleArn = provisioningRoleArn;
        }

        @Override
        public final Builder provisioningRoleArn(String provisioningRoleArn) {
            this.provisioningRoleArn = provisioningRoleArn;
            return this;
        }

        public final ProvisioningHook.Builder getPreProvisioningHook() {
            return this.preProvisioningHook != null ? this.preProvisioningHook.toBuilder() : null;
        }

        public final void setPreProvisioningHook(ProvisioningHook.BuilderImpl preProvisioningHook) {
            this.preProvisioningHook = preProvisioningHook != null ? preProvisioningHook.build() : null;
        }

        @Override
        public final Builder preProvisioningHook(ProvisioningHook preProvisioningHook) {
            this.preProvisioningHook = preProvisioningHook;
            return this;
        }

        @Override
        public DescribeProvisioningTemplateResponse build() {
            return new DescribeProvisioningTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeProvisioningTemplateResponse> {
        public Builder templateArn(String var1);

        public Builder templateName(String var1);

        public Builder description(String var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder defaultVersionId(Integer var1);

        public Builder templateBody(String var1);

        public Builder enabled(Boolean var1);

        public Builder provisioningRoleArn(String var1);

        public Builder preProvisioningHook(ProvisioningHook var1);

        default public Builder preProvisioningHook(Consumer<ProvisioningHook.Builder> preProvisioningHook) {
            return this.preProvisioningHook((ProvisioningHook)((ProvisioningHook.Builder)ProvisioningHook.builder().applyMutation(preProvisioningHook)).build());
        }
    }
}

