/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAuditSuppressionRequest extends IotRequest implements
        ToCopyableBuilder<DeleteAuditSuppressionRequest.Builder, DeleteAuditSuppressionRequest> {
    private static final SdkField<String> CHECK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("checkName").getter(getter(DeleteAuditSuppressionRequest::checkName)).setter(setter(Builder::checkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkName").build()).build();

    private static final SdkField<ResourceIdentifier> RESOURCE_IDENTIFIER_FIELD = SdkField
            .<ResourceIdentifier> builder(MarshallingType.SDK_POJO).memberName("resourceIdentifier")
            .getter(getter(DeleteAuditSuppressionRequest::resourceIdentifier)).setter(setter(Builder::resourceIdentifier))
            .constructor(ResourceIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECK_NAME_FIELD,
            RESOURCE_IDENTIFIER_FIELD));

    private final String checkName;

    private final ResourceIdentifier resourceIdentifier;

    private DeleteAuditSuppressionRequest(BuilderImpl builder) {
        super(builder);
        this.checkName = builder.checkName;
        this.resourceIdentifier = builder.resourceIdentifier;
    }

    /**
     * Returns the value of the CheckName property for this object.
     * 
     * @return The value of the CheckName property for this object.
     */
    public final String checkName() {
        return checkName;
    }

    /**
     * Returns the value of the ResourceIdentifier property for this object.
     * 
     * @return The value of the ResourceIdentifier property for this object.
     */
    public final ResourceIdentifier resourceIdentifier() {
        return resourceIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(checkName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAuditSuppressionRequest)) {
            return false;
        }
        DeleteAuditSuppressionRequest other = (DeleteAuditSuppressionRequest) obj;
        return Objects.equals(checkName(), other.checkName()) && Objects.equals(resourceIdentifier(), other.resourceIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAuditSuppressionRequest").add("CheckName", checkName())
                .add("ResourceIdentifier", resourceIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "checkName":
            return Optional.ofNullable(clazz.cast(checkName()));
        case "resourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAuditSuppressionRequest, T> g) {
        return obj -> g.apply((DeleteAuditSuppressionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteAuditSuppressionRequest> {
        /**
         * Sets the value of the CheckName property for this object.
         *
         * @param checkName
         *        The new value for the CheckName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkName(String checkName);

        /**
         * Sets the value of the ResourceIdentifier property for this object.
         *
         * @param resourceIdentifier
         *        The new value for the ResourceIdentifier property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(ResourceIdentifier resourceIdentifier);

        /**
         * Sets the value of the ResourceIdentifier property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResourceIdentifier.Builder} avoiding the
         * need to create one manually via {@link ResourceIdentifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceIdentifier(ResourceIdentifier)}.
         * 
         * @param resourceIdentifier
         *        a consumer that will call methods on {@link ResourceIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceIdentifier(ResourceIdentifier)
         */
        default Builder resourceIdentifier(Consumer<ResourceIdentifier.Builder> resourceIdentifier) {
            return resourceIdentifier(ResourceIdentifier.builder().applyMutation(resourceIdentifier).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String checkName;

        private ResourceIdentifier resourceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAuditSuppressionRequest model) {
            super(model);
            checkName(model.checkName);
            resourceIdentifier(model.resourceIdentifier);
        }

        public final String getCheckName() {
            return checkName;
        }

        public final void setCheckName(String checkName) {
            this.checkName = checkName;
        }

        @Override
        public final Builder checkName(String checkName) {
            this.checkName = checkName;
            return this;
        }

        public final ResourceIdentifier.Builder getResourceIdentifier() {
            return resourceIdentifier != null ? resourceIdentifier.toBuilder() : null;
        }

        public final void setResourceIdentifier(ResourceIdentifier.BuilderImpl resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier != null ? resourceIdentifier.build() : null;
        }

        @Override
        public final Builder resourceIdentifier(ResourceIdentifier resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAuditSuppressionRequest build() {
            return new DeleteAuditSuppressionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
