/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDomainConfigurationsResponse extends IotResponse implements
        ToCopyableBuilder<ListDomainConfigurationsResponse.Builder, ListDomainConfigurationsResponse> {
    private static final SdkField<List<DomainConfigurationSummary>> DOMAIN_CONFIGURATIONS_FIELD = SdkField
            .<List<DomainConfigurationSummary>> builder(MarshallingType.LIST)
            .memberName("domainConfigurations")
            .getter(getter(ListDomainConfigurationsResponse::domainConfigurations))
            .setter(setter(Builder::domainConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainConfigurationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainConfigurationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextMarker").getter(getter(ListDomainConfigurationsResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_CONFIGURATIONS_FIELD,
            NEXT_MARKER_FIELD));

    private final List<DomainConfigurationSummary> domainConfigurations;

    private final String nextMarker;

    private ListDomainConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.domainConfigurations = builder.domainConfigurations;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDomainConfigurations() {
        return domainConfigurations != null && !(domainConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects that contain summary information about the user's domain configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainConfigurations} method.
     * </p>
     * 
     * @return A list of objects that contain summary information about the user's domain configurations.
     */
    public final List<DomainConfigurationSummary> domainConfigurations() {
        return domainConfigurations;
    }

    /**
     * <p>
     * The marker for the next set of results.
     * </p>
     * 
     * @return The marker for the next set of results.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainConfigurations() ? domainConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainConfigurationsResponse)) {
            return false;
        }
        ListDomainConfigurationsResponse other = (ListDomainConfigurationsResponse) obj;
        return hasDomainConfigurations() == other.hasDomainConfigurations()
                && Objects.equals(domainConfigurations(), other.domainConfigurations())
                && Objects.equals(nextMarker(), other.nextMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDomainConfigurationsResponse")
                .add("DomainConfigurations", hasDomainConfigurations() ? domainConfigurations() : null)
                .add("NextMarker", nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainConfigurations":
            return Optional.ofNullable(clazz.cast(domainConfigurations()));
        case "nextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDomainConfigurationsResponse, T> g) {
        return obj -> g.apply((ListDomainConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDomainConfigurationsResponse> {
        /**
         * <p>
         * A list of objects that contain summary information about the user's domain configurations.
         * </p>
         * 
         * @param domainConfigurations
         *        A list of objects that contain summary information about the user's domain configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainConfigurations(Collection<DomainConfigurationSummary> domainConfigurations);

        /**
         * <p>
         * A list of objects that contain summary information about the user's domain configurations.
         * </p>
         * 
         * @param domainConfigurations
         *        A list of objects that contain summary information about the user's domain configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainConfigurations(DomainConfigurationSummary... domainConfigurations);

        /**
         * <p>
         * A list of objects that contain summary information about the user's domain configurations.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<DomainConfigurationSummary>.Builder}
         * avoiding the need to create one manually via {@link List<DomainConfigurationSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DomainConfigurationSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #domainConfigurations(List<DomainConfigurationSummary>)}.
         * 
         * @param domainConfigurations
         *        a consumer that will call methods on {@link List<DomainConfigurationSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainConfigurations(List<DomainConfigurationSummary>)
         */
        Builder domainConfigurations(Consumer<DomainConfigurationSummary.Builder>... domainConfigurations);

        /**
         * <p>
         * The marker for the next set of results.
         * </p>
         * 
         * @param nextMarker
         *        The marker for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<DomainConfigurationSummary> domainConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainConfigurationsResponse model) {
            super(model);
            domainConfigurations(model.domainConfigurations);
            nextMarker(model.nextMarker);
        }

        public final List<DomainConfigurationSummary.Builder> getDomainConfigurations() {
            List<DomainConfigurationSummary.Builder> result = DomainConfigurationsCopier.copyToBuilder(this.domainConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainConfigurations(Collection<DomainConfigurationSummary.BuilderImpl> domainConfigurations) {
            this.domainConfigurations = DomainConfigurationsCopier.copyFromBuilder(domainConfigurations);
        }

        @Override
        public final Builder domainConfigurations(Collection<DomainConfigurationSummary> domainConfigurations) {
            this.domainConfigurations = DomainConfigurationsCopier.copy(domainConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainConfigurations(DomainConfigurationSummary... domainConfigurations) {
            domainConfigurations(Arrays.asList(domainConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainConfigurations(Consumer<DomainConfigurationSummary.Builder>... domainConfigurations) {
            domainConfigurations(Stream.of(domainConfigurations)
                    .map(c -> DomainConfigurationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public ListDomainConfigurationsResponse build() {
            return new ListDomainConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
