/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Thing group metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThingGroupMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ThingGroupMetadata.Builder, ThingGroupMetadata> {
    private static final SdkField<String> PARENT_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentGroupName").getter(getter(ThingGroupMetadata::parentGroupName))
            .setter(setter(Builder::parentGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentGroupName").build()).build();

    private static final SdkField<List<GroupNameAndArn>> ROOT_TO_PARENT_THING_GROUPS_FIELD = SdkField
            .<List<GroupNameAndArn>> builder(MarshallingType.LIST)
            .memberName("rootToParentThingGroups")
            .getter(getter(ThingGroupMetadata::rootToParentThingGroups))
            .setter(setter(Builder::rootToParentThingGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootToParentThingGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupNameAndArn> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupNameAndArn::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(ThingGroupMetadata::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARENT_GROUP_NAME_FIELD,
            ROOT_TO_PARENT_THING_GROUPS_FIELD, CREATION_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String parentGroupName;

    private final List<GroupNameAndArn> rootToParentThingGroups;

    private final Instant creationDate;

    private ThingGroupMetadata(BuilderImpl builder) {
        this.parentGroupName = builder.parentGroupName;
        this.rootToParentThingGroups = builder.rootToParentThingGroups;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The parent thing group name.
     * </p>
     * 
     * @return The parent thing group name.
     */
    public final String parentGroupName() {
        return parentGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the RootToParentThingGroups property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRootToParentThingGroups() {
        return rootToParentThingGroups != null && !(rootToParentThingGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The root parent thing group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRootToParentThingGroups} method.
     * </p>
     * 
     * @return The root parent thing group.
     */
    public final List<GroupNameAndArn> rootToParentThingGroups() {
        return rootToParentThingGroups;
    }

    /**
     * <p>
     * The UNIX timestamp of when the thing group was created.
     * </p>
     * 
     * @return The UNIX timestamp of when the thing group was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasRootToParentThingGroups() ? rootToParentThingGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingGroupMetadata)) {
            return false;
        }
        ThingGroupMetadata other = (ThingGroupMetadata) obj;
        return Objects.equals(parentGroupName(), other.parentGroupName())
                && hasRootToParentThingGroups() == other.hasRootToParentThingGroups()
                && Objects.equals(rootToParentThingGroups(), other.rootToParentThingGroups())
                && Objects.equals(creationDate(), other.creationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThingGroupMetadata").add("ParentGroupName", parentGroupName())
                .add("RootToParentThingGroups", hasRootToParentThingGroups() ? rootToParentThingGroups() : null)
                .add("CreationDate", creationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "parentGroupName":
            return Optional.ofNullable(clazz.cast(parentGroupName()));
        case "rootToParentThingGroups":
            return Optional.ofNullable(clazz.cast(rootToParentThingGroups()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThingGroupMetadata, T> g) {
        return obj -> g.apply((ThingGroupMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThingGroupMetadata> {
        /**
         * <p>
         * The parent thing group name.
         * </p>
         * 
         * @param parentGroupName
         *        The parent thing group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentGroupName(String parentGroupName);

        /**
         * <p>
         * The root parent thing group.
         * </p>
         * 
         * @param rootToParentThingGroups
         *        The root parent thing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootToParentThingGroups(Collection<GroupNameAndArn> rootToParentThingGroups);

        /**
         * <p>
         * The root parent thing group.
         * </p>
         * 
         * @param rootToParentThingGroups
         *        The root parent thing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootToParentThingGroups(GroupNameAndArn... rootToParentThingGroups);

        /**
         * <p>
         * The root parent thing group.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<GroupNameAndArn>.Builder} avoiding
         * the need to create one manually via {@link List<GroupNameAndArn>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GroupNameAndArn>.Builder#build()} is called immediately and
         * its result is passed to {@link #rootToParentThingGroups(List<GroupNameAndArn>)}.
         * 
         * @param rootToParentThingGroups
         *        a consumer that will call methods on {@link List<GroupNameAndArn>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rootToParentThingGroups(List<GroupNameAndArn>)
         */
        Builder rootToParentThingGroups(Consumer<GroupNameAndArn.Builder>... rootToParentThingGroups);

        /**
         * <p>
         * The UNIX timestamp of when the thing group was created.
         * </p>
         * 
         * @param creationDate
         *        The UNIX timestamp of when the thing group was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl implements Builder {
        private String parentGroupName;

        private List<GroupNameAndArn> rootToParentThingGroups = DefaultSdkAutoConstructList.getInstance();

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingGroupMetadata model) {
            parentGroupName(model.parentGroupName);
            rootToParentThingGroups(model.rootToParentThingGroups);
            creationDate(model.creationDate);
        }

        public final String getParentGroupName() {
            return parentGroupName;
        }

        public final void setParentGroupName(String parentGroupName) {
            this.parentGroupName = parentGroupName;
        }

        @Override
        public final Builder parentGroupName(String parentGroupName) {
            this.parentGroupName = parentGroupName;
            return this;
        }

        public final List<GroupNameAndArn.Builder> getRootToParentThingGroups() {
            List<GroupNameAndArn.Builder> result = ThingGroupNameAndArnListCopier.copyToBuilder(this.rootToParentThingGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRootToParentThingGroups(Collection<GroupNameAndArn.BuilderImpl> rootToParentThingGroups) {
            this.rootToParentThingGroups = ThingGroupNameAndArnListCopier.copyFromBuilder(rootToParentThingGroups);
        }

        @Override
        public final Builder rootToParentThingGroups(Collection<GroupNameAndArn> rootToParentThingGroups) {
            this.rootToParentThingGroups = ThingGroupNameAndArnListCopier.copy(rootToParentThingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rootToParentThingGroups(GroupNameAndArn... rootToParentThingGroups) {
            rootToParentThingGroups(Arrays.asList(rootToParentThingGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rootToParentThingGroups(Consumer<GroupNameAndArn.Builder>... rootToParentThingGroups) {
            rootToParentThingGroups(Stream.of(rootToParentThingGroups)
                    .map(c -> GroupNameAndArn.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        @Override
        public ThingGroupMetadata build() {
            return new ThingGroupMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
