/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action that writes data to an Amazon Elasticsearch Service domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ElasticsearchAction implements SdkPojo, Serializable,
        ToCopyableBuilder<ElasticsearchAction.Builder, ElasticsearchAction> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(ElasticsearchAction::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpoint").getter(getter(ElasticsearchAction::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();

    private static final SdkField<String> INDEX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("index")
            .getter(getter(ElasticsearchAction::index)).setter(setter(Builder::index))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("index").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ElasticsearchAction::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ElasticsearchAction::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            ENDPOINT_FIELD, INDEX_FIELD, TYPE_FIELD, ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String endpoint;

    private final String index;

    private final String type;

    private final String id;

    private ElasticsearchAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.endpoint = builder.endpoint;
        this.index = builder.index;
        this.type = builder.type;
        this.id = builder.id;
    }

    /**
     * <p>
     * The IAM role ARN that has access to Elasticsearch.
     * </p>
     * 
     * @return The IAM role ARN that has access to Elasticsearch.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The endpoint of your Elasticsearch domain.
     * </p>
     * 
     * @return The endpoint of your Elasticsearch domain.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The Elasticsearch index where you want to store your data.
     * </p>
     * 
     * @return The Elasticsearch index where you want to store your data.
     */
    public final String index() {
        return index;
    }

    /**
     * <p>
     * The type of document you are storing.
     * </p>
     * 
     * @return The type of document you are storing.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The unique identifier for the document you are storing.
     * </p>
     * 
     * @return The unique identifier for the document you are storing.
     */
    public final String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(index());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchAction)) {
            return false;
        }
        ElasticsearchAction other = (ElasticsearchAction) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(endpoint(), other.endpoint())
                && Objects.equals(index(), other.index()) && Objects.equals(type(), other.type())
                && Objects.equals(id(), other.id());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ElasticsearchAction").add("RoleArn", roleArn()).add("Endpoint", endpoint())
                .add("Index", index()).add("Type", type()).add("Id", id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "index":
            return Optional.ofNullable(clazz.cast(index()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ElasticsearchAction, T> g) {
        return obj -> g.apply((ElasticsearchAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ElasticsearchAction> {
        /**
         * <p>
         * The IAM role ARN that has access to Elasticsearch.
         * </p>
         * 
         * @param roleArn
         *        The IAM role ARN that has access to Elasticsearch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The endpoint of your Elasticsearch domain.
         * </p>
         * 
         * @param endpoint
         *        The endpoint of your Elasticsearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The Elasticsearch index where you want to store your data.
         * </p>
         * 
         * @param index
         *        The Elasticsearch index where you want to store your data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder index(String index);

        /**
         * <p>
         * The type of document you are storing.
         * </p>
         * 
         * @param type
         *        The type of document you are storing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The unique identifier for the document you are storing.
         * </p>
         * 
         * @param id
         *        The unique identifier for the document you are storing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String endpoint;

        private String index;

        private String type;

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchAction model) {
            roleArn(model.roleArn);
            endpoint(model.endpoint);
            index(model.index);
            type(model.type);
            id(model.id);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        @Transient
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getIndex() {
            return index;
        }

        public final void setIndex(String index) {
            this.index = index;
        }

        @Override
        @Transient
        public final Builder index(String index) {
            this.index = index;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public ElasticsearchAction build() {
            return new ElasticsearchAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
