/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSecurityProfilesForTargetRequest extends IotRequest implements
        ToCopyableBuilder<ListSecurityProfilesForTargetRequest.Builder, ListSecurityProfilesForTargetRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSecurityProfilesForTargetRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListSecurityProfilesForTargetRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<Boolean> RECURSIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("recursive").getter(getter(ListSecurityProfilesForTargetRequest::recursive))
            .setter(setter(Builder::recursive))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("recursive").build()).build();

    private static final SdkField<String> SECURITY_PROFILE_TARGET_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("securityProfileTargetArn")
            .getter(getter(ListSecurityProfilesForTargetRequest::securityProfileTargetArn))
            .setter(setter(Builder::securityProfileTargetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("securityProfileTargetArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, RECURSIVE_FIELD, SECURITY_PROFILE_TARGET_ARN_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final Boolean recursive;

    private final String securityProfileTargetArn;

    private ListSecurityProfilesForTargetRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.recursive = builder.recursive;
        this.securityProfileTargetArn = builder.securityProfileTargetArn;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return at one time.
     * </p>
     * 
     * @return The maximum number of results to return at one time.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If true, return child groups too.
     * </p>
     * 
     * @return If true, return child groups too.
     */
    public final Boolean recursive() {
        return recursive;
    }

    /**
     * <p>
     * The ARN of the target (thing group) whose attached security profiles you want to get.
     * </p>
     * 
     * @return The ARN of the target (thing group) whose attached security profiles you want to get.
     */
    public final String securityProfileTargetArn() {
        return securityProfileTargetArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(recursive());
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileTargetArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityProfilesForTargetRequest)) {
            return false;
        }
        ListSecurityProfilesForTargetRequest other = (ListSecurityProfilesForTargetRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(recursive(), other.recursive())
                && Objects.equals(securityProfileTargetArn(), other.securityProfileTargetArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSecurityProfilesForTargetRequest").add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("Recursive", recursive())
                .add("SecurityProfileTargetArn", securityProfileTargetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "recursive":
            return Optional.ofNullable(clazz.cast(recursive()));
        case "securityProfileTargetArn":
            return Optional.ofNullable(clazz.cast(securityProfileTargetArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSecurityProfilesForTargetRequest, T> g) {
        return obj -> g.apply((ListSecurityProfilesForTargetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSecurityProfilesForTargetRequest> {
        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return at one time.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return at one time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If true, return child groups too.
         * </p>
         * 
         * @param recursive
         *        If true, return child groups too.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recursive(Boolean recursive);

        /**
         * <p>
         * The ARN of the target (thing group) whose attached security profiles you want to get.
         * </p>
         * 
         * @param securityProfileTargetArn
         *        The ARN of the target (thing group) whose attached security profiles you want to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileTargetArn(String securityProfileTargetArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private Boolean recursive;

        private String securityProfileTargetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityProfilesForTargetRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            recursive(model.recursive);
            securityProfileTargetArn(model.securityProfileTargetArn);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Boolean getRecursive() {
            return recursive;
        }

        public final void setRecursive(Boolean recursive) {
            this.recursive = recursive;
        }

        @Override
        @Transient
        public final Builder recursive(Boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public final String getSecurityProfileTargetArn() {
            return securityProfileTargetArn;
        }

        public final void setSecurityProfileTargetArn(String securityProfileTargetArn) {
            this.securityProfileTargetArn = securityProfileTargetArn;
        }

        @Override
        @Transient
        public final Builder securityProfileTargetArn(String securityProfileTargetArn) {
            this.securityProfileTargetArn = securityProfileTargetArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSecurityProfilesForTargetRequest build() {
            return new ListSecurityProfilesForTargetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
