/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.DetectMitigationActionExecution;
import software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsRequest;
import software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsResponse;

public class ListDetectMitigationActionsExecutionsIterable
implements SdkIterable<ListDetectMitigationActionsExecutionsResponse> {
    private final IotClient client;
    private final ListDetectMitigationActionsExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDetectMitigationActionsExecutionsIterable(IotClient client, ListDetectMitigationActionsExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDetectMitigationActionsExecutionsResponseFetcher();
    }

    public Iterator<ListDetectMitigationActionsExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DetectMitigationActionExecution> actionsExecutions() {
        Function<ListDetectMitigationActionsExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.actionsExecutions() != null) {
                return response.actionsExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDetectMitigationActionsExecutionsResponseFetcher
    implements SyncPageFetcher<ListDetectMitigationActionsExecutionsResponse> {
        private ListDetectMitigationActionsExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDetectMitigationActionsExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDetectMitigationActionsExecutionsResponse nextPage(ListDetectMitigationActionsExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListDetectMitigationActionsExecutionsIterable.this.client.listDetectMitigationActionsExecutions(ListDetectMitigationActionsExecutionsIterable.this.firstRequest);
            }
            return ListDetectMitigationActionsExecutionsIterable.this.client.listDetectMitigationActionsExecutions((ListDetectMitigationActionsExecutionsRequest)((Object)ListDetectMitigationActionsExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

