/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the method to use when code signing a file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeSigning implements SdkPojo, Serializable, ToCopyableBuilder<CodeSigning.Builder, CodeSigning> {
    private static final SdkField<String> AWS_SIGNER_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsSignerJobId").getter(getter(CodeSigning::awsSignerJobId)).setter(setter(Builder::awsSignerJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsSignerJobId").build()).build();

    private static final SdkField<StartSigningJobParameter> START_SIGNING_JOB_PARAMETER_FIELD = SdkField
            .<StartSigningJobParameter> builder(MarshallingType.SDK_POJO).memberName("startSigningJobParameter")
            .getter(getter(CodeSigning::startSigningJobParameter)).setter(setter(Builder::startSigningJobParameter))
            .constructor(StartSigningJobParameter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startSigningJobParameter").build())
            .build();

    private static final SdkField<CustomCodeSigning> CUSTOM_CODE_SIGNING_FIELD = SdkField
            .<CustomCodeSigning> builder(MarshallingType.SDK_POJO).memberName("customCodeSigning")
            .getter(getter(CodeSigning::customCodeSigning)).setter(setter(Builder::customCodeSigning))
            .constructor(CustomCodeSigning::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customCodeSigning").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_SIGNER_JOB_ID_FIELD,
            START_SIGNING_JOB_PARAMETER_FIELD, CUSTOM_CODE_SIGNING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String awsSignerJobId;

    private final StartSigningJobParameter startSigningJobParameter;

    private final CustomCodeSigning customCodeSigning;

    private CodeSigning(BuilderImpl builder) {
        this.awsSignerJobId = builder.awsSignerJobId;
        this.startSigningJobParameter = builder.startSigningJobParameter;
        this.customCodeSigning = builder.customCodeSigning;
    }

    /**
     * <p>
     * The ID of the <code>AWSSignerJob</code> which was created to sign the file.
     * </p>
     * 
     * @return The ID of the <code>AWSSignerJob</code> which was created to sign the file.
     */
    public final String awsSignerJobId() {
        return awsSignerJobId;
    }

    /**
     * <p>
     * Describes the code-signing job.
     * </p>
     * 
     * @return Describes the code-signing job.
     */
    public final StartSigningJobParameter startSigningJobParameter() {
        return startSigningJobParameter;
    }

    /**
     * <p>
     * A custom method for code signing a file.
     * </p>
     * 
     * @return A custom method for code signing a file.
     */
    public final CustomCodeSigning customCodeSigning() {
        return customCodeSigning;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsSignerJobId());
        hashCode = 31 * hashCode + Objects.hashCode(startSigningJobParameter());
        hashCode = 31 * hashCode + Objects.hashCode(customCodeSigning());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeSigning)) {
            return false;
        }
        CodeSigning other = (CodeSigning) obj;
        return Objects.equals(awsSignerJobId(), other.awsSignerJobId())
                && Objects.equals(startSigningJobParameter(), other.startSigningJobParameter())
                && Objects.equals(customCodeSigning(), other.customCodeSigning());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeSigning").add("AwsSignerJobId", awsSignerJobId())
                .add("StartSigningJobParameter", startSigningJobParameter()).add("CustomCodeSigning", customCodeSigning())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsSignerJobId":
            return Optional.ofNullable(clazz.cast(awsSignerJobId()));
        case "startSigningJobParameter":
            return Optional.ofNullable(clazz.cast(startSigningJobParameter()));
        case "customCodeSigning":
            return Optional.ofNullable(clazz.cast(customCodeSigning()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeSigning, T> g) {
        return obj -> g.apply((CodeSigning) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeSigning> {
        /**
         * <p>
         * The ID of the <code>AWSSignerJob</code> which was created to sign the file.
         * </p>
         * 
         * @param awsSignerJobId
         *        The ID of the <code>AWSSignerJob</code> which was created to sign the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsSignerJobId(String awsSignerJobId);

        /**
         * <p>
         * Describes the code-signing job.
         * </p>
         * 
         * @param startSigningJobParameter
         *        Describes the code-signing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startSigningJobParameter(StartSigningJobParameter startSigningJobParameter);

        /**
         * <p>
         * Describes the code-signing job.
         * </p>
         * This is a convenience method that creates an instance of the {@link StartSigningJobParameter.Builder}
         * avoiding the need to create one manually via {@link StartSigningJobParameter#builder()}.
         *
         * When the {@link Consumer} completes, {@link StartSigningJobParameter.Builder#build()} is called immediately
         * and its result is passed to {@link #startSigningJobParameter(StartSigningJobParameter)}.
         * 
         * @param startSigningJobParameter
         *        a consumer that will call methods on {@link StartSigningJobParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startSigningJobParameter(StartSigningJobParameter)
         */
        default Builder startSigningJobParameter(Consumer<StartSigningJobParameter.Builder> startSigningJobParameter) {
            return startSigningJobParameter(StartSigningJobParameter.builder().applyMutation(startSigningJobParameter).build());
        }

        /**
         * <p>
         * A custom method for code signing a file.
         * </p>
         * 
         * @param customCodeSigning
         *        A custom method for code signing a file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customCodeSigning(CustomCodeSigning customCodeSigning);

        /**
         * <p>
         * A custom method for code signing a file.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomCodeSigning.Builder} avoiding the
         * need to create one manually via {@link CustomCodeSigning#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomCodeSigning.Builder#build()} is called immediately and its
         * result is passed to {@link #customCodeSigning(CustomCodeSigning)}.
         * 
         * @param customCodeSigning
         *        a consumer that will call methods on {@link CustomCodeSigning.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customCodeSigning(CustomCodeSigning)
         */
        default Builder customCodeSigning(Consumer<CustomCodeSigning.Builder> customCodeSigning) {
            return customCodeSigning(CustomCodeSigning.builder().applyMutation(customCodeSigning).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String awsSignerJobId;

        private StartSigningJobParameter startSigningJobParameter;

        private CustomCodeSigning customCodeSigning;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeSigning model) {
            awsSignerJobId(model.awsSignerJobId);
            startSigningJobParameter(model.startSigningJobParameter);
            customCodeSigning(model.customCodeSigning);
        }

        public final String getAwsSignerJobId() {
            return awsSignerJobId;
        }

        public final void setAwsSignerJobId(String awsSignerJobId) {
            this.awsSignerJobId = awsSignerJobId;
        }

        @Override
        public final Builder awsSignerJobId(String awsSignerJobId) {
            this.awsSignerJobId = awsSignerJobId;
            return this;
        }

        public final StartSigningJobParameter.Builder getStartSigningJobParameter() {
            return startSigningJobParameter != null ? startSigningJobParameter.toBuilder() : null;
        }

        public final void setStartSigningJobParameter(StartSigningJobParameter.BuilderImpl startSigningJobParameter) {
            this.startSigningJobParameter = startSigningJobParameter != null ? startSigningJobParameter.build() : null;
        }

        @Override
        public final Builder startSigningJobParameter(StartSigningJobParameter startSigningJobParameter) {
            this.startSigningJobParameter = startSigningJobParameter;
            return this;
        }

        public final CustomCodeSigning.Builder getCustomCodeSigning() {
            return customCodeSigning != null ? customCodeSigning.toBuilder() : null;
        }

        public final void setCustomCodeSigning(CustomCodeSigning.BuilderImpl customCodeSigning) {
            this.customCodeSigning = customCodeSigning != null ? customCodeSigning.build() : null;
        }

        @Override
        public final Builder customCodeSigning(CustomCodeSigning customCodeSigning) {
            this.customCodeSigning = customCodeSigning;
            return this;
        }

        @Override
        public CodeSigning build() {
            return new CodeSigning(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
