/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the DescribeThing operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeThingResponse extends IotResponse implements
        ToCopyableBuilder<DescribeThingResponse.Builder, DescribeThingResponse> {
    private static final SdkField<String> DEFAULT_CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultClientId").getter(getter(DescribeThingResponse::defaultClientId))
            .setter(setter(Builder::defaultClientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultClientId").build()).build();

    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(DescribeThingResponse::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()).build();

    private static final SdkField<String> THING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingId").getter(getter(DescribeThingResponse::thingId)).setter(setter(Builder::thingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingId").build()).build();

    private static final SdkField<String> THING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingArn").getter(getter(DescribeThingResponse::thingArn)).setter(setter(Builder::thingArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingArn").build()).build();

    private static final SdkField<String> THING_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingTypeName").getter(getter(DescribeThingResponse::thingTypeName))
            .setter(setter(Builder::thingTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeName").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("attributes")
            .getter(getter(DescribeThingResponse::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("version")
            .getter(getter(DescribeThingResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> BILLING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingGroupName").getter(getter(DescribeThingResponse::billingGroupName))
            .setter(setter(Builder::billingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingGroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_CLIENT_ID_FIELD,
            THING_NAME_FIELD, THING_ID_FIELD, THING_ARN_FIELD, THING_TYPE_NAME_FIELD, ATTRIBUTES_FIELD, VERSION_FIELD,
            BILLING_GROUP_NAME_FIELD));

    private final String defaultClientId;

    private final String thingName;

    private final String thingId;

    private final String thingArn;

    private final String thingTypeName;

    private final Map<String, String> attributes;

    private final Long version;

    private final String billingGroupName;

    private DescribeThingResponse(BuilderImpl builder) {
        super(builder);
        this.defaultClientId = builder.defaultClientId;
        this.thingName = builder.thingName;
        this.thingId = builder.thingId;
        this.thingArn = builder.thingArn;
        this.thingTypeName = builder.thingTypeName;
        this.attributes = builder.attributes;
        this.version = builder.version;
        this.billingGroupName = builder.billingGroupName;
    }

    /**
     * <p>
     * The default MQTT client ID. For a typical device, the thing name is also used as the default MQTT client ID.
     * Although we don’t require a mapping between a thing's registry name and its use of MQTT client IDs, certificates,
     * or shadow state, we recommend that you choose a thing name and use it as the MQTT client ID for the registry and
     * the Device Shadow service.
     * </p>
     * <p>
     * This lets you better organize your AWS IoT fleet without removing the flexibility of the underlying device
     * certificate model or shadows.
     * </p>
     * 
     * @return The default MQTT client ID. For a typical device, the thing name is also used as the default MQTT client
     *         ID. Although we don’t require a mapping between a thing's registry name and its use of MQTT client IDs,
     *         certificates, or shadow state, we recommend that you choose a thing name and use it as the MQTT client ID
     *         for the registry and the Device Shadow service.</p>
     *         <p>
     *         This lets you better organize your AWS IoT fleet without removing the flexibility of the underlying
     *         device certificate model or shadows.
     */
    public final String defaultClientId() {
        return defaultClientId;
    }

    /**
     * <p>
     * The name of the thing.
     * </p>
     * 
     * @return The name of the thing.
     */
    public final String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The ID of the thing to describe.
     * </p>
     * 
     * @return The ID of the thing to describe.
     */
    public final String thingId() {
        return thingId;
    }

    /**
     * <p>
     * The ARN of the thing to describe.
     * </p>
     * 
     * @return The ARN of the thing to describe.
     */
    public final String thingArn() {
        return thingArn;
    }

    /**
     * <p>
     * The thing type name.
     * </p>
     * 
     * @return The thing type name.
     */
    public final String thingTypeName() {
        return thingTypeName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The thing attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return The thing attributes.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The current version of the thing record in the registry.
     * </p>
     * <note>
     * <p>
     * To avoid unintentional changes to the information in the registry, you can pass the version information in the
     * <code>expectedVersion</code> parameter of the <code>UpdateThing</code> and <code>DeleteThing</code> calls.
     * </p>
     * </note>
     * 
     * @return The current version of the thing record in the registry.</p> <note>
     *         <p>
     *         To avoid unintentional changes to the information in the registry, you can pass the version information
     *         in the <code>expectedVersion</code> parameter of the <code>UpdateThing</code> and
     *         <code>DeleteThing</code> calls.
     *         </p>
     */
    public final Long version() {
        return version;
    }

    /**
     * <p>
     * The name of the billing group the thing belongs to.
     * </p>
     * 
     * @return The name of the billing group the thing belongs to.
     */
    public final String billingGroupName() {
        return billingGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(defaultClientId());
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(thingId());
        hashCode = 31 * hashCode + Objects.hashCode(thingArn());
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(billingGroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeThingResponse)) {
            return false;
        }
        DescribeThingResponse other = (DescribeThingResponse) obj;
        return Objects.equals(defaultClientId(), other.defaultClientId()) && Objects.equals(thingName(), other.thingName())
                && Objects.equals(thingId(), other.thingId()) && Objects.equals(thingArn(), other.thingArn())
                && Objects.equals(thingTypeName(), other.thingTypeName()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes()) && Objects.equals(version(), other.version())
                && Objects.equals(billingGroupName(), other.billingGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeThingResponse").add("DefaultClientId", defaultClientId()).add("ThingName", thingName())
                .add("ThingId", thingId()).add("ThingArn", thingArn()).add("ThingTypeName", thingTypeName())
                .add("Attributes", hasAttributes() ? attributes() : null).add("Version", version())
                .add("BillingGroupName", billingGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "defaultClientId":
            return Optional.ofNullable(clazz.cast(defaultClientId()));
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "thingId":
            return Optional.ofNullable(clazz.cast(thingId()));
        case "thingArn":
            return Optional.ofNullable(clazz.cast(thingArn()));
        case "thingTypeName":
            return Optional.ofNullable(clazz.cast(thingTypeName()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "billingGroupName":
            return Optional.ofNullable(clazz.cast(billingGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeThingResponse, T> g) {
        return obj -> g.apply((DescribeThingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeThingResponse> {
        /**
         * <p>
         * The default MQTT client ID. For a typical device, the thing name is also used as the default MQTT client ID.
         * Although we don’t require a mapping between a thing's registry name and its use of MQTT client IDs,
         * certificates, or shadow state, we recommend that you choose a thing name and use it as the MQTT client ID for
         * the registry and the Device Shadow service.
         * </p>
         * <p>
         * This lets you better organize your AWS IoT fleet without removing the flexibility of the underlying device
         * certificate model or shadows.
         * </p>
         * 
         * @param defaultClientId
         *        The default MQTT client ID. For a typical device, the thing name is also used as the default MQTT
         *        client ID. Although we don’t require a mapping between a thing's registry name and its use of MQTT
         *        client IDs, certificates, or shadow state, we recommend that you choose a thing name and use it as the
         *        MQTT client ID for the registry and the Device Shadow service.</p>
         *        <p>
         *        This lets you better organize your AWS IoT fleet without removing the flexibility of the underlying
         *        device certificate model or shadows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultClientId(String defaultClientId);

        /**
         * <p>
         * The name of the thing.
         * </p>
         * 
         * @param thingName
         *        The name of the thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The ID of the thing to describe.
         * </p>
         * 
         * @param thingId
         *        The ID of the thing to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingId(String thingId);

        /**
         * <p>
         * The ARN of the thing to describe.
         * </p>
         * 
         * @param thingArn
         *        The ARN of the thing to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingArn(String thingArn);

        /**
         * <p>
         * The thing type name.
         * </p>
         * 
         * @param thingTypeName
         *        The thing type name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeName(String thingTypeName);

        /**
         * <p>
         * The thing attributes.
         * </p>
         * 
         * @param attributes
         *        The thing attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * The current version of the thing record in the registry.
         * </p>
         * <note>
         * <p>
         * To avoid unintentional changes to the information in the registry, you can pass the version information in
         * the <code>expectedVersion</code> parameter of the <code>UpdateThing</code> and <code>DeleteThing</code>
         * calls.
         * </p>
         * </note>
         * 
         * @param version
         *        The current version of the thing record in the registry.</p> <note>
         *        <p>
         *        To avoid unintentional changes to the information in the registry, you can pass the version
         *        information in the <code>expectedVersion</code> parameter of the <code>UpdateThing</code> and
         *        <code>DeleteThing</code> calls.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);

        /**
         * <p>
         * The name of the billing group the thing belongs to.
         * </p>
         * 
         * @param billingGroupName
         *        The name of the billing group the thing belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupName(String billingGroupName);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String defaultClientId;

        private String thingName;

        private String thingId;

        private String thingArn;

        private String thingTypeName;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private Long version;

        private String billingGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeThingResponse model) {
            super(model);
            defaultClientId(model.defaultClientId);
            thingName(model.thingName);
            thingId(model.thingId);
            thingArn(model.thingArn);
            thingTypeName(model.thingTypeName);
            attributes(model.attributes);
            version(model.version);
            billingGroupName(model.billingGroupName);
        }

        public final String getDefaultClientId() {
            return defaultClientId;
        }

        public final void setDefaultClientId(String defaultClientId) {
            this.defaultClientId = defaultClientId;
        }

        @Override
        @Transient
        public final Builder defaultClientId(String defaultClientId) {
            this.defaultClientId = defaultClientId;
            return this;
        }

        public final String getThingName() {
            return thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        @Transient
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final String getThingId() {
            return thingId;
        }

        public final void setThingId(String thingId) {
            this.thingId = thingId;
        }

        @Override
        @Transient
        public final Builder thingId(String thingId) {
            this.thingId = thingId;
            return this;
        }

        public final String getThingArn() {
            return thingArn;
        }

        public final void setThingArn(String thingArn) {
            this.thingArn = thingArn;
        }

        @Override
        @Transient
        public final Builder thingArn(String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        public final String getThingTypeName() {
            return thingTypeName;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        @Override
        @Transient
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        @Transient
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final Long getVersion() {
            return version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final String getBillingGroupName() {
            return billingGroupName;
        }

        public final void setBillingGroupName(String billingGroupName) {
            this.billingGroupName = billingGroupName;
        }

        @Override
        @Transient
        public final Builder billingGroupName(String billingGroupName) {
            this.billingGroupName = billingGroupName;
            return this;
        }

        @Override
        public DescribeThingResponse build() {
            return new DescribeThingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
