/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFleetMetricsResponse extends IotResponse implements
        ToCopyableBuilder<ListFleetMetricsResponse.Builder, ListFleetMetricsResponse> {
    private static final SdkField<List<FleetMetricNameAndArn>> FLEET_METRICS_FIELD = SdkField
            .<List<FleetMetricNameAndArn>> builder(MarshallingType.LIST)
            .memberName("fleetMetrics")
            .getter(getter(ListFleetMetricsResponse::fleetMetrics))
            .setter(setter(Builder::fleetMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FleetMetricNameAndArn> builder(MarshallingType.SDK_POJO)
                                            .constructor(FleetMetricNameAndArn::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFleetMetricsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_METRICS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<FleetMetricNameAndArn> fleetMetrics;

    private final String nextToken;

    private ListFleetMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.fleetMetrics = builder.fleetMetrics;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FleetMetrics property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFleetMetrics() {
        return fleetMetrics != null && !(fleetMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of fleet metrics objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFleetMetrics} method.
     * </p>
     * 
     * @return The list of fleet metrics objects.
     */
    public final List<FleetMetricNameAndArn> fleetMetrics() {
        return fleetMetrics;
    }

    /**
     * <p>
     * The token for the next set of results. Will not be returned if the operation has returned all results.
     * </p>
     * 
     * @return The token for the next set of results. Will not be returned if the operation has returned all results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFleetMetrics() ? fleetMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFleetMetricsResponse)) {
            return false;
        }
        ListFleetMetricsResponse other = (ListFleetMetricsResponse) obj;
        return hasFleetMetrics() == other.hasFleetMetrics() && Objects.equals(fleetMetrics(), other.fleetMetrics())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFleetMetricsResponse").add("FleetMetrics", hasFleetMetrics() ? fleetMetrics() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fleetMetrics":
            return Optional.ofNullable(clazz.cast(fleetMetrics()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFleetMetricsResponse, T> g) {
        return obj -> g.apply((ListFleetMetricsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFleetMetricsResponse> {
        /**
         * <p>
         * The list of fleet metrics objects.
         * </p>
         * 
         * @param fleetMetrics
         *        The list of fleet metrics objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetMetrics(Collection<FleetMetricNameAndArn> fleetMetrics);

        /**
         * <p>
         * The list of fleet metrics objects.
         * </p>
         * 
         * @param fleetMetrics
         *        The list of fleet metrics objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetMetrics(FleetMetricNameAndArn... fleetMetrics);

        /**
         * <p>
         * The list of fleet metrics objects.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<FleetMetricNameAndArn>.Builder}
         * avoiding the need to create one manually via {@link List<FleetMetricNameAndArn>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FleetMetricNameAndArn>.Builder#build()} is called
         * immediately and its result is passed to {@link #fleetMetrics(List<FleetMetricNameAndArn>)}.
         * 
         * @param fleetMetrics
         *        a consumer that will call methods on {@link List<FleetMetricNameAndArn>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fleetMetrics(List<FleetMetricNameAndArn>)
         */
        Builder fleetMetrics(Consumer<FleetMetricNameAndArn.Builder>... fleetMetrics);

        /**
         * <p>
         * The token for the next set of results. Will not be returned if the operation has returned all results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Will not be returned if the operation has returned all results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<FleetMetricNameAndArn> fleetMetrics = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFleetMetricsResponse model) {
            super(model);
            fleetMetrics(model.fleetMetrics);
            nextToken(model.nextToken);
        }

        public final List<FleetMetricNameAndArn.Builder> getFleetMetrics() {
            List<FleetMetricNameAndArn.Builder> result = FleetMetricNameAndArnListCopier.copyToBuilder(this.fleetMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFleetMetrics(Collection<FleetMetricNameAndArn.BuilderImpl> fleetMetrics) {
            this.fleetMetrics = FleetMetricNameAndArnListCopier.copyFromBuilder(fleetMetrics);
        }

        @Override
        public final Builder fleetMetrics(Collection<FleetMetricNameAndArn> fleetMetrics) {
            this.fleetMetrics = FleetMetricNameAndArnListCopier.copy(fleetMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetMetrics(FleetMetricNameAndArn... fleetMetrics) {
            fleetMetrics(Arrays.asList(fleetMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetMetrics(Consumer<FleetMetricNameAndArn.Builder>... fleetMetrics) {
            fleetMetrics(Stream.of(fleetMetrics).map(c -> FleetMetricNameAndArn.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFleetMetricsResponse build() {
            return new ListFleetMetricsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
