/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an audit mitigation actions task that is returned by <code>ListAuditMitigationActionsTasks</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuditMitigationActionsTaskMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<AuditMitigationActionsTaskMetadata.Builder, AuditMitigationActionsTaskMetadata> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(AuditMitigationActionsTaskMetadata::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(AuditMitigationActionsTaskMetadata::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskStatus").getter(getter(AuditMitigationActionsTaskMetadata::taskStatusAsString))
            .setter(setter(Builder::taskStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD,
            START_TIME_FIELD, TASK_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String taskId;

    private final Instant startTime;

    private final String taskStatus;

    private AuditMitigationActionsTaskMetadata(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.startTime = builder.startTime;
        this.taskStatus = builder.taskStatus;
    }

    /**
     * <p>
     * The unique identifier for the task.
     * </p>
     * 
     * @return The unique identifier for the task.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * The time at which the audit mitigation actions task was started.
     * </p>
     * 
     * @return The time at which the audit mitigation actions task was started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The current state of the audit mitigation actions task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link AuditMitigationActionsTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #taskStatusAsString}.
     * </p>
     * 
     * @return The current state of the audit mitigation actions task.
     * @see AuditMitigationActionsTaskStatus
     */
    public final AuditMitigationActionsTaskStatus taskStatus() {
        return AuditMitigationActionsTaskStatus.fromValue(taskStatus);
    }

    /**
     * <p>
     * The current state of the audit mitigation actions task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link AuditMitigationActionsTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #taskStatusAsString}.
     * </p>
     * 
     * @return The current state of the audit mitigation actions task.
     * @see AuditMitigationActionsTaskStatus
     */
    public final String taskStatusAsString() {
        return taskStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(taskStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditMitigationActionsTaskMetadata)) {
            return false;
        }
        AuditMitigationActionsTaskMetadata other = (AuditMitigationActionsTaskMetadata) obj;
        return Objects.equals(taskId(), other.taskId()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(taskStatusAsString(), other.taskStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuditMitigationActionsTaskMetadata").add("TaskId", taskId()).add("StartTime", startTime())
                .add("TaskStatus", taskStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "taskStatus":
            return Optional.ofNullable(clazz.cast(taskStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuditMitigationActionsTaskMetadata, T> g) {
        return obj -> g.apply((AuditMitigationActionsTaskMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuditMitigationActionsTaskMetadata> {
        /**
         * <p>
         * The unique identifier for the task.
         * </p>
         * 
         * @param taskId
         *        The unique identifier for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * The time at which the audit mitigation actions task was started.
         * </p>
         * 
         * @param startTime
         *        The time at which the audit mitigation actions task was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The current state of the audit mitigation actions task.
         * </p>
         * 
         * @param taskStatus
         *        The current state of the audit mitigation actions task.
         * @see AuditMitigationActionsTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditMitigationActionsTaskStatus
         */
        Builder taskStatus(String taskStatus);

        /**
         * <p>
         * The current state of the audit mitigation actions task.
         * </p>
         * 
         * @param taskStatus
         *        The current state of the audit mitigation actions task.
         * @see AuditMitigationActionsTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditMitigationActionsTaskStatus
         */
        Builder taskStatus(AuditMitigationActionsTaskStatus taskStatus);
    }

    static final class BuilderImpl implements Builder {
        private String taskId;

        private Instant startTime;

        private String taskStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditMitigationActionsTaskMetadata model) {
            taskId(model.taskId);
            startTime(model.startTime);
            taskStatus(model.taskStatus);
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getTaskStatus() {
            return taskStatus;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(AuditMitigationActionsTaskStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        @Override
        public AuditMitigationActionsTaskMetadata build() {
            return new AuditMitigationActionsTaskMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
