/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.GroupNameAndArn;
import software.amazon.awssdk.services.iot.model.ListThingGroupsRequest;
import software.amazon.awssdk.services.iot.model.ListThingGroupsResponse;

public class ListThingGroupsIterable
implements SdkIterable<ListThingGroupsResponse> {
    private final IotClient client;
    private final ListThingGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListThingGroupsIterable(IotClient client, ListThingGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListThingGroupsResponseFetcher();
    }

    public Iterator<ListThingGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GroupNameAndArn> thingGroups() {
        Function<ListThingGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.thingGroups() != null) {
                return response.thingGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListThingGroupsResponseFetcher
    implements SyncPageFetcher<ListThingGroupsResponse> {
        private ListThingGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListThingGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListThingGroupsResponse nextPage(ListThingGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListThingGroupsIterable.this.client.listThingGroups(ListThingGroupsIterable.this.firstRequest);
            }
            return ListThingGroupsIterable.this.client.listThingGroups((ListThingGroupsRequest)((Object)ListThingGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

