/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.ThingTypeDefinition;
import software.amazon.awssdk.services.iot.model.ThingTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListThingTypesResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListThingTypesResponse> {
    private static final SdkField<List<ThingTypeDefinition>> THING_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("thingTypes").getter(ListThingTypesResponse.getter(ListThingTypesResponse::thingTypes)).setter(ListThingTypesResponse.setter(Builder::thingTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ThingTypeDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListThingTypesResponse.getter(ListThingTypesResponse::nextToken)).setter(ListThingTypesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_TYPES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ThingTypeDefinition> thingTypes;
    private final String nextToken;

    private ListThingTypesResponse(BuilderImpl builder) {
        super(builder);
        this.thingTypes = builder.thingTypes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasThingTypes() {
        return this.thingTypes != null && !(this.thingTypes instanceof SdkAutoConstructList);
    }

    public final List<ThingTypeDefinition> thingTypes() {
        return this.thingTypes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThingTypes() ? this.thingTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingTypesResponse)) {
            return false;
        }
        ListThingTypesResponse other = (ListThingTypesResponse)((Object)obj);
        return this.hasThingTypes() == other.hasThingTypes() && Objects.equals(this.thingTypes(), other.thingTypes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListThingTypesResponse").add("ThingTypes", this.hasThingTypes() ? this.thingTypes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingTypes": {
                return Optional.ofNullable(clazz.cast(this.thingTypes()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListThingTypesResponse, T> g) {
        return obj -> g.apply((ListThingTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<ThingTypeDefinition> thingTypes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingTypesResponse model) {
            super(model);
            this.thingTypes(model.thingTypes);
            this.nextToken(model.nextToken);
        }

        public final List<ThingTypeDefinition.Builder> getThingTypes() {
            List<ThingTypeDefinition.Builder> result = ThingTypeListCopier.copyToBuilder(this.thingTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThingTypes(Collection<ThingTypeDefinition.BuilderImpl> thingTypes) {
            this.thingTypes = ThingTypeListCopier.copyFromBuilder(thingTypes);
        }

        @Override
        public final Builder thingTypes(Collection<ThingTypeDefinition> thingTypes) {
            this.thingTypes = ThingTypeListCopier.copy(thingTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingTypes(ThingTypeDefinition ... thingTypes) {
            this.thingTypes(Arrays.asList(thingTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingTypes(Consumer<ThingTypeDefinition.Builder> ... thingTypes) {
            this.thingTypes(Stream.of(thingTypes).map(c -> (ThingTypeDefinition)((ThingTypeDefinition.Builder)ThingTypeDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListThingTypesResponse build() {
            return new ListThingTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListThingTypesResponse> {
        public Builder thingTypes(Collection<ThingTypeDefinition> var1);

        public Builder thingTypes(ThingTypeDefinition ... var1);

        public Builder thingTypes(Consumer<ThingTypeDefinition.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

