/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelJobRequest extends IotRequest implements ToCopyableBuilder<CancelJobRequest.Builder, CancelJobRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(CancelJobRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<String> REASON_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reasonCode").getter(getter(CancelJobRequest::reasonCode)).setter(setter(Builder::reasonCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasonCode").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(CancelJobRequest::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final SdkField<Boolean> FORCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("force")
            .getter(getter(CancelJobRequest::force)).setter(setter(Builder::force))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("force").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            REASON_CODE_FIELD, COMMENT_FIELD, FORCE_FIELD));

    private final String jobId;

    private final String reasonCode;

    private final String comment;

    private final Boolean force;

    private CancelJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.reasonCode = builder.reasonCode;
        this.comment = builder.comment;
        this.force = builder.force;
    }

    /**
     * <p>
     * The unique identifier you assigned to this job when it was created.
     * </p>
     * 
     * @return The unique identifier you assigned to this job when it was created.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * (Optional)A reason code string that explains why the job was canceled.
     * </p>
     * 
     * @return (Optional)A reason code string that explains why the job was canceled.
     */
    public final String reasonCode() {
        return reasonCode;
    }

    /**
     * <p>
     * An optional comment string describing why the job was canceled.
     * </p>
     * 
     * @return An optional comment string describing why the job was canceled.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * (Optional) If <code>true</code> job executions with status "IN_PROGRESS" and "QUEUED" are canceled, otherwise
     * only job executions with status "QUEUED" are canceled. The default is <code>false</code>.
     * </p>
     * <p>
     * Canceling a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to update the
     * job execution status. Use caution and ensure that each device executing a job which is canceled is able to
     * recover to a valid state.
     * </p>
     * 
     * @return (Optional) If <code>true</code> job executions with status "IN_PROGRESS" and "QUEUED" are canceled,
     *         otherwise only job executions with status "QUEUED" are canceled. The default is <code>false</code>.</p>
     *         <p>
     *         Canceling a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to
     *         update the job execution status. Use caution and ensure that each device executing a job which is
     *         canceled is able to recover to a valid state.
     */
    public final Boolean force() {
        return force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(reasonCode());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelJobRequest)) {
            return false;
        }
        CancelJobRequest other = (CancelJobRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(reasonCode(), other.reasonCode())
                && Objects.equals(comment(), other.comment()) && Objects.equals(force(), other.force());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelJobRequest").add("JobId", jobId()).add("ReasonCode", reasonCode())
                .add("Comment", comment()).add("Force", force()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "reasonCode":
            return Optional.ofNullable(clazz.cast(reasonCode()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "force":
            return Optional.ofNullable(clazz.cast(force()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelJobRequest, T> g) {
        return obj -> g.apply((CancelJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, CancelJobRequest> {
        /**
         * <p>
         * The unique identifier you assigned to this job when it was created.
         * </p>
         * 
         * @param jobId
         *        The unique identifier you assigned to this job when it was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * (Optional)A reason code string that explains why the job was canceled.
         * </p>
         * 
         * @param reasonCode
         *        (Optional)A reason code string that explains why the job was canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonCode(String reasonCode);

        /**
         * <p>
         * An optional comment string describing why the job was canceled.
         * </p>
         * 
         * @param comment
         *        An optional comment string describing why the job was canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * (Optional) If <code>true</code> job executions with status "IN_PROGRESS" and "QUEUED" are canceled, otherwise
         * only job executions with status "QUEUED" are canceled. The default is <code>false</code>.
         * </p>
         * <p>
         * Canceling a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to update
         * the job execution status. Use caution and ensure that each device executing a job which is canceled is able
         * to recover to a valid state.
         * </p>
         * 
         * @param force
         *        (Optional) If <code>true</code> job executions with status "IN_PROGRESS" and "QUEUED" are canceled,
         *        otherwise only job executions with status "QUEUED" are canceled. The default is <code>false</code>
         *        .</p>
         *        <p>
         *        Canceling a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to
         *        update the job execution status. Use caution and ensure that each device executing a job which is
         *        canceled is able to recover to a valid state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String jobId;

        private String reasonCode;

        private String comment;

        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelJobRequest model) {
            super(model);
            jobId(model.jobId);
            reasonCode(model.reasonCode);
            comment(model.comment);
            force(model.force);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        @Transient
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getReasonCode() {
            return reasonCode;
        }

        public final void setReasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
        }

        @Override
        @Transient
        public final Builder reasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        @Transient
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final Boolean getForce() {
            return force;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        @Transient
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelJobRequest build() {
            return new CancelJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
