/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.GroupNameAndArn;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.ThingGroupNameAndArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListThingGroupsForThingResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListThingGroupsForThingResponse> {
    private static final SdkField<List<GroupNameAndArn>> THING_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("thingGroups").getter(ListThingGroupsForThingResponse.getter(ListThingGroupsForThingResponse::thingGroups)).setter(ListThingGroupsForThingResponse.setter(Builder::thingGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupNameAndArn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListThingGroupsForThingResponse.getter(ListThingGroupsForThingResponse::nextToken)).setter(ListThingGroupsForThingResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<GroupNameAndArn> thingGroups;
    private final String nextToken;

    private ListThingGroupsForThingResponse(BuilderImpl builder) {
        super(builder);
        this.thingGroups = builder.thingGroups;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasThingGroups() {
        return this.thingGroups != null && !(this.thingGroups instanceof SdkAutoConstructList);
    }

    public final List<GroupNameAndArn> thingGroups() {
        return this.thingGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThingGroups() ? this.thingGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingGroupsForThingResponse)) {
            return false;
        }
        ListThingGroupsForThingResponse other = (ListThingGroupsForThingResponse)((Object)obj);
        return this.hasThingGroups() == other.hasThingGroups() && Objects.equals(this.thingGroups(), other.thingGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListThingGroupsForThingResponse").add("ThingGroups", this.hasThingGroups() ? this.thingGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingGroups": {
                return Optional.ofNullable(clazz.cast(this.thingGroups()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListThingGroupsForThingResponse, T> g) {
        return obj -> g.apply((ListThingGroupsForThingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<GroupNameAndArn> thingGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingGroupsForThingResponse model) {
            super(model);
            this.thingGroups(model.thingGroups);
            this.nextToken(model.nextToken);
        }

        public final List<GroupNameAndArn.Builder> getThingGroups() {
            List<GroupNameAndArn.Builder> result = ThingGroupNameAndArnListCopier.copyToBuilder(this.thingGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThingGroups(Collection<GroupNameAndArn.BuilderImpl> thingGroups) {
            this.thingGroups = ThingGroupNameAndArnListCopier.copyFromBuilder(thingGroups);
        }

        @Override
        public final Builder thingGroups(Collection<GroupNameAndArn> thingGroups) {
            this.thingGroups = ThingGroupNameAndArnListCopier.copy(thingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroups(GroupNameAndArn ... thingGroups) {
            this.thingGroups(Arrays.asList(thingGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroups(Consumer<GroupNameAndArn.Builder> ... thingGroups) {
            this.thingGroups(Stream.of(thingGroups).map(c -> (GroupNameAndArn)((GroupNameAndArn.Builder)GroupNameAndArn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListThingGroupsForThingResponse build() {
            return new ListThingGroupsForThingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListThingGroupsForThingResponse> {
        public Builder thingGroups(Collection<GroupNameAndArn> var1);

        public Builder thingGroups(GroupNameAndArn ... var1);

        public Builder thingGroups(Consumer<GroupNameAndArn.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

