/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesRequest;
import software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesResponse;
import software.amazon.awssdk.services.iot.model.OutgoingCertificate;

public class ListOutgoingCertificatesPublisher
implements SdkPublisher<ListOutgoingCertificatesResponse> {
    private final IotAsyncClient client;
    private final ListOutgoingCertificatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOutgoingCertificatesPublisher(IotAsyncClient client, ListOutgoingCertificatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOutgoingCertificatesPublisher(IotAsyncClient client, ListOutgoingCertificatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOutgoingCertificatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOutgoingCertificatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OutgoingCertificate> outgoingCertificates() {
        Function<ListOutgoingCertificatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.outgoingCertificates() != null) {
                return response.outgoingCertificates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOutgoingCertificatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOutgoingCertificatesResponseFetcher
    implements AsyncPageFetcher<ListOutgoingCertificatesResponse> {
        private ListOutgoingCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(ListOutgoingCertificatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListOutgoingCertificatesResponse> nextPage(ListOutgoingCertificatesResponse previousPage) {
            if (previousPage == null) {
                return ListOutgoingCertificatesPublisher.this.client.listOutgoingCertificates(ListOutgoingCertificatesPublisher.this.firstRequest);
            }
            return ListOutgoingCertificatesPublisher.this.client.listOutgoingCertificates((ListOutgoingCertificatesRequest)((Object)ListOutgoingCertificatesPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

