/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOtaUpdateRequest extends IotRequest implements
        ToCopyableBuilder<CreateOtaUpdateRequest.Builder, CreateOtaUpdateRequest> {
    private static final SdkField<String> OTA_UPDATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("otaUpdateId").getter(getter(CreateOtaUpdateRequest::otaUpdateId)).setter(setter(Builder::otaUpdateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("otaUpdateId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateOtaUpdateRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> TARGETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("targets")
            .getter(getter(CreateOtaUpdateRequest::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PROTOCOLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("protocols")
            .getter(getter(CreateOtaUpdateRequest::protocolsAsStrings))
            .setter(setter(Builder::protocolsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocols").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TARGET_SELECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetSelection").getter(getter(CreateOtaUpdateRequest::targetSelectionAsString))
            .setter(setter(Builder::targetSelection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetSelection").build()).build();

    private static final SdkField<AwsJobExecutionsRolloutConfig> AWS_JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD = SdkField
            .<AwsJobExecutionsRolloutConfig> builder(MarshallingType.SDK_POJO)
            .memberName("awsJobExecutionsRolloutConfig")
            .getter(getter(CreateOtaUpdateRequest::awsJobExecutionsRolloutConfig))
            .setter(setter(Builder::awsJobExecutionsRolloutConfig))
            .constructor(AwsJobExecutionsRolloutConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsJobExecutionsRolloutConfig")
                    .build()).build();

    private static final SdkField<AwsJobPresignedUrlConfig> AWS_JOB_PRESIGNED_URL_CONFIG_FIELD = SdkField
            .<AwsJobPresignedUrlConfig> builder(MarshallingType.SDK_POJO).memberName("awsJobPresignedUrlConfig")
            .getter(getter(CreateOtaUpdateRequest::awsJobPresignedUrlConfig)).setter(setter(Builder::awsJobPresignedUrlConfig))
            .constructor(AwsJobPresignedUrlConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsJobPresignedUrlConfig").build())
            .build();

    private static final SdkField<AwsJobAbortConfig> AWS_JOB_ABORT_CONFIG_FIELD = SdkField
            .<AwsJobAbortConfig> builder(MarshallingType.SDK_POJO).memberName("awsJobAbortConfig")
            .getter(getter(CreateOtaUpdateRequest::awsJobAbortConfig)).setter(setter(Builder::awsJobAbortConfig))
            .constructor(AwsJobAbortConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsJobAbortConfig").build()).build();

    private static final SdkField<AwsJobTimeoutConfig> AWS_JOB_TIMEOUT_CONFIG_FIELD = SdkField
            .<AwsJobTimeoutConfig> builder(MarshallingType.SDK_POJO).memberName("awsJobTimeoutConfig")
            .getter(getter(CreateOtaUpdateRequest::awsJobTimeoutConfig)).setter(setter(Builder::awsJobTimeoutConfig))
            .constructor(AwsJobTimeoutConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsJobTimeoutConfig").build())
            .build();

    private static final SdkField<List<OTAUpdateFile>> FILES_FIELD = SdkField
            .<List<OTAUpdateFile>> builder(MarshallingType.LIST)
            .memberName("files")
            .getter(getter(CreateOtaUpdateRequest::files))
            .setter(setter(Builder::files))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("files").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OTAUpdateFile> builder(MarshallingType.SDK_POJO)
                                            .constructor(OTAUpdateFile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateOtaUpdateRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Map<String, String>> ADDITIONAL_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("additionalParameters")
            .getter(getter(CreateOtaUpdateRequest::additionalParameters))
            .setter(setter(Builder::additionalParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateOtaUpdateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OTA_UPDATE_ID_FIELD,
            DESCRIPTION_FIELD, TARGETS_FIELD, PROTOCOLS_FIELD, TARGET_SELECTION_FIELD, AWS_JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD,
            AWS_JOB_PRESIGNED_URL_CONFIG_FIELD, AWS_JOB_ABORT_CONFIG_FIELD, AWS_JOB_TIMEOUT_CONFIG_FIELD, FILES_FIELD,
            ROLE_ARN_FIELD, ADDITIONAL_PARAMETERS_FIELD, TAGS_FIELD));

    private final String otaUpdateId;

    private final String description;

    private final List<String> targets;

    private final List<String> protocols;

    private final String targetSelection;

    private final AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig;

    private final AwsJobPresignedUrlConfig awsJobPresignedUrlConfig;

    private final AwsJobAbortConfig awsJobAbortConfig;

    private final AwsJobTimeoutConfig awsJobTimeoutConfig;

    private final List<OTAUpdateFile> files;

    private final String roleArn;

    private final Map<String, String> additionalParameters;

    private final List<Tag> tags;

    private CreateOtaUpdateRequest(BuilderImpl builder) {
        super(builder);
        this.otaUpdateId = builder.otaUpdateId;
        this.description = builder.description;
        this.targets = builder.targets;
        this.protocols = builder.protocols;
        this.targetSelection = builder.targetSelection;
        this.awsJobExecutionsRolloutConfig = builder.awsJobExecutionsRolloutConfig;
        this.awsJobPresignedUrlConfig = builder.awsJobPresignedUrlConfig;
        this.awsJobAbortConfig = builder.awsJobAbortConfig;
        this.awsJobTimeoutConfig = builder.awsJobTimeoutConfig;
        this.files = builder.files;
        this.roleArn = builder.roleArn;
        this.additionalParameters = builder.additionalParameters;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the OTA update to be created.
     * </p>
     * 
     * @return The ID of the OTA update to be created.
     */
    public final String otaUpdateId() {
        return otaUpdateId;
    }

    /**
     * <p>
     * The description of the OTA update.
     * </p>
     * 
     * @return The description of the OTA update.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Targets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The devices targeted to receive OTA updates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargets} method.
     * </p>
     * 
     * @return The devices targeted to receive OTA updates.
     */
    public final List<String> targets() {
        return targets;
    }

    /**
     * <p>
     * The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both HTTP
     * and MQTT are specified, the target device can choose the protocol.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProtocols} method.
     * </p>
     * 
     * @return The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When
     *         both HTTP and MQTT are specified, the target device can choose the protocol.
     */
    public final List<Protocol> protocols() {
        return ProtocolsCopier.copyStringToEnum(protocols);
    }

    /**
     * For responses, this returns true if the service returned a value for the Protocols property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProtocols() {
        return protocols != null && !(protocols instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both HTTP
     * and MQTT are specified, the target device can choose the protocol.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProtocols} method.
     * </p>
     * 
     * @return The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When
     *         both HTTP and MQTT are specified, the target device can choose the protocol.
     */
    public final List<String> protocolsAsStrings() {
        return protocols;
    }

    /**
     * <p>
     * Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the things
     * specified as targets have completed the update (SNAPSHOT). If continuous, the update may also be run on a thing
     * when a change is detected in a target. For example, an update will run on a thing when the thing is added to a
     * target group, even after the update was completed by all things originally in the group. Valid values: CONTINUOUS
     * | SNAPSHOT.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetSelection}
     * will return {@link TargetSelection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetSelectionAsString}.
     * </p>
     * 
     * @return Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the things
     *         specified as targets have completed the update (SNAPSHOT). If continuous, the update may also be run on a
     *         thing when a change is detected in a target. For example, an update will run on a thing when the thing is
     *         added to a target group, even after the update was completed by all things originally in the group. Valid
     *         values: CONTINUOUS | SNAPSHOT.
     * @see TargetSelection
     */
    public final TargetSelection targetSelection() {
        return TargetSelection.fromValue(targetSelection);
    }

    /**
     * <p>
     * Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the things
     * specified as targets have completed the update (SNAPSHOT). If continuous, the update may also be run on a thing
     * when a change is detected in a target. For example, an update will run on a thing when the thing is added to a
     * target group, even after the update was completed by all things originally in the group. Valid values: CONTINUOUS
     * | SNAPSHOT.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetSelection}
     * will return {@link TargetSelection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetSelectionAsString}.
     * </p>
     * 
     * @return Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the things
     *         specified as targets have completed the update (SNAPSHOT). If continuous, the update may also be run on a
     *         thing when a change is detected in a target. For example, an update will run on a thing when the thing is
     *         added to a target group, even after the update was completed by all things originally in the group. Valid
     *         values: CONTINUOUS | SNAPSHOT.
     * @see TargetSelection
     */
    public final String targetSelectionAsString() {
        return targetSelection;
    }

    /**
     * <p>
     * Configuration for the rollout of OTA updates.
     * </p>
     * 
     * @return Configuration for the rollout of OTA updates.
     */
    public final AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig() {
        return awsJobExecutionsRolloutConfig;
    }

    /**
     * <p>
     * Configuration information for pre-signed URLs.
     * </p>
     * 
     * @return Configuration information for pre-signed URLs.
     */
    public final AwsJobPresignedUrlConfig awsJobPresignedUrlConfig() {
        return awsJobPresignedUrlConfig;
    }

    /**
     * <p>
     * The criteria that determine when and how a job abort takes place.
     * </p>
     * 
     * @return The criteria that determine when and how a job abort takes place.
     */
    public final AwsJobAbortConfig awsJobAbortConfig() {
        return awsJobAbortConfig;
    }

    /**
     * <p>
     * Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job
     * execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal
     * state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.
     * </p>
     * 
     * @return Specifies the amount of time each device has to finish its execution of the job. A timer is started when
     *         the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to
     *         another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.
     */
    public final AwsJobTimeoutConfig awsJobTimeoutConfig() {
        return awsJobTimeoutConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Files property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasFiles() {
        return files != null && !(files instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The files to be streamed by the OTA update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFiles} method.
     * </p>
     * 
     * @return The files to be streamed by the OTA update.
     */
    public final List<OTAUpdateFile> files() {
        return files;
    }

    /**
     * <p>
     * The IAM role that grants AWS IoT access to the Amazon S3, AWS IoT jobs and AWS Code Signing resources to create
     * an OTA update job.
     * </p>
     * 
     * @return The IAM role that grants AWS IoT access to the Amazon S3, AWS IoT jobs and AWS Code Signing resources to
     *         create an OTA update job.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalParameters() {
        return additionalParameters != null && !(additionalParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of additional OTA update parameters which are name-value pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalParameters} method.
     * </p>
     * 
     * @return A list of additional OTA update parameters which are name-value pairs.
     */
    public final Map<String, String> additionalParameters() {
        return additionalParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata which can be used to manage updates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata which can be used to manage updates.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(otaUpdateId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProtocols() ? protocolsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(awsJobExecutionsRolloutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(awsJobPresignedUrlConfig());
        hashCode = 31 * hashCode + Objects.hashCode(awsJobAbortConfig());
        hashCode = 31 * hashCode + Objects.hashCode(awsJobTimeoutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasFiles() ? files() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalParameters() ? additionalParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOtaUpdateRequest)) {
            return false;
        }
        CreateOtaUpdateRequest other = (CreateOtaUpdateRequest) obj;
        return Objects.equals(otaUpdateId(), other.otaUpdateId()) && Objects.equals(description(), other.description())
                && hasTargets() == other.hasTargets() && Objects.equals(targets(), other.targets())
                && hasProtocols() == other.hasProtocols() && Objects.equals(protocolsAsStrings(), other.protocolsAsStrings())
                && Objects.equals(targetSelectionAsString(), other.targetSelectionAsString())
                && Objects.equals(awsJobExecutionsRolloutConfig(), other.awsJobExecutionsRolloutConfig())
                && Objects.equals(awsJobPresignedUrlConfig(), other.awsJobPresignedUrlConfig())
                && Objects.equals(awsJobAbortConfig(), other.awsJobAbortConfig())
                && Objects.equals(awsJobTimeoutConfig(), other.awsJobTimeoutConfig()) && hasFiles() == other.hasFiles()
                && Objects.equals(files(), other.files()) && Objects.equals(roleArn(), other.roleArn())
                && hasAdditionalParameters() == other.hasAdditionalParameters()
                && Objects.equals(additionalParameters(), other.additionalParameters()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateOtaUpdateRequest").add("OtaUpdateId", otaUpdateId()).add("Description", description())
                .add("Targets", hasTargets() ? targets() : null).add("Protocols", hasProtocols() ? protocolsAsStrings() : null)
                .add("TargetSelection", targetSelectionAsString())
                .add("AwsJobExecutionsRolloutConfig", awsJobExecutionsRolloutConfig())
                .add("AwsJobPresignedUrlConfig", awsJobPresignedUrlConfig()).add("AwsJobAbortConfig", awsJobAbortConfig())
                .add("AwsJobTimeoutConfig", awsJobTimeoutConfig()).add("Files", hasFiles() ? files() : null)
                .add("RoleArn", roleArn()).add("AdditionalParameters", hasAdditionalParameters() ? additionalParameters() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "otaUpdateId":
            return Optional.ofNullable(clazz.cast(otaUpdateId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "protocols":
            return Optional.ofNullable(clazz.cast(protocolsAsStrings()));
        case "targetSelection":
            return Optional.ofNullable(clazz.cast(targetSelectionAsString()));
        case "awsJobExecutionsRolloutConfig":
            return Optional.ofNullable(clazz.cast(awsJobExecutionsRolloutConfig()));
        case "awsJobPresignedUrlConfig":
            return Optional.ofNullable(clazz.cast(awsJobPresignedUrlConfig()));
        case "awsJobAbortConfig":
            return Optional.ofNullable(clazz.cast(awsJobAbortConfig()));
        case "awsJobTimeoutConfig":
            return Optional.ofNullable(clazz.cast(awsJobTimeoutConfig()));
        case "files":
            return Optional.ofNullable(clazz.cast(files()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "additionalParameters":
            return Optional.ofNullable(clazz.cast(additionalParameters()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOtaUpdateRequest, T> g) {
        return obj -> g.apply((CreateOtaUpdateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateOtaUpdateRequest> {
        /**
         * <p>
         * The ID of the OTA update to be created.
         * </p>
         * 
         * @param otaUpdateId
         *        The ID of the OTA update to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaUpdateId(String otaUpdateId);

        /**
         * <p>
         * The description of the OTA update.
         * </p>
         * 
         * @param description
         *        The description of the OTA update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The devices targeted to receive OTA updates.
         * </p>
         * 
         * @param targets
         *        The devices targeted to receive OTA updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<String> targets);

        /**
         * <p>
         * The devices targeted to receive OTA updates.
         * </p>
         * 
         * @param targets
         *        The devices targeted to receive OTA updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(String... targets);

        /**
         * <p>
         * The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both
         * HTTP and MQTT are specified, the target device can choose the protocol.
         * </p>
         * 
         * @param protocols
         *        The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT].
         *        When both HTTP and MQTT are specified, the target device can choose the protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolsWithStrings(Collection<String> protocols);

        /**
         * <p>
         * The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both
         * HTTP and MQTT are specified, the target device can choose the protocol.
         * </p>
         * 
         * @param protocols
         *        The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT].
         *        When both HTTP and MQTT are specified, the target device can choose the protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolsWithStrings(String... protocols);

        /**
         * <p>
         * The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both
         * HTTP and MQTT are specified, the target device can choose the protocol.
         * </p>
         * 
         * @param protocols
         *        The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT].
         *        When both HTTP and MQTT are specified, the target device can choose the protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocols(Collection<Protocol> protocols);

        /**
         * <p>
         * The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both
         * HTTP and MQTT are specified, the target device can choose the protocol.
         * </p>
         * 
         * @param protocols
         *        The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT].
         *        When both HTTP and MQTT are specified, the target device can choose the protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocols(Protocol... protocols);

        /**
         * <p>
         * Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the things
         * specified as targets have completed the update (SNAPSHOT). If continuous, the update may also be run on a
         * thing when a change is detected in a target. For example, an update will run on a thing when the thing is
         * added to a target group, even after the update was completed by all things originally in the group. Valid
         * values: CONTINUOUS | SNAPSHOT.
         * </p>
         * 
         * @param targetSelection
         *        Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the
         *        things specified as targets have completed the update (SNAPSHOT). If continuous, the update may also
         *        be run on a thing when a change is detected in a target. For example, an update will run on a thing
         *        when the thing is added to a target group, even after the update was completed by all things
         *        originally in the group. Valid values: CONTINUOUS | SNAPSHOT.
         * @see TargetSelection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetSelection
         */
        Builder targetSelection(String targetSelection);

        /**
         * <p>
         * Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the things
         * specified as targets have completed the update (SNAPSHOT). If continuous, the update may also be run on a
         * thing when a change is detected in a target. For example, an update will run on a thing when the thing is
         * added to a target group, even after the update was completed by all things originally in the group. Valid
         * values: CONTINUOUS | SNAPSHOT.
         * </p>
         * 
         * @param targetSelection
         *        Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the
         *        things specified as targets have completed the update (SNAPSHOT). If continuous, the update may also
         *        be run on a thing when a change is detected in a target. For example, an update will run on a thing
         *        when the thing is added to a target group, even after the update was completed by all things
         *        originally in the group. Valid values: CONTINUOUS | SNAPSHOT.
         * @see TargetSelection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetSelection
         */
        Builder targetSelection(TargetSelection targetSelection);

        /**
         * <p>
         * Configuration for the rollout of OTA updates.
         * </p>
         * 
         * @param awsJobExecutionsRolloutConfig
         *        Configuration for the rollout of OTA updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig);

        /**
         * <p>
         * Configuration for the rollout of OTA updates.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsJobExecutionsRolloutConfig.Builder} avoiding
         * the need to create one manually via {@link AwsJobExecutionsRolloutConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsJobExecutionsRolloutConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #awsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig)}
         * .
         * 
         * @param awsJobExecutionsRolloutConfig
         *        a consumer that will call methods on {@link AwsJobExecutionsRolloutConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig)
         */
        default Builder awsJobExecutionsRolloutConfig(
                Consumer<AwsJobExecutionsRolloutConfig.Builder> awsJobExecutionsRolloutConfig) {
            return awsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig.builder()
                    .applyMutation(awsJobExecutionsRolloutConfig).build());
        }

        /**
         * <p>
         * Configuration information for pre-signed URLs.
         * </p>
         * 
         * @param awsJobPresignedUrlConfig
         *        Configuration information for pre-signed URLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsJobPresignedUrlConfig(AwsJobPresignedUrlConfig awsJobPresignedUrlConfig);

        /**
         * <p>
         * Configuration information for pre-signed URLs.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsJobPresignedUrlConfig.Builder} avoiding the
         * need to create one manually via {@link AwsJobPresignedUrlConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsJobPresignedUrlConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #awsJobPresignedUrlConfig(AwsJobPresignedUrlConfig)}.
         * 
         * @param awsJobPresignedUrlConfig
         *        a consumer that will call methods on {@link AwsJobPresignedUrlConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsJobPresignedUrlConfig(AwsJobPresignedUrlConfig)
         */
        default Builder awsJobPresignedUrlConfig(Consumer<AwsJobPresignedUrlConfig.Builder> awsJobPresignedUrlConfig) {
            return awsJobPresignedUrlConfig(AwsJobPresignedUrlConfig.builder().applyMutation(awsJobPresignedUrlConfig).build());
        }

        /**
         * <p>
         * The criteria that determine when and how a job abort takes place.
         * </p>
         * 
         * @param awsJobAbortConfig
         *        The criteria that determine when and how a job abort takes place.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsJobAbortConfig(AwsJobAbortConfig awsJobAbortConfig);

        /**
         * <p>
         * The criteria that determine when and how a job abort takes place.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsJobAbortConfig.Builder} avoiding the need to
         * create one manually via {@link AwsJobAbortConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsJobAbortConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #awsJobAbortConfig(AwsJobAbortConfig)}.
         * 
         * @param awsJobAbortConfig
         *        a consumer that will call methods on {@link AwsJobAbortConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsJobAbortConfig(AwsJobAbortConfig)
         */
        default Builder awsJobAbortConfig(Consumer<AwsJobAbortConfig.Builder> awsJobAbortConfig) {
            return awsJobAbortConfig(AwsJobAbortConfig.builder().applyMutation(awsJobAbortConfig).build());
        }

        /**
         * <p>
         * Specifies the amount of time each device has to finish its execution of the job. A timer is started when the
         * job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another
         * terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.
         * </p>
         * 
         * @param awsJobTimeoutConfig
         *        Specifies the amount of time each device has to finish its execution of the job. A timer is started
         *        when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not
         *        set to another terminal state before the timer expires, it will be automatically set to
         *        <code>TIMED_OUT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsJobTimeoutConfig(AwsJobTimeoutConfig awsJobTimeoutConfig);

        /**
         * <p>
         * Specifies the amount of time each device has to finish its execution of the job. A timer is started when the
         * job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another
         * terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsJobTimeoutConfig.Builder} avoiding the need
         * to create one manually via {@link AwsJobTimeoutConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsJobTimeoutConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #awsJobTimeoutConfig(AwsJobTimeoutConfig)}.
         * 
         * @param awsJobTimeoutConfig
         *        a consumer that will call methods on {@link AwsJobTimeoutConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsJobTimeoutConfig(AwsJobTimeoutConfig)
         */
        default Builder awsJobTimeoutConfig(Consumer<AwsJobTimeoutConfig.Builder> awsJobTimeoutConfig) {
            return awsJobTimeoutConfig(AwsJobTimeoutConfig.builder().applyMutation(awsJobTimeoutConfig).build());
        }

        /**
         * <p>
         * The files to be streamed by the OTA update.
         * </p>
         * 
         * @param files
         *        The files to be streamed by the OTA update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder files(Collection<OTAUpdateFile> files);

        /**
         * <p>
         * The files to be streamed by the OTA update.
         * </p>
         * 
         * @param files
         *        The files to be streamed by the OTA update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder files(OTAUpdateFile... files);

        /**
         * <p>
         * The files to be streamed by the OTA update.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OTAUpdateFile>.Builder} avoiding the need
         * to create one manually via {@link List<OTAUpdateFile>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OTAUpdateFile>.Builder#build()} is called immediately and
         * its result is passed to {@link #files(List<OTAUpdateFile>)}.
         * 
         * @param files
         *        a consumer that will call methods on {@link List<OTAUpdateFile>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #files(List<OTAUpdateFile>)
         */
        Builder files(Consumer<OTAUpdateFile.Builder>... files);

        /**
         * <p>
         * The IAM role that grants AWS IoT access to the Amazon S3, AWS IoT jobs and AWS Code Signing resources to
         * create an OTA update job.
         * </p>
         * 
         * @param roleArn
         *        The IAM role that grants AWS IoT access to the Amazon S3, AWS IoT jobs and AWS Code Signing resources
         *        to create an OTA update job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A list of additional OTA update parameters which are name-value pairs.
         * </p>
         * 
         * @param additionalParameters
         *        A list of additional OTA update parameters which are name-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalParameters(Map<String, String> additionalParameters);

        /**
         * <p>
         * Metadata which can be used to manage updates.
         * </p>
         * 
         * @param tags
         *        Metadata which can be used to manage updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Metadata which can be used to manage updates.
         * </p>
         * 
         * @param tags
         *        Metadata which can be used to manage updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Metadata which can be used to manage updates.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String otaUpdateId;

        private String description;

        private List<String> targets = DefaultSdkAutoConstructList.getInstance();

        private List<String> protocols = DefaultSdkAutoConstructList.getInstance();

        private String targetSelection;

        private AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig;

        private AwsJobPresignedUrlConfig awsJobPresignedUrlConfig;

        private AwsJobAbortConfig awsJobAbortConfig;

        private AwsJobTimeoutConfig awsJobTimeoutConfig;

        private List<OTAUpdateFile> files = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private Map<String, String> additionalParameters = DefaultSdkAutoConstructMap.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOtaUpdateRequest model) {
            super(model);
            otaUpdateId(model.otaUpdateId);
            description(model.description);
            targets(model.targets);
            protocolsWithStrings(model.protocols);
            targetSelection(model.targetSelection);
            awsJobExecutionsRolloutConfig(model.awsJobExecutionsRolloutConfig);
            awsJobPresignedUrlConfig(model.awsJobPresignedUrlConfig);
            awsJobAbortConfig(model.awsJobAbortConfig);
            awsJobTimeoutConfig(model.awsJobTimeoutConfig);
            files(model.files);
            roleArn(model.roleArn);
            additionalParameters(model.additionalParameters);
            tags(model.tags);
        }

        public final String getOtaUpdateId() {
            return otaUpdateId;
        }

        public final void setOtaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
        }

        @Override
        @Transient
        public final Builder otaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getTargets() {
            if (targets instanceof SdkAutoConstructList) {
                return null;
            }
            return targets;
        }

        public final void setTargets(Collection<String> targets) {
            this.targets = TargetsCopier.copy(targets);
        }

        @Override
        @Transient
        public final Builder targets(Collection<String> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targets(String... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        public final Collection<String> getProtocols() {
            if (protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return protocols;
        }

        public final void setProtocols(Collection<String> protocols) {
            this.protocols = ProtocolsCopier.copy(protocols);
        }

        @Override
        @Transient
        public final Builder protocolsWithStrings(Collection<String> protocols) {
            this.protocols = ProtocolsCopier.copy(protocols);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder protocolsWithStrings(String... protocols) {
            protocolsWithStrings(Arrays.asList(protocols));
            return this;
        }

        @Override
        @Transient
        public final Builder protocols(Collection<Protocol> protocols) {
            this.protocols = ProtocolsCopier.copyEnumToString(protocols);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder protocols(Protocol... protocols) {
            protocols(Arrays.asList(protocols));
            return this;
        }

        public final String getTargetSelection() {
            return targetSelection;
        }

        public final void setTargetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
        }

        @Override
        @Transient
        public final Builder targetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
            return this;
        }

        @Override
        @Transient
        public final Builder targetSelection(TargetSelection targetSelection) {
            this.targetSelection(targetSelection == null ? null : targetSelection.toString());
            return this;
        }

        public final AwsJobExecutionsRolloutConfig.Builder getAwsJobExecutionsRolloutConfig() {
            return awsJobExecutionsRolloutConfig != null ? awsJobExecutionsRolloutConfig.toBuilder() : null;
        }

        public final void setAwsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig.BuilderImpl awsJobExecutionsRolloutConfig) {
            this.awsJobExecutionsRolloutConfig = awsJobExecutionsRolloutConfig != null ? awsJobExecutionsRolloutConfig.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder awsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig) {
            this.awsJobExecutionsRolloutConfig = awsJobExecutionsRolloutConfig;
            return this;
        }

        public final AwsJobPresignedUrlConfig.Builder getAwsJobPresignedUrlConfig() {
            return awsJobPresignedUrlConfig != null ? awsJobPresignedUrlConfig.toBuilder() : null;
        }

        public final void setAwsJobPresignedUrlConfig(AwsJobPresignedUrlConfig.BuilderImpl awsJobPresignedUrlConfig) {
            this.awsJobPresignedUrlConfig = awsJobPresignedUrlConfig != null ? awsJobPresignedUrlConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder awsJobPresignedUrlConfig(AwsJobPresignedUrlConfig awsJobPresignedUrlConfig) {
            this.awsJobPresignedUrlConfig = awsJobPresignedUrlConfig;
            return this;
        }

        public final AwsJobAbortConfig.Builder getAwsJobAbortConfig() {
            return awsJobAbortConfig != null ? awsJobAbortConfig.toBuilder() : null;
        }

        public final void setAwsJobAbortConfig(AwsJobAbortConfig.BuilderImpl awsJobAbortConfig) {
            this.awsJobAbortConfig = awsJobAbortConfig != null ? awsJobAbortConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder awsJobAbortConfig(AwsJobAbortConfig awsJobAbortConfig) {
            this.awsJobAbortConfig = awsJobAbortConfig;
            return this;
        }

        public final AwsJobTimeoutConfig.Builder getAwsJobTimeoutConfig() {
            return awsJobTimeoutConfig != null ? awsJobTimeoutConfig.toBuilder() : null;
        }

        public final void setAwsJobTimeoutConfig(AwsJobTimeoutConfig.BuilderImpl awsJobTimeoutConfig) {
            this.awsJobTimeoutConfig = awsJobTimeoutConfig != null ? awsJobTimeoutConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder awsJobTimeoutConfig(AwsJobTimeoutConfig awsJobTimeoutConfig) {
            this.awsJobTimeoutConfig = awsJobTimeoutConfig;
            return this;
        }

        public final List<OTAUpdateFile.Builder> getFiles() {
            List<OTAUpdateFile.Builder> result = OTAUpdateFilesCopier.copyToBuilder(this.files);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFiles(Collection<OTAUpdateFile.BuilderImpl> files) {
            this.files = OTAUpdateFilesCopier.copyFromBuilder(files);
        }

        @Override
        @Transient
        public final Builder files(Collection<OTAUpdateFile> files) {
            this.files = OTAUpdateFilesCopier.copy(files);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder files(OTAUpdateFile... files) {
            files(Arrays.asList(files));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder files(Consumer<OTAUpdateFile.Builder>... files) {
            files(Stream.of(files).map(c -> OTAUpdateFile.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getAdditionalParameters() {
            if (additionalParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalParameters;
        }

        public final void setAdditionalParameters(Map<String, String> additionalParameters) {
            this.additionalParameters = AdditionalParameterMapCopier.copy(additionalParameters);
        }

        @Override
        @Transient
        public final Builder additionalParameters(Map<String, String> additionalParameters) {
            this.additionalParameters = AdditionalParameterMapCopier.copy(additionalParameters);
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOtaUpdateRequest build() {
            return new CreateOtaUpdateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
