/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateJobRequest extends IotRequest implements ToCopyableBuilder<UpdateJobRequest.Builder, UpdateJobRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(UpdateJobRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateJobRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<PresignedUrlConfig> PRESIGNED_URL_CONFIG_FIELD = SdkField
            .<PresignedUrlConfig> builder(MarshallingType.SDK_POJO).memberName("presignedUrlConfig")
            .getter(getter(UpdateJobRequest::presignedUrlConfig)).setter(setter(Builder::presignedUrlConfig))
            .constructor(PresignedUrlConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("presignedUrlConfig").build())
            .build();

    private static final SdkField<JobExecutionsRolloutConfig> JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD = SdkField
            .<JobExecutionsRolloutConfig> builder(MarshallingType.SDK_POJO)
            .memberName("jobExecutionsRolloutConfig")
            .getter(getter(UpdateJobRequest::jobExecutionsRolloutConfig))
            .setter(setter(Builder::jobExecutionsRolloutConfig))
            .constructor(JobExecutionsRolloutConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobExecutionsRolloutConfig").build())
            .build();

    private static final SdkField<AbortConfig> ABORT_CONFIG_FIELD = SdkField.<AbortConfig> builder(MarshallingType.SDK_POJO)
            .memberName("abortConfig").getter(getter(UpdateJobRequest::abortConfig)).setter(setter(Builder::abortConfig))
            .constructor(AbortConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("abortConfig").build()).build();

    private static final SdkField<TimeoutConfig> TIMEOUT_CONFIG_FIELD = SdkField
            .<TimeoutConfig> builder(MarshallingType.SDK_POJO).memberName("timeoutConfig")
            .getter(getter(UpdateJobRequest::timeoutConfig)).setter(setter(Builder::timeoutConfig))
            .constructor(TimeoutConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutConfig").build()).build();

    private static final SdkField<String> NAMESPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceId").getter(getter(UpdateJobRequest::namespaceId)).setter(setter(Builder::namespaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("namespaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            DESCRIPTION_FIELD, PRESIGNED_URL_CONFIG_FIELD, JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD, ABORT_CONFIG_FIELD,
            TIMEOUT_CONFIG_FIELD, NAMESPACE_ID_FIELD));

    private final String jobId;

    private final String description;

    private final PresignedUrlConfig presignedUrlConfig;

    private final JobExecutionsRolloutConfig jobExecutionsRolloutConfig;

    private final AbortConfig abortConfig;

    private final TimeoutConfig timeoutConfig;

    private final String namespaceId;

    private UpdateJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.description = builder.description;
        this.presignedUrlConfig = builder.presignedUrlConfig;
        this.jobExecutionsRolloutConfig = builder.jobExecutionsRolloutConfig;
        this.abortConfig = builder.abortConfig;
        this.timeoutConfig = builder.timeoutConfig;
        this.namespaceId = builder.namespaceId;
    }

    /**
     * <p>
     * The ID of the job to be updated.
     * </p>
     * 
     * @return The ID of the job to be updated.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * A short text description of the job.
     * </p>
     * 
     * @return A short text description of the job.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Configuration information for pre-signed S3 URLs.
     * </p>
     * 
     * @return Configuration information for pre-signed S3 URLs.
     */
    public final PresignedUrlConfig presignedUrlConfig() {
        return presignedUrlConfig;
    }

    /**
     * <p>
     * Allows you to create a staged rollout of the job.
     * </p>
     * 
     * @return Allows you to create a staged rollout of the job.
     */
    public final JobExecutionsRolloutConfig jobExecutionsRolloutConfig() {
        return jobExecutionsRolloutConfig;
    }

    /**
     * <p>
     * Allows you to create criteria to abort a job.
     * </p>
     * 
     * @return Allows you to create criteria to abort a job.
     */
    public final AbortConfig abortConfig() {
        return abortConfig;
    }

    /**
     * <p>
     * Specifies the amount of time each device has to finish its execution of the job. The timer is started when the
     * job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another
     * terminal state before the time expires, it will be automatically set to <code>TIMED_OUT</code>.
     * </p>
     * 
     * @return Specifies the amount of time each device has to finish its execution of the job. The timer is started
     *         when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set
     *         to another terminal state before the time expires, it will be automatically set to <code>TIMED_OUT</code>
     *         .
     */
    public final TimeoutConfig timeoutConfig() {
        return timeoutConfig;
    }

    /**
     * <p>
     * The namespace used to indicate that a job is a customer-managed job.
     * </p>
     * <p>
     * When you specify a value for this parameter, AWS IoT Core sends jobs notifications to MQTT topics that contain
     * the value in the following format.
     * </p>
     * <p>
     * <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code>
     * </p>
     * <note>
     * <p>
     * The <code>namespaceId</code> feature is in public preview.
     * </p>
     * </note>
     * 
     * @return The namespace used to indicate that a job is a customer-managed job.</p>
     *         <p>
     *         When you specify a value for this parameter, AWS IoT Core sends jobs notifications to MQTT topics that
     *         contain the value in the following format.
     *         </p>
     *         <p>
     *         <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code>
     *         </p>
     *         <note>
     *         <p>
     *         The <code>namespaceId</code> feature is in public preview.
     *         </p>
     */
    public final String namespaceId() {
        return namespaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(presignedUrlConfig());
        hashCode = 31 * hashCode + Objects.hashCode(jobExecutionsRolloutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(abortConfig());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobRequest)) {
            return false;
        }
        UpdateJobRequest other = (UpdateJobRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(description(), other.description())
                && Objects.equals(presignedUrlConfig(), other.presignedUrlConfig())
                && Objects.equals(jobExecutionsRolloutConfig(), other.jobExecutionsRolloutConfig())
                && Objects.equals(abortConfig(), other.abortConfig()) && Objects.equals(timeoutConfig(), other.timeoutConfig())
                && Objects.equals(namespaceId(), other.namespaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateJobRequest").add("JobId", jobId()).add("Description", description())
                .add("PresignedUrlConfig", presignedUrlConfig()).add("JobExecutionsRolloutConfig", jobExecutionsRolloutConfig())
                .add("AbortConfig", abortConfig()).add("TimeoutConfig", timeoutConfig()).add("NamespaceId", namespaceId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "presignedUrlConfig":
            return Optional.ofNullable(clazz.cast(presignedUrlConfig()));
        case "jobExecutionsRolloutConfig":
            return Optional.ofNullable(clazz.cast(jobExecutionsRolloutConfig()));
        case "abortConfig":
            return Optional.ofNullable(clazz.cast(abortConfig()));
        case "timeoutConfig":
            return Optional.ofNullable(clazz.cast(timeoutConfig()));
        case "namespaceId":
            return Optional.ofNullable(clazz.cast(namespaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateJobRequest, T> g) {
        return obj -> g.apply((UpdateJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateJobRequest> {
        /**
         * <p>
         * The ID of the job to be updated.
         * </p>
         * 
         * @param jobId
         *        The ID of the job to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * A short text description of the job.
         * </p>
         * 
         * @param description
         *        A short text description of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Configuration information for pre-signed S3 URLs.
         * </p>
         * 
         * @param presignedUrlConfig
         *        Configuration information for pre-signed S3 URLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presignedUrlConfig(PresignedUrlConfig presignedUrlConfig);

        /**
         * <p>
         * Configuration information for pre-signed S3 URLs.
         * </p>
         * This is a convenience that creates an instance of the {@link PresignedUrlConfig.Builder} avoiding the need to
         * create one manually via {@link PresignedUrlConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link PresignedUrlConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #presignedUrlConfig(PresignedUrlConfig)}.
         * 
         * @param presignedUrlConfig
         *        a consumer that will call methods on {@link PresignedUrlConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #presignedUrlConfig(PresignedUrlConfig)
         */
        default Builder presignedUrlConfig(Consumer<PresignedUrlConfig.Builder> presignedUrlConfig) {
            return presignedUrlConfig(PresignedUrlConfig.builder().applyMutation(presignedUrlConfig).build());
        }

        /**
         * <p>
         * Allows you to create a staged rollout of the job.
         * </p>
         * 
         * @param jobExecutionsRolloutConfig
         *        Allows you to create a staged rollout of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobExecutionsRolloutConfig(JobExecutionsRolloutConfig jobExecutionsRolloutConfig);

        /**
         * <p>
         * Allows you to create a staged rollout of the job.
         * </p>
         * This is a convenience that creates an instance of the {@link JobExecutionsRolloutConfig.Builder} avoiding the
         * need to create one manually via {@link JobExecutionsRolloutConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobExecutionsRolloutConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #jobExecutionsRolloutConfig(JobExecutionsRolloutConfig)}.
         * 
         * @param jobExecutionsRolloutConfig
         *        a consumer that will call methods on {@link JobExecutionsRolloutConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobExecutionsRolloutConfig(JobExecutionsRolloutConfig)
         */
        default Builder jobExecutionsRolloutConfig(Consumer<JobExecutionsRolloutConfig.Builder> jobExecutionsRolloutConfig) {
            return jobExecutionsRolloutConfig(JobExecutionsRolloutConfig.builder().applyMutation(jobExecutionsRolloutConfig)
                    .build());
        }

        /**
         * <p>
         * Allows you to create criteria to abort a job.
         * </p>
         * 
         * @param abortConfig
         *        Allows you to create criteria to abort a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortConfig(AbortConfig abortConfig);

        /**
         * <p>
         * Allows you to create criteria to abort a job.
         * </p>
         * This is a convenience that creates an instance of the {@link AbortConfig.Builder} avoiding the need to create
         * one manually via {@link AbortConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AbortConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #abortConfig(AbortConfig)}.
         * 
         * @param abortConfig
         *        a consumer that will call methods on {@link AbortConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #abortConfig(AbortConfig)
         */
        default Builder abortConfig(Consumer<AbortConfig.Builder> abortConfig) {
            return abortConfig(AbortConfig.builder().applyMutation(abortConfig).build());
        }

        /**
         * <p>
         * Specifies the amount of time each device has to finish its execution of the job. The timer is started when
         * the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to
         * another terminal state before the time expires, it will be automatically set to <code>TIMED_OUT</code>.
         * </p>
         * 
         * @param timeoutConfig
         *        Specifies the amount of time each device has to finish its execution of the job. The timer is started
         *        when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not
         *        set to another terminal state before the time expires, it will be automatically set to
         *        <code>TIMED_OUT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutConfig(TimeoutConfig timeoutConfig);

        /**
         * <p>
         * Specifies the amount of time each device has to finish its execution of the job. The timer is started when
         * the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to
         * another terminal state before the time expires, it will be automatically set to <code>TIMED_OUT</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link TimeoutConfig.Builder} avoiding the need to
         * create one manually via {@link TimeoutConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimeoutConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #timeoutConfig(TimeoutConfig)}.
         * 
         * @param timeoutConfig
         *        a consumer that will call methods on {@link TimeoutConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeoutConfig(TimeoutConfig)
         */
        default Builder timeoutConfig(Consumer<TimeoutConfig.Builder> timeoutConfig) {
            return timeoutConfig(TimeoutConfig.builder().applyMutation(timeoutConfig).build());
        }

        /**
         * <p>
         * The namespace used to indicate that a job is a customer-managed job.
         * </p>
         * <p>
         * When you specify a value for this parameter, AWS IoT Core sends jobs notifications to MQTT topics that
         * contain the value in the following format.
         * </p>
         * <p>
         * <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code>
         * </p>
         * <note>
         * <p>
         * The <code>namespaceId</code> feature is in public preview.
         * </p>
         * </note>
         * 
         * @param namespaceId
         *        The namespace used to indicate that a job is a customer-managed job.</p>
         *        <p>
         *        When you specify a value for this parameter, AWS IoT Core sends jobs notifications to MQTT topics that
         *        contain the value in the following format.
         *        </p>
         *        <p>
         *        <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code>
         *        </p>
         *        <note>
         *        <p>
         *        The <code>namespaceId</code> feature is in public preview.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceId(String namespaceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String jobId;

        private String description;

        private PresignedUrlConfig presignedUrlConfig;

        private JobExecutionsRolloutConfig jobExecutionsRolloutConfig;

        private AbortConfig abortConfig;

        private TimeoutConfig timeoutConfig;

        private String namespaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobRequest model) {
            super(model);
            jobId(model.jobId);
            description(model.description);
            presignedUrlConfig(model.presignedUrlConfig);
            jobExecutionsRolloutConfig(model.jobExecutionsRolloutConfig);
            abortConfig(model.abortConfig);
            timeoutConfig(model.timeoutConfig);
            namespaceId(model.namespaceId);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        @Transient
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final PresignedUrlConfig.Builder getPresignedUrlConfig() {
            return presignedUrlConfig != null ? presignedUrlConfig.toBuilder() : null;
        }

        public final void setPresignedUrlConfig(PresignedUrlConfig.BuilderImpl presignedUrlConfig) {
            this.presignedUrlConfig = presignedUrlConfig != null ? presignedUrlConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder presignedUrlConfig(PresignedUrlConfig presignedUrlConfig) {
            this.presignedUrlConfig = presignedUrlConfig;
            return this;
        }

        public final JobExecutionsRolloutConfig.Builder getJobExecutionsRolloutConfig() {
            return jobExecutionsRolloutConfig != null ? jobExecutionsRolloutConfig.toBuilder() : null;
        }

        public final void setJobExecutionsRolloutConfig(JobExecutionsRolloutConfig.BuilderImpl jobExecutionsRolloutConfig) {
            this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig != null ? jobExecutionsRolloutConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder jobExecutionsRolloutConfig(JobExecutionsRolloutConfig jobExecutionsRolloutConfig) {
            this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig;
            return this;
        }

        public final AbortConfig.Builder getAbortConfig() {
            return abortConfig != null ? abortConfig.toBuilder() : null;
        }

        public final void setAbortConfig(AbortConfig.BuilderImpl abortConfig) {
            this.abortConfig = abortConfig != null ? abortConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder abortConfig(AbortConfig abortConfig) {
            this.abortConfig = abortConfig;
            return this;
        }

        public final TimeoutConfig.Builder getTimeoutConfig() {
            return timeoutConfig != null ? timeoutConfig.toBuilder() : null;
        }

        public final void setTimeoutConfig(TimeoutConfig.BuilderImpl timeoutConfig) {
            this.timeoutConfig = timeoutConfig != null ? timeoutConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder timeoutConfig(TimeoutConfig timeoutConfig) {
            this.timeoutConfig = timeoutConfig;
            return this;
        }

        public final String getNamespaceId() {
            return namespaceId;
        }

        public final void setNamespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
        }

        @Override
        @Transient
        public final Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateJobRequest build() {
            return new UpdateJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
